/*
 * Decompiled with CFR 0.152.
 */
package com.github.testpress.mikephil.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.github.testpress.mikephil.charting.components.AxisBase;
import com.github.testpress.mikephil.charting.renderer.Renderer;
import com.github.testpress.mikephil.charting.utils.MPPointD;
import com.github.testpress.mikephil.charting.utils.Transformer;
import com.github.testpress.mikephil.charting.utils.Utils;
import com.github.testpress.mikephil.charting.utils.ViewPortHandler;

public abstract class AxisRenderer
extends Renderer {
    protected AxisBase mAxis;
    protected Transformer mTrans;
    protected Paint mGridPaint;
    protected Paint mAxisLabelPaint;
    protected Paint mAxisLinePaint;
    protected Paint mLimitLinePaint;

    public AxisRenderer(ViewPortHandler viewPortHandler, Transformer trans, AxisBase axis) {
        super(viewPortHandler);
        this.mTrans = trans;
        this.mAxis = axis;
        if (this.mViewPortHandler != null) {
            this.mAxisLabelPaint = new Paint(1);
            this.mGridPaint = new Paint();
            this.mGridPaint.setColor(-7829368);
            this.mGridPaint.setStrokeWidth(1.0f);
            this.mGridPaint.setStyle(Paint.Style.STROKE);
            this.mGridPaint.setAlpha(90);
            this.mAxisLinePaint = new Paint();
            this.mAxisLinePaint.setColor(-16777216);
            this.mAxisLinePaint.setStrokeWidth(1.0f);
            this.mAxisLinePaint.setStyle(Paint.Style.STROKE);
            this.mLimitLinePaint = new Paint(1);
            this.mLimitLinePaint.setStyle(Paint.Style.STROKE);
        }
    }

    public Paint getPaintAxisLabels() {
        return this.mAxisLabelPaint;
    }

    public Paint getPaintGrid() {
        return this.mGridPaint;
    }

    public Paint getPaintAxisLine() {
        return this.mAxisLinePaint;
    }

    public Transformer getTransformer() {
        return this.mTrans;
    }

    public void computeAxis(float min, float max, boolean inverted) {
        if (this.mViewPortHandler != null && this.mViewPortHandler.contentWidth() > 10.0f && !this.mViewPortHandler.isFullyZoomedOutY()) {
            MPPointD p1 = this.mTrans.getValuesByTouchPoint(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentTop());
            MPPointD p2 = this.mTrans.getValuesByTouchPoint(this.mViewPortHandler.contentLeft(), this.mViewPortHandler.contentBottom());
            if (!inverted) {
                min = (float)p2.y;
                max = (float)p1.y;
            } else {
                min = (float)p1.y;
                max = (float)p2.y;
            }
            MPPointD.recycleInstance(p1);
            MPPointD.recycleInstance(p2);
        }
        this.computeAxisValues(min, max);
    }

    protected void computeAxisValues(float min, float max) {
        boolean centeringEnabled;
        int n;
        double intervalMagnitude;
        int intervalSigDigit;
        float yMin = min;
        float yMax = max;
        int labelCount = this.mAxis.getLabelCount();
        double range = Math.abs(yMax - yMin);
        if (labelCount == 0 || range <= 0.0) {
            this.mAxis.mEntries = new float[0];
            this.mAxis.mEntryCount = 0;
            return;
        }
        double rawInterval = range / (double)labelCount;
        double interval = Utils.roundToNextSignificant(rawInterval);
        if (this.mAxis.isGranularityEnabled()) {
            double d = interval = interval < (double)this.mAxis.getGranularity() ? (double)this.mAxis.getGranularity() : interval;
        }
        if ((intervalSigDigit = (int)(interval / (intervalMagnitude = (double)Utils.roundToNextSignificant(Math.pow(10.0, (int)Math.log10(interval)))))) > 5) {
            interval = Math.floor(10.0 * intervalMagnitude);
        }
        int n2 = n = (centeringEnabled = this.mAxis.isCenterAxisLabelsEnabled()) ? 1 : 0;
        if (this.mAxis.isForceLabelsEnabled()) {
            float step = (float)range / (float)(labelCount - 1);
            this.mAxis.mEntryCount = labelCount;
            if (this.mAxis.mEntries.length < labelCount) {
                this.mAxis.mEntries = new float[labelCount];
            }
            float v = min;
            for (int i = 0; i < labelCount; ++i) {
                this.mAxis.mEntries[i] = v;
                v += step;
            }
            n = labelCount;
        } else {
            double f;
            double last;
            double first;
            double d = first = interval == 0.0 ? 0.0 : Math.ceil((double)yMin / interval) * interval;
            if (centeringEnabled) {
                first -= interval;
            }
            double d2 = last = interval == 0.0 ? 0.0 : Utils.nextUp(Math.floor((double)yMax / interval) * interval);
            if (interval != 0.0) {
                for (f = first; f <= last; f += interval) {
                    ++n;
                }
            }
            this.mAxis.mEntryCount = n;
            if (this.mAxis.mEntries.length < n) {
                this.mAxis.mEntries = new float[n];
            }
            f = first;
            for (int i = 0; i < n; ++i) {
                if (f == 0.0) {
                    f = 0.0;
                }
                this.mAxis.mEntries[i] = (float)f;
                f += interval;
            }
        }
        this.mAxis.mDecimals = interval < 1.0 ? (int)Math.ceil(-Math.log10(interval)) : 0;
        if (centeringEnabled) {
            if (this.mAxis.mCenteredEntries.length < n) {
                this.mAxis.mCenteredEntries = new float[n];
            }
            float offset = (this.mAxis.mEntries[1] - this.mAxis.mEntries[0]) / 2.0f;
            for (int i = 0; i < n; ++i) {
                this.mAxis.mCenteredEntries[i] = this.mAxis.mEntries[i] + offset;
            }
        }
    }

    public abstract void renderAxisLabels(Canvas var1);

    public abstract void renderGridLines(Canvas var1);

    public abstract void renderAxisLine(Canvas var1);

    public abstract void renderLimitLines(Canvas var1);
}

