/*
 * Decompiled with CFR 0.152.
 */
package com.github.testpress.mikephil.charting.jobs;

import android.graphics.Matrix;
import android.view.View;
import com.github.testpress.mikephil.charting.charts.BarLineChartBase;
import com.github.testpress.mikephil.charting.components.YAxis;
import com.github.testpress.mikephil.charting.jobs.ViewPortJob;
import com.github.testpress.mikephil.charting.utils.ObjectPool;
import com.github.testpress.mikephil.charting.utils.Transformer;
import com.github.testpress.mikephil.charting.utils.ViewPortHandler;

public class ZoomJob
extends ViewPortJob {
    private static ObjectPool<ZoomJob> pool = ObjectPool.create(1, new ZoomJob(null, 0.0f, 0.0f, 0.0f, 0.0f, null, null, null));
    protected float scaleX;
    protected float scaleY;
    protected YAxis.AxisDependency axisDependency;
    protected Matrix mRunMatrixBuffer = new Matrix();

    public static ZoomJob getInstance(ViewPortHandler viewPortHandler, float scaleX, float scaleY, float xValue, float yValue, Transformer trans, YAxis.AxisDependency axis, View v) {
        ZoomJob result = pool.get();
        result.xValue = xValue;
        result.yValue = yValue;
        result.scaleX = scaleX;
        result.scaleY = scaleY;
        result.mViewPortHandler = viewPortHandler;
        result.mTrans = trans;
        result.axisDependency = axis;
        result.view = v;
        return result;
    }

    public static void recycleInstance(ZoomJob instance) {
        pool.recycle(instance);
    }

    public ZoomJob(ViewPortHandler viewPortHandler, float scaleX, float scaleY, float xValue, float yValue, Transformer trans, YAxis.AxisDependency axis, View v) {
        super(viewPortHandler, xValue, yValue, trans, v);
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.axisDependency = axis;
    }

    @Override
    public void run() {
        Matrix save = this.mRunMatrixBuffer;
        this.mViewPortHandler.zoom(this.scaleX, this.scaleY, save);
        this.mViewPortHandler.refresh(save, this.view, false);
        float valsInView = ((BarLineChartBase)this.view).getDeltaY(this.axisDependency) / this.mViewPortHandler.getScaleY();
        float xsInView = ((BarLineChartBase)this.view).getXAxis().mAxisRange / this.mViewPortHandler.getScaleX();
        this.pts[0] = this.xValue - xsInView / 2.0f;
        this.pts[1] = this.yValue + valsInView / 2.0f;
        this.mTrans.pointValuesToPixel(this.pts);
        this.mViewPortHandler.translate(this.pts, save);
        this.mViewPortHandler.refresh(save, this.view, false);
        ((BarLineChartBase)this.view).calculateOffsets();
        this.view.postInvalidate();
        ZoomJob.recycleInstance(this);
    }

    @Override
    protected ObjectPool.Poolable instantiate() {
        return new ZoomJob(null, 0.0f, 0.0f, 0.0f, 0.0f, null, null, null);
    }

    static {
        pool.setReplenishPercentage(0.5f);
    }
}

