/*
 * Decompiled with CFR 0.152.
 */
package com.github.testpress.mikephil.charting.jobs;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.graphics.Matrix;
import android.view.View;
import com.github.testpress.mikephil.charting.charts.BarLineChartBase;
import com.github.testpress.mikephil.charting.components.YAxis;
import com.github.testpress.mikephil.charting.jobs.AnimatedViewPortJob;
import com.github.testpress.mikephil.charting.utils.ObjectPool;
import com.github.testpress.mikephil.charting.utils.Transformer;
import com.github.testpress.mikephil.charting.utils.ViewPortHandler;

@SuppressLint(value={"NewApi"})
public class AnimatedZoomJob
extends AnimatedViewPortJob
implements Animator.AnimatorListener {
    private static ObjectPool<AnimatedZoomJob> pool = ObjectPool.create(8, new AnimatedZoomJob(null, null, null, null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0L));
    protected float zoomOriginX;
    protected float zoomOriginY;
    protected float zoomCenterX;
    protected float zoomCenterY;
    protected YAxis yAxis;
    protected float xAxisRange;
    protected Matrix mOnAnimationUpdateMatrixBuffer = new Matrix();

    public static AnimatedZoomJob getInstance(ViewPortHandler viewPortHandler, View v, Transformer trans, YAxis axis, float xAxisRange, float scaleX, float scaleY, float xOrigin, float yOrigin, float zoomCenterX, float zoomCenterY, float zoomOriginX, float zoomOriginY, long duration) {
        AnimatedZoomJob result = pool.get();
        result.mViewPortHandler = viewPortHandler;
        result.xValue = scaleX;
        result.yValue = scaleY;
        result.mTrans = trans;
        result.view = v;
        result.xOrigin = xOrigin;
        result.yOrigin = yOrigin;
        result.resetAnimator();
        result.animator.setDuration(duration);
        return result;
    }

    @SuppressLint(value={"NewApi"})
    public AnimatedZoomJob(ViewPortHandler viewPortHandler, View v, Transformer trans, YAxis axis, float xAxisRange, float scaleX, float scaleY, float xOrigin, float yOrigin, float zoomCenterX, float zoomCenterY, float zoomOriginX, float zoomOriginY, long duration) {
        super(viewPortHandler, scaleX, scaleY, trans, v, xOrigin, yOrigin, duration);
        this.zoomCenterX = zoomCenterX;
        this.zoomCenterY = zoomCenterY;
        this.zoomOriginX = zoomOriginX;
        this.zoomOriginY = zoomOriginY;
        this.animator.addListener((Animator.AnimatorListener)this);
        this.yAxis = axis;
        this.xAxisRange = xAxisRange;
    }

    @Override
    public void onAnimationUpdate(ValueAnimator animation) {
        float scaleX = this.xOrigin + (this.xValue - this.xOrigin) * this.phase;
        float scaleY = this.yOrigin + (this.yValue - this.yOrigin) * this.phase;
        Matrix save = this.mOnAnimationUpdateMatrixBuffer;
        this.mViewPortHandler.setZoom(scaleX, scaleY, save);
        this.mViewPortHandler.refresh(save, this.view, false);
        float valsInView = this.yAxis.mAxisRange / this.mViewPortHandler.getScaleY();
        float xsInView = this.xAxisRange / this.mViewPortHandler.getScaleX();
        this.pts[0] = this.zoomOriginX + (this.zoomCenterX - xsInView / 2.0f - this.zoomOriginX) * this.phase;
        this.pts[1] = this.zoomOriginY + (this.zoomCenterY + valsInView / 2.0f - this.zoomOriginY) * this.phase;
        this.mTrans.pointValuesToPixel(this.pts);
        this.mViewPortHandler.translate(this.pts, save);
        this.mViewPortHandler.refresh(save, this.view, true);
    }

    @Override
    public void onAnimationEnd(Animator animation) {
        ((BarLineChartBase)this.view).calculateOffsets();
        this.view.postInvalidate();
    }

    @Override
    public void onAnimationCancel(Animator animation) {
    }

    @Override
    public void onAnimationRepeat(Animator animation) {
    }

    @Override
    public void recycleSelf() {
    }

    @Override
    public void onAnimationStart(Animator animation) {
    }

    @Override
    protected ObjectPool.Poolable instantiate() {
        return new AnimatedZoomJob(null, null, null, null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0L);
    }
}

