/*
 * Decompiled with CFR 0.152.
 */
package com.github.testpress.mikephil.charting.animation;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.os.Build;
import com.github.testpress.mikephil.charting.animation.Easing;
import com.github.testpress.mikephil.charting.animation.EasingFunction;

public class ChartAnimator {
    private ValueAnimator.AnimatorUpdateListener mListener;
    protected float mPhaseY = 1.0f;
    protected float mPhaseX = 1.0f;

    public ChartAnimator() {
    }

    public ChartAnimator(ValueAnimator.AnimatorUpdateListener listener) {
        this.mListener = listener;
    }

    public void animateXY(int durationMillisX, int durationMillisY, EasingFunction easingX, EasingFunction easingY) {
        if (Build.VERSION.SDK_INT < 11) {
            return;
        }
        ObjectAnimator animatorY = ObjectAnimator.ofFloat((Object)this, (String)"phaseY", (float[])new float[]{0.0f, 1.0f});
        animatorY.setInterpolator((TimeInterpolator)easingY);
        animatorY.setDuration((long)durationMillisY);
        ObjectAnimator animatorX = ObjectAnimator.ofFloat((Object)this, (String)"phaseX", (float[])new float[]{0.0f, 1.0f});
        animatorX.setInterpolator((TimeInterpolator)easingX);
        animatorX.setDuration((long)durationMillisX);
        if (durationMillisX > durationMillisY) {
            animatorX.addUpdateListener(this.mListener);
        } else {
            animatorY.addUpdateListener(this.mListener);
        }
        animatorX.start();
        animatorY.start();
    }

    public void animateX(int durationMillis, EasingFunction easing) {
        if (Build.VERSION.SDK_INT < 11) {
            return;
        }
        ObjectAnimator animatorX = ObjectAnimator.ofFloat((Object)this, (String)"phaseX", (float[])new float[]{0.0f, 1.0f});
        animatorX.setInterpolator((TimeInterpolator)easing);
        animatorX.setDuration((long)durationMillis);
        animatorX.addUpdateListener(this.mListener);
        animatorX.start();
    }

    public void animateY(int durationMillis, EasingFunction easing) {
        if (Build.VERSION.SDK_INT < 11) {
            return;
        }
        ObjectAnimator animatorY = ObjectAnimator.ofFloat((Object)this, (String)"phaseY", (float[])new float[]{0.0f, 1.0f});
        animatorY.setInterpolator((TimeInterpolator)easing);
        animatorY.setDuration((long)durationMillis);
        animatorY.addUpdateListener(this.mListener);
        animatorY.start();
    }

    public void animateXY(int durationMillisX, int durationMillisY, Easing.EasingOption easingX, Easing.EasingOption easingY) {
        if (Build.VERSION.SDK_INT < 11) {
            return;
        }
        ObjectAnimator animatorY = ObjectAnimator.ofFloat((Object)this, (String)"phaseY", (float[])new float[]{0.0f, 1.0f});
        animatorY.setInterpolator((TimeInterpolator)Easing.getEasingFunctionFromOption(easingY));
        animatorY.setDuration((long)durationMillisY);
        ObjectAnimator animatorX = ObjectAnimator.ofFloat((Object)this, (String)"phaseX", (float[])new float[]{0.0f, 1.0f});
        animatorX.setInterpolator((TimeInterpolator)Easing.getEasingFunctionFromOption(easingX));
        animatorX.setDuration((long)durationMillisX);
        if (durationMillisX > durationMillisY) {
            animatorX.addUpdateListener(this.mListener);
        } else {
            animatorY.addUpdateListener(this.mListener);
        }
        animatorX.start();
        animatorY.start();
    }

    public void animateX(int durationMillis, Easing.EasingOption easing) {
        if (Build.VERSION.SDK_INT < 11) {
            return;
        }
        ObjectAnimator animatorX = ObjectAnimator.ofFloat((Object)this, (String)"phaseX", (float[])new float[]{0.0f, 1.0f});
        animatorX.setInterpolator((TimeInterpolator)Easing.getEasingFunctionFromOption(easing));
        animatorX.setDuration((long)durationMillis);
        animatorX.addUpdateListener(this.mListener);
        animatorX.start();
    }

    public void animateY(int durationMillis, Easing.EasingOption easing) {
        if (Build.VERSION.SDK_INT < 11) {
            return;
        }
        ObjectAnimator animatorY = ObjectAnimator.ofFloat((Object)this, (String)"phaseY", (float[])new float[]{0.0f, 1.0f});
        animatorY.setInterpolator((TimeInterpolator)Easing.getEasingFunctionFromOption(easing));
        animatorY.setDuration((long)durationMillis);
        animatorY.addUpdateListener(this.mListener);
        animatorY.start();
    }

    public void animateXY(int durationMillisX, int durationMillisY) {
        if (Build.VERSION.SDK_INT < 11) {
            return;
        }
        ObjectAnimator animatorY = ObjectAnimator.ofFloat((Object)this, (String)"phaseY", (float[])new float[]{0.0f, 1.0f});
        animatorY.setDuration((long)durationMillisY);
        ObjectAnimator animatorX = ObjectAnimator.ofFloat((Object)this, (String)"phaseX", (float[])new float[]{0.0f, 1.0f});
        animatorX.setDuration((long)durationMillisX);
        if (durationMillisX > durationMillisY) {
            animatorX.addUpdateListener(this.mListener);
        } else {
            animatorY.addUpdateListener(this.mListener);
        }
        animatorX.start();
        animatorY.start();
    }

    public void animateX(int durationMillis) {
        if (Build.VERSION.SDK_INT < 11) {
            return;
        }
        ObjectAnimator animatorX = ObjectAnimator.ofFloat((Object)this, (String)"phaseX", (float[])new float[]{0.0f, 1.0f});
        animatorX.setDuration((long)durationMillis);
        animatorX.addUpdateListener(this.mListener);
        animatorX.start();
    }

    public void animateY(int durationMillis) {
        if (Build.VERSION.SDK_INT < 11) {
            return;
        }
        ObjectAnimator animatorY = ObjectAnimator.ofFloat((Object)this, (String)"phaseY", (float[])new float[]{0.0f, 1.0f});
        animatorY.setDuration((long)durationMillis);
        animatorY.addUpdateListener(this.mListener);
        animatorY.start();
    }

    public float getPhaseY() {
        return this.mPhaseY;
    }

    public void setPhaseY(float phase) {
        this.mPhaseY = phase;
    }

    public float getPhaseX() {
        return this.mPhaseX;
    }

    public void setPhaseX(float phase) {
        this.mPhaseX = phase;
    }
}

