/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.components;

import android.graphics.Paint;
import com.github.mikephil.charting.components.ComponentBase;
import com.github.mikephil.charting.utils.FSize;
import com.github.mikephil.charting.utils.Utils;
import com.github.mikephil.charting.utils.ViewPortHandler;
import java.util.ArrayList;
import java.util.List;

public class Legend
extends ComponentBase {
    private int[] mColors;
    private String[] mLabels;
    private int[] mExtraColors;
    private String[] mExtraLabels;
    private boolean mIsLegendCustom = false;
    private LegendHorizontalAlignment mHorizontalAlignment = LegendHorizontalAlignment.LEFT;
    private LegendVerticalAlignment mVerticalAlignment = LegendVerticalAlignment.BOTTOM;
    private LegendOrientation mOrientation = LegendOrientation.HORIZONTAL;
    private boolean mDrawInside = false;
    private LegendDirection mDirection = LegendDirection.LEFT_TO_RIGHT;
    private LegendForm mShape = LegendForm.SQUARE;
    private float mFormSize = 8.0f;
    private float mXEntrySpace = 6.0f;
    private float mYEntrySpace = 0.0f;
    private float mFormToTextSpace = 5.0f;
    private float mStackSpace = 3.0f;
    private float mMaxSizePercent = 0.95f;
    public float mNeededWidth = 0.0f;
    public float mNeededHeight = 0.0f;
    public float mTextHeightMax = 0.0f;
    public float mTextWidthMax = 0.0f;
    private boolean mWordWrapEnabled = false;
    private boolean isCalculatedLineSizesArrayListResized = true;
    private FSize[] mCalculatedLabelSizes = new FSize[0];
    private Boolean[] mCalculatedLabelBreakPoints = new Boolean[0];
    private FSize[] mCalculatedLineSizes = new FSize[0];
    protected Paint.FontMetrics fontMetricsForCalculateDimensions = new Paint.FontMetrics();
    protected ArrayList<FSize> calculatedLineSizesForCalculateDimensions = new ArrayList();

    public Legend() {
        this.mFormSize = Utils.convertDpToPixel(8.0f);
        this.mXEntrySpace = Utils.convertDpToPixel(6.0f);
        this.mYEntrySpace = Utils.convertDpToPixel(0.0f);
        this.mFormToTextSpace = Utils.convertDpToPixel(5.0f);
        this.mTextSize = Utils.convertDpToPixel(10.0f);
        this.mStackSpace = Utils.convertDpToPixel(3.0f);
        this.mXOffset = Utils.convertDpToPixel(5.0f);
        this.mYOffset = Utils.convertDpToPixel(3.0f);
    }

    public Legend(int[] colors, String[] labels) {
        this();
        if (colors == null || labels == null) {
            throw new IllegalArgumentException("colors array or labels array is NULL");
        }
        if (colors.length != labels.length) {
            throw new IllegalArgumentException("colors array and labels array need to be of same size");
        }
        this.mColors = colors;
        this.mLabels = labels;
    }

    public Legend(List<Integer> colors, List<String> labels) {
        this();
        if (colors == null || labels == null) {
            throw new IllegalArgumentException("colors array or labels array is NULL");
        }
        if (colors.size() != labels.size()) {
            throw new IllegalArgumentException("colors array and labels array need to be of same size");
        }
        this.setComputedColors(colors);
        this.setComputedLabels(labels);
    }

    public void setComputedColors(List<Integer> colors) {
        if (this.mColors != null && colors.size() == this.mColors.length) {
            Utils.copyIntegers(colors, this.mColors);
        } else {
            this.mColors = Utils.convertIntegers(colors);
        }
    }

    public void setComputedLabels(List<String> labels) {
        if (this.mLabels != null && this.mLabels.length == labels.size()) {
            Utils.copyStrings(labels, this.mLabels);
        } else {
            this.mLabels = Utils.convertStrings(labels);
        }
    }

    public float getMaximumEntryWidth(Paint p) {
        float max = 0.0f;
        for (int i = 0; i < this.mLabels.length; ++i) {
            float length;
            if (this.mLabels[i] == null || !((length = (float)Utils.calcTextWidth(p, this.mLabels[i])) > max)) continue;
            max = length;
        }
        return max + this.mFormSize + this.mFormToTextSpace;
    }

    public float getMaximumEntryHeight(Paint p) {
        float max = 0.0f;
        for (int i = 0; i < this.mLabels.length; ++i) {
            float length;
            if (this.mLabels[i] == null || !((length = (float)Utils.calcTextHeight(p, this.mLabels[i])) > max)) continue;
            max = length;
        }
        return max;
    }

    public int[] getColors() {
        return this.mColors;
    }

    public String[] getLabels() {
        return this.mLabels;
    }

    public String getLabel(int index) {
        return this.mLabels[index];
    }

    public int[] getExtraColors() {
        return this.mExtraColors;
    }

    public String[] getExtraLabels() {
        return this.mExtraLabels;
    }

    public void setExtra(List<Integer> colors, List<String> labels) {
        if (this.mExtraColors != null && this.mExtraColors.length == colors.size()) {
            Utils.copyIntegers(colors, this.mExtraColors);
        } else {
            this.mExtraColors = Utils.convertIntegers(colors);
        }
        if (this.mExtraLabels != null && this.mExtraLabels.length == labels.size()) {
            Utils.copyStrings(labels, this.mExtraLabels);
        } else {
            this.mExtraLabels = Utils.convertStrings(labels);
        }
    }

    public void setExtra(int[] colors, String[] labels) {
        this.mExtraColors = colors;
        this.mExtraLabels = labels;
    }

    public void setCustom(int[] colors, String[] labels) {
        if (colors.length != labels.length) {
            throw new IllegalArgumentException("colors array and labels array need to be of same size");
        }
        this.mLabels = labels;
        this.mColors = colors;
        this.mIsLegendCustom = true;
    }

    public void setCustom(List<Integer> colors, List<String> labels) {
        if (colors.size() != labels.size()) {
            throw new IllegalArgumentException("colors array and labels array need to be of same size");
        }
        this.setComputedColors(colors);
        this.setComputedLabels(labels);
        this.mIsLegendCustom = true;
    }

    public void resetCustom() {
        this.mIsLegendCustom = false;
    }

    public boolean isLegendCustom() {
        return this.mIsLegendCustom;
    }

    public LegendPosition getPosition() {
        if (this.mOrientation == LegendOrientation.VERTICAL && this.mHorizontalAlignment == LegendHorizontalAlignment.CENTER && this.mVerticalAlignment == LegendVerticalAlignment.CENTER) {
            return LegendPosition.PIECHART_CENTER;
        }
        if (this.mOrientation == LegendOrientation.HORIZONTAL) {
            if (this.mVerticalAlignment == LegendVerticalAlignment.TOP) {
                return this.mHorizontalAlignment == LegendHorizontalAlignment.LEFT ? LegendPosition.ABOVE_CHART_LEFT : (this.mHorizontalAlignment == LegendHorizontalAlignment.RIGHT ? LegendPosition.ABOVE_CHART_RIGHT : LegendPosition.ABOVE_CHART_CENTER);
            }
            return this.mHorizontalAlignment == LegendHorizontalAlignment.LEFT ? LegendPosition.BELOW_CHART_LEFT : (this.mHorizontalAlignment == LegendHorizontalAlignment.RIGHT ? LegendPosition.BELOW_CHART_RIGHT : LegendPosition.BELOW_CHART_CENTER);
        }
        if (this.mHorizontalAlignment == LegendHorizontalAlignment.LEFT) {
            return this.mVerticalAlignment == LegendVerticalAlignment.TOP && this.mDrawInside ? LegendPosition.LEFT_OF_CHART_INSIDE : (this.mVerticalAlignment == LegendVerticalAlignment.CENTER ? LegendPosition.LEFT_OF_CHART_CENTER : LegendPosition.LEFT_OF_CHART);
        }
        return this.mVerticalAlignment == LegendVerticalAlignment.TOP && this.mDrawInside ? LegendPosition.RIGHT_OF_CHART_INSIDE : (this.mVerticalAlignment == LegendVerticalAlignment.CENTER ? LegendPosition.RIGHT_OF_CHART_CENTER : LegendPosition.RIGHT_OF_CHART);
    }

    public void setPosition(LegendPosition newValue) {
        switch (newValue) {
            case LEFT_OF_CHART: 
            case LEFT_OF_CHART_INSIDE: 
            case LEFT_OF_CHART_CENTER: {
                this.mHorizontalAlignment = LegendHorizontalAlignment.LEFT;
                this.mVerticalAlignment = newValue == LegendPosition.LEFT_OF_CHART_CENTER ? LegendVerticalAlignment.CENTER : LegendVerticalAlignment.TOP;
                this.mOrientation = LegendOrientation.VERTICAL;
                break;
            }
            case RIGHT_OF_CHART: 
            case RIGHT_OF_CHART_INSIDE: 
            case RIGHT_OF_CHART_CENTER: {
                this.mHorizontalAlignment = LegendHorizontalAlignment.RIGHT;
                this.mVerticalAlignment = newValue == LegendPosition.RIGHT_OF_CHART_CENTER ? LegendVerticalAlignment.CENTER : LegendVerticalAlignment.TOP;
                this.mOrientation = LegendOrientation.VERTICAL;
                break;
            }
            case ABOVE_CHART_LEFT: 
            case ABOVE_CHART_CENTER: 
            case ABOVE_CHART_RIGHT: {
                this.mHorizontalAlignment = newValue == LegendPosition.ABOVE_CHART_LEFT ? LegendHorizontalAlignment.LEFT : (newValue == LegendPosition.ABOVE_CHART_RIGHT ? LegendHorizontalAlignment.RIGHT : LegendHorizontalAlignment.CENTER);
                this.mVerticalAlignment = LegendVerticalAlignment.TOP;
                this.mOrientation = LegendOrientation.HORIZONTAL;
                break;
            }
            case BELOW_CHART_LEFT: 
            case BELOW_CHART_CENTER: 
            case BELOW_CHART_RIGHT: {
                this.mHorizontalAlignment = newValue == LegendPosition.BELOW_CHART_LEFT ? LegendHorizontalAlignment.LEFT : (newValue == LegendPosition.BELOW_CHART_RIGHT ? LegendHorizontalAlignment.RIGHT : LegendHorizontalAlignment.CENTER);
                this.mVerticalAlignment = LegendVerticalAlignment.BOTTOM;
                this.mOrientation = LegendOrientation.HORIZONTAL;
                break;
            }
            case PIECHART_CENTER: {
                this.mHorizontalAlignment = LegendHorizontalAlignment.CENTER;
                this.mVerticalAlignment = LegendVerticalAlignment.CENTER;
                this.mOrientation = LegendOrientation.VERTICAL;
            }
        }
        this.mDrawInside = newValue == LegendPosition.LEFT_OF_CHART_INSIDE || newValue == LegendPosition.RIGHT_OF_CHART_INSIDE;
    }

    public LegendHorizontalAlignment getHorizontalAlignment() {
        return this.mHorizontalAlignment;
    }

    public void setHorizontalAlignment(LegendHorizontalAlignment value) {
        this.mHorizontalAlignment = value;
    }

    public LegendVerticalAlignment getVerticalAlignment() {
        return this.mVerticalAlignment;
    }

    public void setVerticalAlignment(LegendVerticalAlignment value) {
        this.mVerticalAlignment = value;
    }

    public LegendOrientation getOrientation() {
        return this.mOrientation;
    }

    public void setOrientation(LegendOrientation value) {
        this.mOrientation = value;
    }

    public boolean isDrawInsideEnabled() {
        return this.mDrawInside;
    }

    public void setDrawInside(boolean value) {
        this.mDrawInside = value;
    }

    public LegendDirection getDirection() {
        return this.mDirection;
    }

    public void setDirection(LegendDirection pos) {
        this.mDirection = pos;
    }

    public LegendForm getForm() {
        return this.mShape;
    }

    public void setForm(LegendForm shape) {
        this.mShape = shape;
    }

    public void setFormSize(float size) {
        this.mFormSize = Utils.convertDpToPixel(size);
    }

    public float getFormSize() {
        return this.mFormSize;
    }

    public float getXEntrySpace() {
        return this.mXEntrySpace;
    }

    public void setXEntrySpace(float space) {
        this.mXEntrySpace = Utils.convertDpToPixel(space);
    }

    public float getYEntrySpace() {
        return this.mYEntrySpace;
    }

    public void setYEntrySpace(float space) {
        this.mYEntrySpace = Utils.convertDpToPixel(space);
    }

    public float getFormToTextSpace() {
        return this.mFormToTextSpace;
    }

    public void setFormToTextSpace(float space) {
        this.mFormToTextSpace = Utils.convertDpToPixel(space);
    }

    public float getStackSpace() {
        return this.mStackSpace;
    }

    public void setStackSpace(float space) {
        this.mStackSpace = space;
    }

    public float getFullWidth(Paint labelpaint) {
        float width = 0.0f;
        for (int i = 0; i < this.mLabels.length; ++i) {
            if (this.mLabels[i] != null) {
                if (this.mColors[i] != 1122868) {
                    width += this.mFormSize + this.mFormToTextSpace;
                }
                width += (float)Utils.calcTextWidth(labelpaint, this.mLabels[i]);
                if (i >= this.mLabels.length - 1) continue;
                width += this.mXEntrySpace;
                continue;
            }
            width += this.mFormSize;
            if (i >= this.mLabels.length - 1) continue;
            width += this.mStackSpace;
        }
        return width;
    }

    public float getFullHeight(Paint labelpaint) {
        float height = 0.0f;
        for (int i = 0; i < this.mLabels.length; ++i) {
            if (this.mLabels[i] == null) continue;
            height += (float)Utils.calcTextHeight(labelpaint, this.mLabels[i]);
            if (i >= this.mLabels.length - 1) continue;
            height += this.mYEntrySpace;
        }
        return height;
    }

    public void setWordWrapEnabled(boolean enabled) {
        this.mWordWrapEnabled = enabled;
    }

    public boolean isWordWrapEnabled() {
        return this.mWordWrapEnabled;
    }

    public float getMaxSizePercent() {
        return this.mMaxSizePercent;
    }

    public void setMaxSizePercent(float maxSize) {
        this.mMaxSizePercent = maxSize;
    }

    public FSize[] getCalculatedLabelSizes() {
        return this.mCalculatedLabelSizes;
    }

    public Boolean[] getCalculatedLabelBreakPoints() {
        return this.mCalculatedLabelBreakPoints;
    }

    public FSize[] getCalculatedLineSizes() {
        if (this.mCalculatedLineSizes == null || this.isCalculatedLineSizesArrayListResized) {
            this.mCalculatedLineSizes = this.calculatedLineSizesForCalculateDimensions.toArray(new FSize[this.calculatedLineSizesForCalculateDimensions.size()]);
            this.isCalculatedLineSizesArrayListResized = false;
        }
        return this.mCalculatedLineSizes;
    }

    public void calculateDimensions(Paint labelpaint, ViewPortHandler viewPortHandler) {
        this.mTextWidthMax = this.getMaximumEntryWidth(labelpaint);
        this.mTextHeightMax = this.getMaximumEntryHeight(labelpaint);
        switch (this.mOrientation) {
            case VERTICAL: {
                float maxWidth = 0.0f;
                float maxHeight = 0.0f;
                float width = 0.0f;
                float labelLineHeight = Utils.getLineHeight(labelpaint, this.fontMetricsForCalculateDimensions);
                int count = this.mLabels.length;
                boolean wasStacked = false;
                for (int i = 0; i < count; ++i) {
                    boolean drawingForm;
                    boolean bl = drawingForm = this.mColors[i] != 1122868;
                    if (!wasStacked) {
                        width = 0.0f;
                    }
                    if (drawingForm) {
                        if (wasStacked) {
                            width += this.mStackSpace;
                        }
                        width += this.mFormSize;
                    }
                    if (this.mLabels[i] != null) {
                        if (drawingForm && !wasStacked) {
                            width += this.mFormToTextSpace;
                        } else if (wasStacked) {
                            maxWidth = Math.max(maxWidth, width);
                            maxHeight += labelLineHeight + this.mYEntrySpace;
                            width = 0.0f;
                            wasStacked = false;
                        }
                        width += (float)Utils.calcTextWidth(labelpaint, this.mLabels[i]);
                        if (i < count - 1) {
                            maxHeight += labelLineHeight + this.mYEntrySpace;
                        }
                    } else {
                        wasStacked = true;
                        width += this.mFormSize;
                        if (i < count - 1) {
                            width += this.mStackSpace;
                        }
                    }
                    maxWidth = Math.max(maxWidth, width);
                }
                this.mNeededWidth = maxWidth;
                this.mNeededHeight = maxHeight;
                break;
            }
            case HORIZONTAL: {
                int i;
                int labelCount = this.mLabels.length;
                float labelLineHeight = Utils.getLineHeight(labelpaint, this.fontMetricsForCalculateDimensions);
                float labelLineSpacing = Utils.getLineSpacing(labelpaint, this.fontMetricsForCalculateDimensions) + this.mYEntrySpace;
                float contentWidth = viewPortHandler.contentWidth() * this.mMaxSizePercent;
                if (this.mCalculatedLabelSizes.length != labelCount) {
                    FSize[] temp = new FSize[labelCount];
                    int count = this.mCalculatedLabelSizes.length;
                    for (int i2 = 0; i2 < count && i2 < labelCount; ++i2) {
                        temp[i2] = this.mCalculatedLabelSizes[i2];
                    }
                    while (count > labelCount) {
                        FSize.recycleInstance(this.mCalculatedLabelSizes[--count]);
                    }
                    this.mCalculatedLabelSizes = temp;
                }
                int calculatedLabelSizesIndex = 0;
                if (this.mCalculatedLabelBreakPoints.length != labelCount) {
                    this.mCalculatedLabelBreakPoints = new Boolean[labelCount];
                }
                int calculatedLabelBreakIndex = 0;
                ArrayList<FSize> calculatedLineSizes = this.calculatedLineSizesForCalculateDimensions;
                FSize.recycleInstances(calculatedLineSizes);
                calculatedLineSizes.clear();
                float maxLineWidth = 0.0f;
                float currentLineWidth = 0.0f;
                float requiredWidth = 0.0f;
                int stackedStartIndex = -1;
                for (i = 0; i < labelCount; ++i) {
                    boolean drawingForm = this.mColors[i] != 1122868;
                    this.mCalculatedLabelBreakPoints[calculatedLabelBreakIndex] = false;
                    ++calculatedLabelBreakIndex;
                    requiredWidth = stackedStartIndex == -1 ? 0.0f : (requiredWidth += this.mStackSpace);
                    if (this.mLabels[i] != null) {
                        if (this.mCalculatedLabelSizes[calculatedLabelSizesIndex] == null) {
                            this.mCalculatedLabelSizes[calculatedLabelSizesIndex] = Utils.calcTextSize(labelpaint, this.mLabels[i]);
                        } else {
                            Utils.calcTextSize(labelpaint, this.mLabels[i], this.mCalculatedLabelSizes[calculatedLabelSizesIndex]);
                        }
                        FSize labelSize = this.mCalculatedLabelSizes[calculatedLabelSizesIndex];
                        ++calculatedLabelSizesIndex;
                        requiredWidth += drawingForm ? this.mFormToTextSpace + this.mFormSize : 0.0f;
                        requiredWidth += labelSize.width;
                    } else {
                        if (this.mCalculatedLabelSizes[calculatedLabelSizesIndex] == null) {
                            this.mCalculatedLabelSizes[calculatedLabelSizesIndex] = FSize.getInstance(0.0f, 0.0f);
                        } else {
                            this.mCalculatedLabelSizes[calculatedLabelSizesIndex].width = 0.0f;
                            this.mCalculatedLabelSizes[calculatedLabelSizesIndex].height = 0.0f;
                        }
                        ++calculatedLabelSizesIndex;
                        requiredWidth += drawingForm ? this.mFormSize : 0.0f;
                        if (stackedStartIndex == -1) {
                            stackedStartIndex = i;
                        }
                    }
                    if (this.mLabels[i] != null || i == labelCount - 1) {
                        float requiredSpacing;
                        float f = requiredSpacing = currentLineWidth == 0.0f ? 0.0f : this.mXEntrySpace;
                        if (!this.mWordWrapEnabled || currentLineWidth == 0.0f || contentWidth - currentLineWidth >= requiredSpacing + requiredWidth) {
                            currentLineWidth += requiredSpacing + requiredWidth;
                        } else {
                            calculatedLineSizes.add(FSize.getInstance(currentLineWidth, labelLineHeight));
                            maxLineWidth = Math.max(maxLineWidth, currentLineWidth);
                            this.mCalculatedLabelBreakPoints[stackedStartIndex > -1 ? stackedStartIndex : i] = true;
                            currentLineWidth = requiredWidth;
                        }
                        if (i == labelCount - 1) {
                            calculatedLineSizes.add(FSize.getInstance(currentLineWidth, labelLineHeight));
                            maxLineWidth = Math.max(maxLineWidth, currentLineWidth);
                        }
                    }
                    stackedStartIndex = this.mLabels[i] != null ? -1 : stackedStartIndex;
                }
                if (calculatedLineSizes.size() != this.mCalculatedLineSizes.length) {
                    this.isCalculatedLineSizesArrayListResized = true;
                } else {
                    for (i = 0; i < this.mCalculatedLineSizes.length; ++i) {
                        this.mCalculatedLineSizes[i] = calculatedLineSizes.get(i);
                    }
                }
                this.mNeededWidth = maxLineWidth;
                this.mNeededHeight = labelLineHeight * (float)this.mCalculatedLineSizes.length + labelLineSpacing * (float)(this.mCalculatedLineSizes.length == 0 ? 0 : this.mCalculatedLineSizes.length - 1);
                break;
            }
        }
    }

    public static enum LegendDirection {
        LEFT_TO_RIGHT,
        RIGHT_TO_LEFT;

    }

    public static enum LegendOrientation {
        HORIZONTAL,
        VERTICAL;

    }

    public static enum LegendVerticalAlignment {
        TOP,
        CENTER,
        BOTTOM;

    }

    public static enum LegendHorizontalAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static enum LegendForm {
        SQUARE,
        CIRCLE,
        LINE;

    }

    public static enum LegendPosition {
        RIGHT_OF_CHART,
        RIGHT_OF_CHART_CENTER,
        RIGHT_OF_CHART_INSIDE,
        LEFT_OF_CHART,
        LEFT_OF_CHART_CENTER,
        LEFT_OF_CHART_INSIDE,
        BELOW_CHART_LEFT,
        BELOW_CHART_RIGHT,
        BELOW_CHART_CENTER,
        ABOVE_CHART_LEFT,
        ABOVE_CHART_RIGHT,
        ABOVE_CHART_CENTER,
        PIECHART_CENTER;

    }
}

