/*
 * Decompiled with CFR 0.152.
 */
package net.christophschubert.cp.testcontainers.util;

import java.util.HashMap;
import net.christophschubert.cp.testcontainers.util.ConnectorConfig;

public class DataGenConfig
extends ConnectorConfig {
    public DataGenConfig(String name) {
        super(name, new HashMap<String, Object>());
        this.with("connector.class", "io.confluent.kafka.connect.datagen.DatagenConnector");
    }

    public DataGenConfig withKafkaTopic(String topicName) {
        this.with("kafka.topic", topicName);
        return this;
    }

    public DataGenConfig withMaxInterval(int maxInterval) {
        this.with("max.interval", maxInterval);
        return this;
    }

    public DataGenConfig withSchemaString(String avroSchema) {
        this.with("schema.string", avroSchema);
        return this;
    }

    public DataGenConfig withSchemaFilename(String schemaFilename) {
        this.with("schema.filename", schemaFilename);
        return this;
    }

    public DataGenConfig withSchemaKeyfield(String keyfield) {
        this.with("schema.keyfield", keyfield);
        return this;
    }

    public DataGenConfig withQuickstart(String quickstart) {
        this.with("quickstart", quickstart);
        return this;
    }

    public DataGenConfig withIterations(int numMessages) {
        this.with("iterations", numMessages);
        return this;
    }
}

