/*
 * Decompiled with CFR 0.152.
 */
package net.christophschubert.cp.testcontainers.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ConnectorConfig {
    public static final String CONNECTOR_CLASS_CONFIG = "connector.class";
    public static final String TASKS_MAX_CONFIG = "tasks.max";
    public static final String TOPICS_CONFIG = "topics";
    public static final String TOPIC_REGEX_CONFIG = "topic.regex";
    public static final String KEY_CONVERTER_CONFIG = "key.converter";
    public static final String VALUE_CONVERTER_CONFIG = "value.converter";
    public static final String HEADER_CONVERTER_CONFIG = "header.converter";
    @JsonProperty(value="name")
    public final String name;
    @JsonProperty(value="config")
    public final Map<String, Object> config;

    public static ConnectorConfig sink(String name, String connectorClassName) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put(CONNECTOR_CLASS_CONFIG, connectorClassName);
        return new ConnectorConfig(name, config);
    }

    public static ConnectorConfig source(String name, String connectorClassName) {
        return ConnectorConfig.sink(name, connectorClassName);
    }

    public ConnectorConfig withTopics(Collection<String> topicNames) {
        this.config.put(TOPICS_CONFIG, String.join((CharSequence)",", topicNames));
        return this;
    }

    public ConnectorConfig withTopicRegex(String topicRegex) {
        this.config.put(TOPIC_REGEX_CONFIG, topicRegex);
        return this;
    }

    public ConnectorConfig withKeyConverter(String keyConverter) {
        this.config.put(KEY_CONVERTER_CONFIG, keyConverter);
        return this;
    }

    public ConnectorConfig withValueConverter(String valueConverter) {
        this.config.put(VALUE_CONVERTER_CONFIG, valueConverter);
        return this;
    }

    public ConnectorConfig withHeaderConverter(String headerConverter) {
        this.config.put(HEADER_CONVERTER_CONFIG, headerConverter);
        return this;
    }

    public ConnectorConfig with(String key, Object value) {
        this.config.put(key, value);
        return this;
    }

    @JsonCreator
    public ConnectorConfig(@JsonProperty(value="name") String name, @JsonProperty(value="config") Map<String, Object> config) {
        this.name = name;
        this.config = config;
    }

    public String toString() {
        return "ConnectorConfig{name='" + this.name + "', config=" + this.config + "}";
    }
}

