/*
 * Decompiled with CFR 0.152.
 */
package net.christophschubert.cp.testcontainers.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Set;
import net.christophschubert.cp.testcontainers.util.ConnectorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectClient {
    private static final Logger logger = LoggerFactory.getLogger(ConnectClient.class);
    private final String baseUrl;
    private final HttpClient httpClient;
    private final ObjectMapper mapper = new ObjectMapper();

    public ConnectClient(String baseURL, final String userName, final String password) {
        this.baseUrl = baseURL;
        this.httpClient = HttpClient.newBuilder().authenticator(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(userName, password.toCharArray());
            }
        }).build();
    }

    public ConnectClient(String baseURL) {
        this.baseUrl = baseURL;
        this.httpClient = HttpClient.newBuilder().build();
    }

    public Set<String> getConnectors() throws IOException, InterruptedException {
        HttpRequest request = HttpRequest.newBuilder(URI.create(this.baseUrl + "/connectors")).build();
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        return (Set)this.mapper.readValue(response.body(), (TypeReference)new TypeReference<Set<String>>(){});
    }

    public void startConnector(ConnectorConfig config) throws IOException, InterruptedException {
        HttpRequest request = HttpRequest.newBuilder(URI.create(this.baseUrl + "/connectors")).POST(HttpRequest.BodyPublishers.ofString(this.mapper.writeValueAsString((Object)config))).header("Content-Type", "application/json").build();
        logger.debug("submitting config: {}", (Object)this.mapper.writeValueAsString((Object)config));
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() == 201) {
            logger.info("successfully started connector {}", (Object)config.name);
        } else {
            logger.error("Failed to start connector '{}'", (Object)config.name);
        }
    }
}

