/*
 * Decompiled with CFR 0.152.
 */
package net.christophschubert.cp.testcontainers;

import java.util.List;
import net.christophschubert.cp.testcontainers.ConfluentServerContainer;
import net.christophschubert.cp.testcontainers.KafkaConnectContainer;
import net.christophschubert.cp.testcontainers.SecurityConfigs;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.utility.DockerImageName;

public class ConfluentServerConnectContainer
extends KafkaConnectContainer {
    public ConfluentServerConnectContainer(DockerImageName dockerImageName, ConfluentServerContainer bootstrap, Network network) {
        super(dockerImageName, (KafkaContainer)bootstrap, network);
    }

    ConfluentServerConnectContainer(ImageFromDockerfile image, ConfluentServerContainer bootstrap, Network network) {
        super(image, (KafkaContainer)bootstrap, network);
    }

    public ConfluentServerConnectContainer enableRbac(String mdsServer, String principal, String secret) {
        this.prepareCertificates();
        this.withEnv("CUB_CLASSPATH", "/usr/share/java/confluent-security/connect/*:/usr/share/java/kafka/*:/usr/share/java/cp-base-new/*");
        this.withProperties(SecurityConfigs.oAuthWithTokenCallbackHandlerProperties(principal, secret, mdsServer));
        for (String prefix : List.of("producer", "consumer", "admin")) {
            this.withProperty(prefix + ".security.protocol", "SASL_PLAINTEXT");
            this.withProperty(prefix + ".sasl.mechanism", "OAUTHBEARER");
            this.withProperty(prefix + ".sasl.login.callback.handler.class", "io.confluent.kafka.clients.plugins.auth.token.TokenUserLoginCallbackHandler");
        }
        this.withProperty("rest.extension.classes", "io.confluent.connect.security.ConnectSecurityExtension");
        this.withProperty("rest.servlet.initializor.classes", "io.confluent.common.security.jetty.initializer.InstallBearerOrBasicSecurityHandler");
        this.withProperty("public.key.path", this.getPublicKeyPath());
        this.withProperties(SecurityConfigs.confluentMdsSettings(principal, secret, mdsServer));
        return this;
    }

    public KafkaConnectContainer enableSecretRegistry() {
        return this;
    }
}

