/*
 * Decompiled with CFR 0.152.
 */
package net.christophschubert.cp.testcontainers;

import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.utility.DockerImageName;

public abstract class CPTestContainer<SELF extends GenericContainer<SELF>>
extends GenericContainer<SELF> {
    protected final int httpPort;
    protected final String propertyPrefix;
    final KafkaContainer bootstrap;
    private final String containerCertPath = "/tmp/conf";
    private final String localCertPath = "src/main/resources/certs";

    public static String getInternalBootstrap(KafkaContainer bootstrap) {
        return (String)bootstrap.getNetworkAliases().get(0) + ":9092";
    }

    CPTestContainer(DockerImageName dockerImageName, KafkaContainer bootstrap, Network network, int httpPort, String propertyPrefix) {
        super(dockerImageName);
        this.bootstrap = bootstrap;
        this.dependsOn(new Startable[]{bootstrap});
        this.withNetwork(network);
        this.withExposedPorts(new Integer[]{httpPort});
        this.httpPort = httpPort;
        this.propertyPrefix = propertyPrefix;
    }

    CPTestContainer(ImageFromDockerfile dockerImage, KafkaContainer bootstrap, Network network, int httpPort, String propertyPrefix) {
        super((Future)dockerImage);
        this.bootstrap = bootstrap;
        this.dependsOn(new Startable[]{bootstrap});
        this.withNetwork(network);
        this.withExposedPorts(new Integer[]{httpPort});
        this.httpPort = httpPort;
        this.propertyPrefix = propertyPrefix;
    }

    CPTestContainer<SELF> withProperty(String property, Object value) {
        Objects.requireNonNull(value);
        String envVar = this.propertyPrefix + "_" + property.replace('.', '_').toUpperCase();
        this.withEnv(envVar, value.toString());
        return this;
    }

    CPTestContainer<SELF> withProperties(Map<String, Object> properties) {
        properties.forEach(this::withProperty);
        return this;
    }

    CPTestContainer<SELF> withProperties(String prefix, Map<String, Object> properties) {
        properties.forEach((k, v) -> this.withProperty(prefix + "." + k, v));
        return this;
    }

    public abstract CPTestContainer<SELF> withLogLevel(String var1);

    public String getBaseUrl() {
        return String.format("http://%s:%d", this.getHost(), this.getMappedPort(this.httpPort));
    }

    public int getMappedHttpPort() {
        return this.getMappedPort(this.httpPort);
    }

    public String getHttpPortListener() {
        return "http://0.0.0.0:" + this.httpPort;
    }

    public String getInternalBaseUrl() {
        return String.format("http://%s:%d", this.getNetworkAliases().get(0), this.httpPort);
    }

    protected void prepareCertificates() {
        this.withFileSystemBind("src/main/resources/certs", "/tmp/conf");
    }

    protected String getPublicKeyPath() {
        return "/tmp/conf/public.pem";
    }

    public void prettyPrintEnvs() {
        this.getEnvMap().entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(e -> System.out.printf("%s: '%s'%n", e.getKey(), e.getValue()));
    }
}

