/*
 * Decompiled with CFR 0.152.
 */
package com.github.timm.cucumber.options;

import com.github.timm.cucumber.options.Shellwords;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeOptions {
    private final List<String> glue = new ArrayList<String>();
    private final List<String> filters = new ArrayList<String>();
    private final List<String> pluginNames = new ArrayList<String>();
    private Boolean dryRun = null;
    private Boolean strict = null;
    private Boolean monochrome = null;

    public RuntimeOptions(String argv) {
        this(Shellwords.parse(argv));
    }

    public RuntimeOptions(List<String> argv) {
        argv = new ArrayList<String>(argv);
        this.parse(argv);
    }

    private void parse(List<String> args) {
        ArrayList<String> parsedFilters = new ArrayList<String>();
        ArrayList<String> parsedGlue = new ArrayList<String>();
        while (!args.isEmpty()) {
            String arg = args.remove(0).trim();
            if (arg.equals("--glue") || arg.equals("-g")) {
                String gluePath = args.remove(0);
                parsedGlue.add(gluePath);
                continue;
            }
            if (arg.equals("--tags") || arg.equals("-t")) {
                parsedFilters.add(args.remove(0));
                continue;
            }
            if (arg.equals("--plugin") || arg.equals("-p")) {
                this.addPluginName(args.remove(0));
                continue;
            }
            if (arg.equals("--format") || arg.equals("-f")) {
                System.err.println("WARNING: Cucumber-JVM's --format option is deprecated. Please use --plugin instead.");
                this.addPluginName(args.remove(0));
                continue;
            }
            if (arg.equals("--no-dry-run") || arg.equals("--dry-run") || arg.equals("-d")) {
                this.dryRun = !arg.startsWith("--no-");
                continue;
            }
            if (arg.equals("--no-strict") || arg.equals("--strict") || arg.equals("-s")) {
                this.strict = !arg.startsWith("--no-");
                continue;
            }
            if (!arg.equals("--no-monochrome") && !arg.equals("--monochrome") && !arg.equals("-m")) continue;
            this.monochrome = !arg.startsWith("--no-");
        }
        if (!parsedFilters.isEmpty()) {
            this.filters.clear();
            this.filters.addAll(parsedFilters);
        }
        if (!parsedGlue.isEmpty()) {
            this.glue.clear();
            this.glue.addAll(parsedGlue);
        }
    }

    private void addPluginName(String pluginString) {
        this.pluginNames.add(pluginString);
    }

    public List<String> getGlue() {
        return this.glue;
    }

    public Boolean isStrict() {
        return this.strict;
    }

    public Boolean isDryRun() {
        return this.dryRun;
    }

    public List<String> getFilters() {
        return this.filters;
    }

    public Boolean isMonochrome() {
        return this.monochrome;
    }

    public List<String> getPluginNames() {
        return this.pluginNames;
    }
}

