/*
 * Decompiled with CFR 0.152.
 */
package com.github.timm.cucumber.generate.filter;

import gherkin.ast.Examples;
import gherkin.ast.Feature;
import gherkin.ast.Node;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import gherkin.ast.TableRow;
import gherkin.ast.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagFilter {
    private final List<List<String>> tagGroupsAnded;

    public TagFilter(List<String> tags) {
        ArrayList<String> nullsafeTags = tags == null ? new ArrayList<String>() : tags;
        this.tagGroupsAnded = TagFilter.splitTagQuery(nullsafeTags);
    }

    private static List<List<String>> splitTagQuery(List<String> tagQuery) {
        ArrayList<List<String>> allTags = new ArrayList<List<String>>();
        for (String tags : tagQuery) {
            ArrayList<String> queryPart = new ArrayList<String>();
            for (String part : tags.split(",")) {
                queryPart.add(part.trim());
            }
            allTags.add(queryPart);
        }
        return allTags;
    }

    private boolean matches(Collection<Tag> tags) {
        for (List<String> tagGroup : this.tagGroupsAnded) {
            if (this.anyMatch(tags, tagGroup)) continue;
            return false;
        }
        return true;
    }

    private boolean anyMatch(Collection<Tag> tags, List<String> expectedTags) {
        for (String tag : expectedTags) {
            if (tag.startsWith("~")) {
                for (Tag actualTag : tags) {
                    if (!actualTag.getName().equals(tag.substring(1))) continue;
                    return false;
                }
                return true;
            }
            for (Tag actualTag : tags) {
                if (!actualTag.getName().equals(tag)) continue;
                return true;
            }
        }
        return false;
    }

    public Collection<Node> matchingScenariosAndExamples(Feature feature) {
        List allScenarios = feature.getScenarioDefinitions();
        LinkedList<Node> matchingScenariosAndExamples = new LinkedList<Node>();
        for (ScenarioDefinition scenario : allScenarios) {
            HashSet<Tag> allTagsForScenario = new HashSet<Tag>(scenario.getTags());
            allTagsForScenario.addAll(feature.getTags());
            if (scenario instanceof ScenarioOutline) {
                matchingScenariosAndExamples.addAll(this.matchingExamples((ScenarioOutline)scenario, allTagsForScenario));
                continue;
            }
            if (!this.matches(allTagsForScenario)) continue;
            matchingScenariosAndExamples.add((Node)scenario);
        }
        return matchingScenariosAndExamples;
    }

    private Collection<TableRow> matchingExamples(ScenarioOutline scenario, Set<Tag> allTagsForScenario) {
        LinkedList<TableRow> matchingRows = new LinkedList<TableRow>();
        for (Examples example : scenario.getExamples()) {
            HashSet<Tag> allTagsForExample = new HashSet<Tag>(allTagsForScenario);
            allTagsForExample.addAll(example.getTags());
            if (!this.matches(allTagsForExample)) continue;
            matchingRows.addAll(example.getTableBody());
        }
        return matchingRows;
    }
}

