/*
 * Decompiled with CFR 0.152.
 */
package com.github.tehras.loadingskeleton.utils;

import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.View;
import com.github.tehras.loadingskeleton.helpers.Options;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0005\u00a8\u0006\u000e"}, d2={"assignBackground", "", "options", "Lcom/github/tehras/loadingskeleton/helpers/Options;", "v", "Landroid/view/View;", "darker", "", "color", "factor", "", "gradientDrawable", "Landroid/graphics/drawable/GradientDrawable;", "view", "loading-skeleton_release"})
public final class ViewHelperKt {
    public static final int darker(int color, float factor) {
        int a = Color.alpha((int)color);
        int r = Color.red((int)color);
        int g = Color.green((int)color);
        int b = Color.blue((int)color);
        return Color.argb((int)a, (int)Math.max((int)((float)r * factor), 0), (int)Math.max((int)((float)g * factor), 0), (int)Math.max((int)((float)b * factor), 0));
    }

    @NotNull
    public static final GradientDrawable gradientDrawable(@NotNull Options options, @NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        int lighterColor = view.getContext().getResources().getColor(options.getColor());
        int darkerColor = ViewHelperKt.darker(lighterColor, 0.8f);
        GradientDrawable gd = new GradientDrawable(GradientDrawable.Orientation.TL_BR, new int[]{lighterColor, darkerColor});
        return gd;
    }

    public static final void assignBackground(@NotNull Options options, @NotNull View v) {
        GradientDrawable background;
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        if (options.getGradient()) {
            background = ViewHelperKt.gradientDrawable(options, v);
        } else {
            background = new GradientDrawable();
            background.setColor(v.getResources().getColor(options.getColor()));
        }
        background.setCornerRadius((float)v.getMeasuredHeight() / (float)5);
        if (!options.getShimmer()) {
            background.setAlpha((int)(0.5f * (float)255));
        }
        v.setBackground((Drawable)background);
    }
}

