/*
 * Decompiled with CFR 0.152.
 */
package com.github.tehras.loadingskeleton;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.facebook.shimmer.ShimmerFrameLayout;
import com.github.tehras.loadingskeleton.LoadingSkeleton;
import com.github.tehras.loadingskeleton.helpers.LoadingSkeletonViewConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0016\u001a\u00020\u0017H\u0002J$\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00170\u001cH\u0002J\u0012\u0010\u001e\u001a\u00020\u00172\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0014J\u001a\u0010!\u001a\u00020\u00172\b\u0010\"\u001a\u0004\u0018\u00010\u001d2\u0006\u0010#\u001a\u00020\u0010H\u0002J\u001a\u0010$\u001a\u00020\u00172\b\u0010\"\u001a\u0004\u0018\u00010\u001d2\u0006\u0010#\u001a\u00020\u0010H\u0002J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010%\u001a\u00020\u0017J\b\u0010\u0015\u001a\u00020\u0017H\u0002J\u0006\u0010&\u001a\u00020\u0017R\u000e\u0010\u000b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/github/tehras/loadingskeleton/LoadingSkeleton;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "(Landroid/content/Context;)V", "defStyleAttrs", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "containerViewId", "layoutFinished", "", "originalContainerId", "skeletonViewConverter", "Lcom/github/tehras/loadingskeleton/helpers/LoadingSkeletonViewConverter;", "getSkeletonViewConverter", "()Lcom/github/tehras/loadingskeleton/helpers/LoadingSkeletonViewConverter;", "setSkeletonViewConverter", "(Lcom/github/tehras/loadingskeleton/helpers/LoadingSkeletonViewConverter;)V", "startWhenLayoutFinished", "checkChildCount", "", "checkViewGroup", "layout", "Landroid/view/View;", "func", "Lkotlin/Function1;", "Landroid/view/ViewGroup;", "onDraw", "canvas", "Landroid/graphics/Canvas;", "populateView", "v", "viewConverter", "revertView", "start", "stop", "loading-skeleton_release"})
public final class LoadingSkeleton
extends FrameLayout {
    private boolean layoutFinished;
    private boolean startWhenLayoutFinished;
    private final int containerViewId = 10001;
    private int originalContainerId;
    @NotNull
    private LoadingSkeletonViewConverter skeletonViewConverter;

    @NotNull
    public final LoadingSkeletonViewConverter getSkeletonViewConverter() {
        return this.skeletonViewConverter;
    }

    public final void setSkeletonViewConverter(@NotNull LoadingSkeletonViewConverter loadingSkeletonViewConverter) {
        Intrinsics.checkParameterIsNotNull((Object)loadingSkeletonViewConverter, (String)"<set-?>");
        this.skeletonViewConverter = loadingSkeletonViewConverter;
    }

    @NotNull
    public final LoadingSkeleton skeletonViewConverter(@NotNull LoadingSkeletonViewConverter skeletonViewConverter) {
        Intrinsics.checkParameterIsNotNull((Object)skeletonViewConverter, (String)"skeletonViewConverter");
        this.skeletonViewConverter = skeletonViewConverter;
        return this;
    }

    private final void checkChildCount() {
        if (this.getChildCount() != 1) {
            throw (Throwable)new RuntimeException("View must have 1 child");
        }
    }

    private final void checkViewGroup(View layout, Function1<? super ViewGroup, Unit> func) {
        if (!(layout instanceof ViewGroup)) {
            throw (Throwable)new RuntimeException("Layout must be a ViewGroup");
        }
        func.invoke((Object)layout);
    }

    public final void stop() {
        this.checkChildCount();
        View view = this.getChildAt(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"getChildAt(0)");
        this.checkViewGroup(view, (Function1<? super ViewGroup, Unit>)((Function1)stop.1.INSTANCE));
        View view2 = this.getChildAt(0);
        if (view2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
        }
        ViewGroup container = (ViewGroup)view2;
        if (container.getId() != this.containerViewId) {
            return;
        }
        if (this.originalContainerId != -1) {
            container.setId(this.originalContainerId);
        }
        View child = container.getChildAt(0);
        this.revertView(container, this.skeletonViewConverter);
        container.removeView(child);
        this.removeView((View)container);
        this.addView(child);
    }

    protected void onDraw(@Nullable Canvas canvas) {
        super.onDraw(canvas);
        this.layoutFinished = true;
        if (this.startWhenLayoutFinished) {
            this.startWhenLayoutFinished();
        }
    }

    public final void start() {
        if (this.layoutFinished) {
            this.startWhenLayoutFinished();
        } else {
            this.startWhenLayoutFinished = true;
        }
    }

    private final void startWhenLayoutFinished() {
        this.checkChildCount();
        View layout = this.getChildAt(0);
        if (layout.getId() == this.containerViewId) {
            return;
        }
        this.originalContainerId = layout.getId();
        this.removeView(layout);
        View view = layout;
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"layout");
        this.checkViewGroup(view, (Function1<? super ViewGroup, Unit>)((Function1)new Function1<ViewGroup, Unit>(this){
            final /* synthetic */ LoadingSkeleton this$0;

            public final void invoke(@NotNull ViewGroup it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                LoadingSkeleton.access$populateView(this.this$0, it, this.this$0.getSkeletonViewConverter());
            }
            {
                this.this$0 = loadingSkeleton;
                super(1);
            }
        }));
        ViewGroup container = this.skeletonViewConverter.shimmerEnabled() ? (ViewGroup)new ShimmerFrameLayout(this.getContext()) : (ViewGroup)new FrameLayout(this.getContext());
        container.setId(this.containerViewId);
        container.addView(layout);
        if (container instanceof ShimmerFrameLayout) {
            ((ShimmerFrameLayout)container).startShimmerAnimation();
        }
        this.addView((View)container);
    }

    /*
     * WARNING - void declaration
     */
    private final void populateView(ViewGroup v, LoadingSkeletonViewConverter viewConverter) {
        block3: {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            ViewGroup viewGroup;
            ViewGroup viewGroup2 = v;
            if (viewGroup2 == null) break block3;
            ViewGroup it = viewGroup = viewGroup2;
            Iterable iterable = (Iterable)new IntRange(0, v.getChildCount());
            Iterator iterator = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            Iterator iterator2 = $receiver$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it2;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                View view = v.getChildAt((int)it2);
                collection.add(view);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                View it3 = (View)element$iv;
                if (it3 instanceof ViewGroup) {
                    this.populateView((ViewGroup)it3, viewConverter);
                    continue;
                }
                if (!(it3 instanceof View)) continue;
                viewConverter.convertView(it3);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void revertView(ViewGroup v, LoadingSkeletonViewConverter viewConverter) {
        block3: {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            ViewGroup viewGroup;
            ViewGroup viewGroup2 = v;
            if (viewGroup2 == null) break block3;
            ViewGroup it = viewGroup = viewGroup2;
            Iterable iterable = (Iterable)new IntRange(0, v.getChildCount());
            Iterator iterator = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            Iterator iterator2 = $receiver$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it2;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                View view = v.getChildAt((int)it2);
                collection.add(view);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                View it3 = (View)element$iv;
                if (it3 instanceof ViewGroup) {
                    this.revertView((ViewGroup)it3, viewConverter);
                    continue;
                }
                if (!(it3 instanceof View)) continue;
                viewConverter.revertView(it3);
            }
        }
    }

    public LoadingSkeleton(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttrs);
        this.containerViewId = 10001;
        this.originalContainerId = -1;
        this.skeletonViewConverter = new LoadingSkeletonViewConverter.Builder().build();
    }

    public LoadingSkeleton(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, attrs, 0);
    }

    public LoadingSkeleton(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, null);
    }

    public static final /* synthetic */ void access$populateView(LoadingSkeleton $this, @Nullable ViewGroup v, @NotNull LoadingSkeletonViewConverter viewConverter) {
        $this.populateView(v, viewConverter);
    }
}

