/*
 * Decompiled with CFR 0.152.
 */
package com.github.tehras.loadingskeleton.helpers;

import android.content.Context;
import android.view.View;
import com.github.tehras.loadingskeleton.R;
import com.github.tehras.loadingskeleton.helpers.LoadingSkeletonViewStreamer;
import com.github.tehras.loadingskeleton.helpers.Options;
import com.github.tehras.loadingskeleton.view_streamers.DefaultImageViewStreamer;
import com.github.tehras.loadingskeleton.view_streamers.DefaultTextViewStreamer;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0016B\u000f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\u0013\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b`\tH\u0002J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0015\u001a\u00020\u000bR&\u0010\u0006\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0007j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b`\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/github/tehras/loadingskeleton/helpers/LoadingSkeletonViewConverter;", "", "builder", "Lcom/github/tehras/loadingskeleton/helpers/LoadingSkeletonViewConverter$Builder;", "(Lcom/github/tehras/loadingskeleton/helpers/LoadingSkeletonViewConverter$Builder;)V", "()V", "converters", "Ljava/util/ArrayList;", "Lcom/github/tehras/loadingskeleton/helpers/LoadingSkeletonViewStreamer;", "Lkotlin/collections/ArrayList;", "isFirstConvert", "", "isFirstRevert", "options", "Lcom/github/tehras/loadingskeleton/helpers/Options;", "convertView", "", "view", "Landroid/view/View;", "defaultStreamers", "revertView", "shimmerEnabled", "Builder", "loading-skeleton_release"})
public final class LoadingSkeletonViewConverter {
    private Options options;
    private ArrayList<LoadingSkeletonViewStreamer<?>> converters;
    private boolean isFirstConvert = true;
    private boolean isFirstRevert = true;

    public final boolean shimmerEnabled() {
        Options options = this.options;
        if (options == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
        }
        return options.getShimmer();
    }

    private final ArrayList<LoadingSkeletonViewStreamer<?>> defaultStreamers() {
        ArrayList converters = new ArrayList();
        converters.add(new DefaultImageViewStreamer());
        converters.add(new DefaultTextViewStreamer());
        return converters;
    }

    public final void convertView(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        ArrayList<LoadingSkeletonViewStreamer<?>> arrayList = this.converters;
        if (arrayList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"converters");
        }
        Iterable $receiver$iv = arrayList;
        for (Object element$iv : $receiver$iv) {
            LoadingSkeletonViewStreamer converter = (LoadingSkeletonViewStreamer)element$iv;
            if (this.isFirstConvert) {
                converter.start();
            }
            Context context = view.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"view.context");
            Options options = this.options;
            if (options == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            }
            converter.convertView(context, view, options);
        }
        this.isFirstRevert = true;
        this.isFirstConvert = false;
    }

    public final void revertView(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        ArrayList<LoadingSkeletonViewStreamer<?>> arrayList = this.converters;
        if (arrayList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"converters");
        }
        Iterable $receiver$iv = arrayList;
        for (Object element$iv : $receiver$iv) {
            LoadingSkeletonViewStreamer converter = (LoadingSkeletonViewStreamer)element$iv;
            if (this.isFirstRevert) {
                converter.stop();
            }
            Context context = view.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"view.context");
            converter.revertView(context, view);
        }
        this.isFirstConvert = true;
        this.isFirstRevert = false;
    }

    private LoadingSkeletonViewConverter() {
    }

    private LoadingSkeletonViewConverter(Builder builder) {
        this();
        if (builder.getConverters$loading_skeleton_release() == null) {
            this.converters = this.defaultStreamers();
        } else {
            ArrayList<LoadingSkeletonViewStreamer<?>> arrayList = builder.getConverters$loading_skeleton_release();
            if (arrayList == null) {
                Intrinsics.throwNpe();
            }
            this.converters = arrayList;
        }
        this.options = new Options(builder.getGradient$loading_skeleton_release(), builder.getShimmer$loading_skeleton_release(), builder.getCornerRadius$loading_skeleton_release(), builder.getColor$loading_skeleton_release());
    }

    public /* synthetic */ LoadingSkeletonViewConverter(@NotNull Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010!\u001a\u00020\u00002\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\u000bJ\u0006\u0010#\u001a\u00020$J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0018J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0018R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\\\u0010\r\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0018\u00010\nj\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0018\u0001`\f2\"\u0010\u0003\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0018\u00010\nj\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0018\u0001`\f@BX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0012@BX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0003\u001a\u00020\u0018@BX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR$\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0003\u001a\u00020\u0018@BX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001d\u00a8\u0006%"}, d2={"Lcom/github/tehras/loadingskeleton/helpers/LoadingSkeletonViewConverter$Builder;", "", "()V", "<set-?>", "", "color", "getColor$loading_skeleton_release", "()I", "setColor", "(I)V", "Ljava/util/ArrayList;", "Lcom/github/tehras/loadingskeleton/helpers/LoadingSkeletonViewStreamer;", "Lkotlin/collections/ArrayList;", "converters", "getConverters$loading_skeleton_release", "()Ljava/util/ArrayList;", "setConverters", "(Ljava/util/ArrayList;)V", "", "cornerRadius", "getCornerRadius$loading_skeleton_release", "()F", "setCornerRadius", "(F)V", "", "gradient", "getGradient$loading_skeleton_release", "()Z", "setGradient", "(Z)V", "shimmer", "getShimmer$loading_skeleton_release", "setShimmer", "addConvert", "converter", "build", "Lcom/github/tehras/loadingskeleton/helpers/LoadingSkeletonViewConverter;", "loading-skeleton_release"})
    public static final class Builder {
        @Nullable
        private ArrayList<LoadingSkeletonViewStreamer<?>> converters;
        private int color = R.color.loading_skeleton_default_animation_color;
        private float cornerRadius = 5.0f;
        private boolean gradient = true;
        private boolean shimmer = true;

        @Nullable
        public final ArrayList<LoadingSkeletonViewStreamer<?>> getConverters$loading_skeleton_release() {
            return this.converters;
        }

        private final void setConverters(ArrayList<LoadingSkeletonViewStreamer<?>> arrayList) {
            this.converters = arrayList;
        }

        public final int getColor$loading_skeleton_release() {
            return this.color;
        }

        private final void setColor(int n) {
            this.color = n;
        }

        public final float getCornerRadius$loading_skeleton_release() {
            return this.cornerRadius;
        }

        private final void setCornerRadius(float f) {
            this.cornerRadius = f;
        }

        public final boolean getGradient$loading_skeleton_release() {
            return this.gradient;
        }

        private final void setGradient(boolean bl) {
            this.gradient = bl;
        }

        public final boolean getShimmer$loading_skeleton_release() {
            return this.shimmer;
        }

        private final void setShimmer(boolean bl) {
            this.shimmer = bl;
        }

        @NotNull
        public final Builder color(int color) {
            this.color = color;
            return this;
        }

        @NotNull
        public final Builder gradient(boolean gradient) {
            this.gradient = gradient;
            return this;
        }

        @NotNull
        public final Builder shimmer(boolean shimmer) {
            this.shimmer = shimmer;
            return this;
        }

        @NotNull
        public final Builder addConvert(@NotNull LoadingSkeletonViewStreamer<?> converter) {
            Intrinsics.checkParameterIsNotNull(converter, (String)"converter");
            if (this.converters == null) {
                this.converters = new ArrayList();
            }
            ArrayList<LoadingSkeletonViewStreamer<?>> arrayList = this.converters;
            if (arrayList == null) {
                Intrinsics.throwNpe();
            }
            arrayList.add(converter);
            return this;
        }

        @NotNull
        public final LoadingSkeletonViewConverter build() {
            return new LoadingSkeletonViewConverter(this, null);
        }
    }
}

