/*
 * Decompiled with CFR 0.152.
 */
package com.github.tehras.loadingskeleton.helpers;

import android.content.Context;
import android.view.View;
import com.github.tehras.loadingskeleton.R;
import com.github.tehras.loadingskeleton.helpers.LoadingSkeletonViewStreamer;
import com.github.tehras.loadingskeleton.view_streamers.DefaultImageViewStreamer;
import com.github.tehras.loadingskeleton.view_streamers.DefaultTextViewStreamer;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0016B\u000f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J \u0010\u0014\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nj\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b`\fH\u0002J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR&\u0010\t\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nj\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b`\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/github/tehras/loadingskeleton/helpers/LoadingSkeletonViewConverter;", "", "builder", "Lcom/github/tehras/loadingskeleton/helpers/LoadingSkeletonViewConverter$Builder;", "(Lcom/github/tehras/loadingskeleton/helpers/LoadingSkeletonViewConverter$Builder;)V", "()V", "color", "", "Ljava/lang/Integer;", "converters", "Ljava/util/ArrayList;", "Lcom/github/tehras/loadingskeleton/helpers/LoadingSkeletonViewStreamer;", "Lkotlin/collections/ArrayList;", "isFirstConvert", "", "isFirstRevert", "convertView", "", "view", "Landroid/view/View;", "defaultStreamers", "revertView", "Builder", "loading-skeleton_release"})
public final class LoadingSkeletonViewConverter {
    private ArrayList<LoadingSkeletonViewStreamer<?>> converters;
    private boolean isFirstConvert = true;
    private boolean isFirstRevert = true;
    private Integer color;

    private final ArrayList<LoadingSkeletonViewStreamer<?>> defaultStreamers() {
        ArrayList converters = new ArrayList();
        converters.add(new DefaultImageViewStreamer());
        converters.add(new DefaultTextViewStreamer());
        return converters;
    }

    public final void convertView(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        ArrayList<LoadingSkeletonViewStreamer<?>> arrayList = this.converters;
        if (arrayList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"converters");
        }
        Iterable $receiver$iv = arrayList;
        for (Object element$iv : $receiver$iv) {
            LoadingSkeletonViewStreamer converter = (LoadingSkeletonViewStreamer)element$iv;
            if (this.isFirstConvert) {
                converter.start();
            }
            Context context = view.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"view.context");
            Integer n = this.color;
            if (n == null) {
                Intrinsics.throwNpe();
            }
            converter.convertView(context, view, n);
        }
        this.isFirstRevert = true;
        this.isFirstConvert = false;
    }

    public final void revertView(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        ArrayList<LoadingSkeletonViewStreamer<?>> arrayList = this.converters;
        if (arrayList == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"converters");
        }
        Iterable $receiver$iv = arrayList;
        for (Object element$iv : $receiver$iv) {
            LoadingSkeletonViewStreamer converter = (LoadingSkeletonViewStreamer)element$iv;
            if (this.isFirstRevert) {
                converter.stop();
            }
            Context context = view.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"view.context");
            converter.revertView(context, view);
        }
        this.isFirstConvert = true;
        this.isFirstRevert = false;
    }

    private LoadingSkeletonViewConverter() {
    }

    private LoadingSkeletonViewConverter(Builder builder) {
        this();
        if (builder.getConverters() == null) {
            this.converters = this.defaultStreamers();
        } else {
            ArrayList<LoadingSkeletonViewStreamer<?>> arrayList = builder.getConverters();
            if (arrayList == null) {
                Intrinsics.throwNpe();
            }
            this.converters = arrayList;
        }
        this.color = builder.getColor();
    }

    public /* synthetic */ LoadingSkeletonViewConverter(@NotNull Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0013\u001a\u00020\u00002\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\fJ\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004R\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\t\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\\\u0010\u000e\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0018\u00010\u000bj\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0018\u0001`\r2\"\u0010\n\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0018\u00010\u000bj\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0018\u0001`\r@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lcom/github/tehras/loadingskeleton/helpers/LoadingSkeletonViewConverter$Builder;", "", "()V", "color", "", "getColor", "()Ljava/lang/Integer;", "setColor", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "<set-?>", "Ljava/util/ArrayList;", "Lcom/github/tehras/loadingskeleton/helpers/LoadingSkeletonViewStreamer;", "Lkotlin/collections/ArrayList;", "converters", "getConverters", "()Ljava/util/ArrayList;", "setConverters", "(Ljava/util/ArrayList;)V", "addConvert", "converter", "build", "Lcom/github/tehras/loadingskeleton/helpers/LoadingSkeletonViewConverter;", "loading-skeleton_release"})
    public static final class Builder {
        @Nullable
        private ArrayList<LoadingSkeletonViewStreamer<?>> converters;
        @Nullable
        private Integer color;

        @Nullable
        public final ArrayList<LoadingSkeletonViewStreamer<?>> getConverters() {
            return this.converters;
        }

        private final void setConverters(ArrayList<LoadingSkeletonViewStreamer<?>> arrayList) {
            this.converters = arrayList;
        }

        @Nullable
        public final Integer getColor() {
            return this.color;
        }

        public final void setColor(@Nullable Integer n) {
            this.color = n;
        }

        @NotNull
        public final Builder color(int color) {
            this.color = color;
            return this;
        }

        @NotNull
        public final Builder addConvert(@NotNull LoadingSkeletonViewStreamer<?> converter) {
            Intrinsics.checkParameterIsNotNull(converter, (String)"converter");
            if (this.converters == null) {
                this.converters = new ArrayList();
            }
            ArrayList<LoadingSkeletonViewStreamer<?>> arrayList = this.converters;
            if (arrayList == null) {
                Intrinsics.throwNpe();
            }
            arrayList.add(converter);
            return this;
        }

        @NotNull
        public final LoadingSkeletonViewConverter build() {
            if (this.color == null) {
                this.color = R.color.loading_skeleton_default_animation_color;
            }
            return new LoadingSkeletonViewConverter(this, null);
        }
    }
}

