/*
 * Decompiled with CFR 0.152.
 */
package net.rithms.riot.api;

import java.util.Objects;
import java.util.logging.Level;
import net.rithms.riot.api.request.ratelimit.DefaultRateLimitHandler;
import net.rithms.riot.api.request.ratelimit.RateLimitHandler;

public class ApiConfig
implements Cloneable {
    public final int DEFAULT_ASYNC_REQUEST_TIMEOUT = 10000;
    public final Level DEFAULT_DEBUG_LEVEL = Level.WARNING;
    public final boolean DEFAULT_DEBUG_TO_FILE = false;
    public final int DEFAULT_MAX_ASYNC_THREADS = 0;
    public final RateLimitHandler DEFAULT_RATE_LIMIT_HANDLER = new DefaultRateLimitHandler();
    public final int DEFAULT_REQUEST_TIMEOUT = 0;
    public final boolean DEFAULT_TOURNAMENT_MOCK_MODE = false;
    private int asyncRequestTimeout = 10000;
    private Level debugLevel = this.DEFAULT_DEBUG_LEVEL;
    private boolean debugToFile = false;
    private String key = null;
    private int maxAsyncThreads = 0;
    private RateLimitHandler rateLimitHandler = this.DEFAULT_RATE_LIMIT_HANDLER;
    private int requestTimeout = 0;
    private String tournamentKey = null;
    private boolean tournamentMockMode = false;

    public ApiConfig clone() {
        return new ApiConfig().setAsyncRequestTimeout(this.getAsyncRequestTimeout()).setDebugLevel(this.getDebugLevel()).setDebugToFile(this.getDebugToFile()).setKey(this.getKey()).setMaxAsyncThreads(this.getMaxAsyncThreads()).setRateLimitHandler(this.getRateLimitHandler()).setRequestTimeout(this.getRequestTimeout()).setTournamentKey(this.getTournamentKey()).setTournamentMockMode(this.getTournamentMockMode());
    }

    public int getAsyncRequestTimeout() {
        return this.asyncRequestTimeout;
    }

    public Level getDebugLevel() {
        return this.debugLevel;
    }

    public boolean getDebugToFile() {
        return this.debugToFile;
    }

    public String getKey() {
        return this.key;
    }

    public int getMaxAsyncThreads() {
        return this.maxAsyncThreads;
    }

    public RateLimitHandler getRateLimitHandler() {
        return this.rateLimitHandler;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public String getTournamentKey() {
        return this.tournamentKey;
    }

    public boolean getTournamentMockMode() {
        return this.tournamentMockMode;
    }

    public ApiConfig setAsyncRequestTimeout(int asyncRequestTimeout) {
        if (asyncRequestTimeout < 0) {
            throw new IllegalArgumentException("The timeout value must be greater than or equal to 0");
        }
        this.asyncRequestTimeout = asyncRequestTimeout;
        return this;
    }

    public ApiConfig setDebugLevel(Level debugLevel) {
        Objects.requireNonNull(debugLevel, "debug level must not be null");
        this.debugLevel = debugLevel;
        return this;
    }

    public ApiConfig setDebugToFile(boolean debugToFile) {
        this.debugToFile = debugToFile;
        return this;
    }

    public ApiConfig setKey(String key) {
        Objects.requireNonNull(key, "key must not be null");
        this.key = key;
        return this;
    }

    public ApiConfig setMaxAsyncThreads(int maxAsyncThreads) {
        if (maxAsyncThreads < 0) {
            throw new IllegalArgumentException("The max amount of threads to run must be greater than or equal to 0");
        }
        this.maxAsyncThreads = maxAsyncThreads;
        return this;
    }

    public ApiConfig setRateLimitHandler(RateLimitHandler rateLimitHandler) {
        this.rateLimitHandler = rateLimitHandler;
        return this;
    }

    public ApiConfig setRequestTimeout(int requestTimeout) {
        if (requestTimeout < 0) {
            throw new IllegalArgumentException("The timeout value must be greater than or equal to 0");
        }
        this.requestTimeout = requestTimeout;
        return this;
    }

    public ApiConfig setTournamentKey(String tournamentKey) {
        Objects.requireNonNull(tournamentKey, "tournamentKey must not be null");
        this.tournamentKey = tournamentKey;
        return this;
    }

    public ApiConfig setTournamentMockMode(boolean tournamentMockMode) {
        this.tournamentMockMode = tournamentMockMode;
        return this;
    }
}

