/*
 * Decompiled with CFR 0.152.
 */
package com.tarek360.instacapture.screenshot.nonMaps;

import android.app.Activity;
import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.WindowManager;
import com.tarek360.instacapture.exception.ScreenCapturingFailedException;
import com.tarek360.instacapture.screenshot.nonMaps.RootViewInfo;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

class FieldHelper {
    private static final String FIELD_NAME_WINDOW_MANAGER = "mWindowManager";
    private static final String FIELD_NAME_GLOBAL = "mGlobal";
    private static final String FIELD_NAME_ROOTS = "mRoots";
    private static final String FIELD_NAME_PARAMS = "mParams";
    private static final String FIELD_NAME_ATTACH_INFO = "mAttachInfo";
    private static final String FIELD_NAME_WINDOW_TOP = "mWindowTop";
    private static final String FIELD_NAME_WINDOW_LEFT = "mWindowLeft";
    private static final String FIELD_NAME_WINDOW_FRAME = "mWinFrame";
    private static final String FIELD_NAME_VIEW = "mView";

    private FieldHelper() {
    }

    public static List<RootViewInfo> getRootViews(Activity activity) {
        WindowManager.LayoutParams[] params;
        Object[] roots;
        ArrayList<RootViewInfo> rootViews = new ArrayList<RootViewInfo>();
        Object globalWindowManager = Build.VERSION.SDK_INT <= 16 ? FieldHelper.getFieldValue(FIELD_NAME_WINDOW_MANAGER, activity.getWindowManager()) : FieldHelper.getFieldValue(FIELD_NAME_GLOBAL, activity.getWindowManager());
        Object rootObjects = FieldHelper.getFieldValue(FIELD_NAME_ROOTS, globalWindowManager);
        Object paramsObject = FieldHelper.getFieldValue(FIELD_NAME_PARAMS, globalWindowManager);
        if (Build.VERSION.SDK_INT >= 19) {
            roots = ((List)rootObjects).toArray();
            List paramsList = (List)paramsObject;
            params = paramsList.toArray(new WindowManager.LayoutParams[paramsList.size()]);
        } else {
            roots = (Object[])rootObjects;
            params = (WindowManager.LayoutParams[])paramsObject;
        }
        for (int i = 0; i < roots.length; ++i) {
            Object root = roots[i];
            Object attachInfo = FieldHelper.getFieldValue(FIELD_NAME_ATTACH_INFO, root);
            int top = (Integer)FieldHelper.getFieldValue(FIELD_NAME_WINDOW_TOP, attachInfo);
            int left = (Integer)FieldHelper.getFieldValue(FIELD_NAME_WINDOW_LEFT, attachInfo);
            Rect winFrame = (Rect)FieldHelper.getFieldValue(FIELD_NAME_WINDOW_FRAME, root);
            Rect area = new Rect(left, top, left + winFrame.width(), top + winFrame.height());
            View view = (View)FieldHelper.getFieldValue(FIELD_NAME_VIEW, root);
            rootViews.add(new RootViewInfo(view, area, params[i]));
        }
        return rootViews;
    }

    private static Object getFieldValue(String fieldName, Object target) {
        try {
            Field field = FieldHelper.findField(fieldName, target.getClass());
            field.setAccessible(true);
            return field.get(target);
        }
        catch (Exception e) {
            throw new ScreenCapturingFailedException(e);
        }
    }

    private static Field findField(String name, Class clazz) throws NoSuchFieldException {
        for (Class currentClass = clazz; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Field field : currentClass.getDeclaredFields()) {
                if (!name.equals(field.getName())) continue;
                return field;
            }
        }
        throw new NoSuchFieldException("The field " + name + " isn't found for " + clazz.toString());
    }
}

