/*
 * Decompiled with CFR 0.152.
 */
package com.tarek360.instacapture;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.tarek360.instacapture.ActivityReferenceManager;
import com.tarek360.instacapture.InstaCaptureConfiguration;
import com.tarek360.instacapture.exception.ActivityNotRunningException;
import com.tarek360.instacapture.listener.ScreenCaptureListener;
import com.tarek360.instacapture.screenshot.ScreenshotProvider;
import com.tarek360.instacapture.screenshot.ScreenshotProviderImpl;
import com.tarek360.instacapture.utility.Logger;
import java.io.File;
import rx.Observable;
import rx.Subscriber;
import rx.android.schedulers.AndroidSchedulers;

public final class InstaCapture {
    private static final String MESSAGE_IS_ACTIVITY_RUNNING = "Is your activity running?";
    private static final String MESSAGE_BUSY = "InstaCapture is busy, please wait!";
    private static final String ERROR_INIT_WITH_DESTROYED_ACTIVITY = "Your Activity may be destroyed";
    private static final String ERROR_SCREENSHOT_CAPTURE_FAILED = "Screenshot capture failed";
    private static InstaCapture instance;
    private static Listener listener;
    @NonNull
    private ActivityReferenceManager activityReferenceManager = new ActivityReferenceManager();
    @NonNull
    private ScreenshotProvider screenshotProvider;
    private ScreenCaptureListener mScreenCapturingListener;

    private InstaCapture(@NonNull Activity activity) {
        this.activityReferenceManager.setActivity(activity);
        this.screenshotProvider = this.getScreenshotProvider();
    }

    public static void setConfiguration(InstaCaptureConfiguration configuration) {
        if (configuration.logging) {
            Logger.enable();
        } else {
            Logger.disable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InstaCapture getInstance(@NonNull Activity activity) {
        Class<InstaCapture> clazz = InstaCapture.class;
        synchronized (InstaCapture.class) {
            if (instance == null) {
                instance = new InstaCapture(activity);
            } else {
                instance.setActivity(activity);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private void setActivity(@NonNull Activity activity) {
        this.activityReferenceManager.setActivity(activity);
    }

    public Listener capture() {
        this.capture((File)null, (View[])null);
        return this.getListener();
    }

    public Listener capture(File file) {
        this.capture(file, null);
        return this.getListener();
    }

    public Listener capture(View ... ignoredViews) {
        this.capture((File)null, ignoredViews);
        return this.getListener();
    }

    public Listener capture(File file, View ... ignoredViews) {
        this.captureRx(file, ignoredViews).subscribe((Subscriber)new Subscriber<File>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
                Logger.e(InstaCapture.ERROR_SCREENSHOT_CAPTURE_FAILED);
                Logger.printStackTrace(e);
                if (InstaCapture.this.mScreenCapturingListener != null) {
                    InstaCapture.this.mScreenCapturingListener.onCaptureFailed(e);
                }
            }

            public void onNext(File file) {
                if (InstaCapture.this.mScreenCapturingListener != null) {
                    InstaCapture.this.mScreenCapturingListener.onCaptureComplete(file);
                }
            }
        });
        return this.getListener();
    }

    public Observable<File> captureRx() {
        return this.captureRx((File)null, (View[])null);
    }

    public Observable<File> captureRx(@Nullable File file) {
        return this.captureRx(file, null);
    }

    public Observable<File> captureRx(View ... ignoredViews) {
        return this.captureRx((File)null, ignoredViews);
    }

    public Observable<File> captureRx(@Nullable File file, View ... ignoredViews) {
        Activity activity = this.activityReferenceManager.getValidatedActivity();
        if (activity == null) {
            return Observable.error((Throwable)new ActivityNotRunningException(MESSAGE_IS_ACTIVITY_RUNNING));
        }
        if (this.mScreenCapturingListener != null) {
            this.mScreenCapturingListener.onCaptureStarted();
        }
        return this.screenshotProvider.getScreenshotFile(activity, file, ignoredViews).observeOn(AndroidSchedulers.mainThread());
    }

    private ScreenshotProvider getScreenshotProvider() {
        Activity activity = this.activityReferenceManager.getValidatedActivity();
        if (activity == null) {
            Logger.e(MESSAGE_IS_ACTIVITY_RUNNING);
            throw new IllegalArgumentException(ERROR_INIT_WITH_DESTROYED_ACTIVITY);
        }
        return new ScreenshotProviderImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Listener getListener() {
        Class<Listener> clazz = Listener.class;
        synchronized (Listener.class) {
            if (listener == null) {
                listener = new Listener();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return listener;
        }
    }

    public final class Listener {
        private Listener() {
        }

        public void setScreenCapturingListener(@NonNull ScreenCaptureListener listener) {
            InstaCapture.this.mScreenCapturingListener = listener;
        }
    }
}

