/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.ratelimiter.model;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StreamUtils;

public final class LuaScript {
    private static final Logger log = LoggerFactory.getLogger(LuaScript.class);
    private static final String timeWindowRateLimiterScript = LuaScript.getRateLimiterScript("META-INF/timeWindow-rateLimit.lua");
    private static final String tokenBucketRateLimiterScript = LuaScript.getRateLimiterScript("META-INF/tokenBucket-rateLimit.lua");

    private LuaScript() {
    }

    private static String getRateLimiterScript(String scriptFileName) {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(scriptFileName);
        try {
            return StreamUtils.copyToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            log.error("tokenBucket-rateLimit.lua Initialization failure", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String getTimeWindowRateLimiterScript() {
        return timeWindowRateLimiterScript;
    }

    public static String getTokenBucketRateLimiterScript() {
        return tokenBucketRateLimiterScript;
    }
}

