/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.ratelimiter.core;

import com.taptap.ratelimiter.core.RateLimiter;
import com.taptap.ratelimiter.model.LuaScript;
import com.taptap.ratelimiter.model.Result;
import com.taptap.ratelimiter.model.Rule;
import java.util.Arrays;
import java.util.List;
import org.redisson.api.RScript;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.springframework.stereotype.Component;

@Component
public class TokenBucketRateLimiter
implements RateLimiter {
    private final RScript rScript;

    public TokenBucketRateLimiter(RedissonClient client) {
        this.rScript = client.getScript((Codec)LongCodec.INSTANCE);
    }

    @Override
    public Result isAllowed(Rule rule) {
        List<Object> keys = TokenBucketRateLimiter.getKeys(rule.getKey());
        String script = LuaScript.getTokenBucketRateLimiterScript();
        List results = (List)this.rScript.eval(RScript.Mode.READ_WRITE, script, RScript.ReturnType.MULTI, keys, new Object[]{rule.getRate(), rule.getBucketCapacity(), rule.getRequestedTokens()});
        boolean isAllowed = (Long)results.get(0) == 1L;
        long newTokens = (Long)results.get(1);
        return new Result(isAllowed, newTokens);
    }

    static List<Object> getKeys(String key) {
        String prefix = "request_rate_limiter.{" + key;
        String tokenKey = prefix + "}.tokens";
        String timestampKey = prefix + "}.timestamp";
        return Arrays.asList(tokenKey, timestampKey);
    }
}

