/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.ratelimiter.core;

import com.taptap.ratelimiter.annotation.RateLimit;
import com.taptap.ratelimiter.annotation.RateLimitKey;
import com.taptap.ratelimiter.exception.ExecuteFunctionException;
import com.taptap.ratelimiter.model.Rule;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.convert.DurationStyle;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MethodBasedEvaluationContext;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class RuleProvider
implements BeanFactoryAware {
    private static final Logger logger = LoggerFactory.getLogger(RuleProvider.class);
    private final ParameterNameDiscoverer nameDiscoverer = new DefaultParameterNameDiscoverer();
    private static final TemplateParserContext PARSER_CONTEXT = new TemplateParserContext();
    private final ExpressionParser parser = new SpelExpressionParser();
    private final StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
    private BeanFactory beanFactory;

    public String getKeyName(JoinPoint joinPoint, RateLimit rateLimit) {
        Method method = this.getMethod(joinPoint);
        List<String> definitionKeys = this.getSpelDefinitionKey(rateLimit.keys(), method, joinPoint.getArgs());
        ArrayList<String> keyList = new ArrayList<String>(definitionKeys);
        List<String> parameterKeys = this.getParameterKey(method.getParameters(), joinPoint.getArgs());
        keyList.addAll(parameterKeys);
        return StringUtils.collectionToDelimitedString(keyList, (String)"", (String)"-", (String)"");
    }

    public int getRate(RateLimit rateLimit) {
        String value;
        if (StringUtils.hasText((String)rateLimit.rateExpression()) && (value = (String)this.parser.parseExpression(this.resolve(rateLimit.rateExpression()), (ParserContext)PARSER_CONTEXT).getValue(String.class)) != null) {
            return Integer.parseInt(value);
        }
        return rateLimit.rate();
    }

    public int getBucketCapacity(RateLimit rateLimit) {
        String value;
        if (StringUtils.hasText((String)rateLimit.bucketCapacityExpression()) && (value = (String)this.parser.parseExpression(this.resolve(rateLimit.bucketCapacityExpression()), (ParserContext)PARSER_CONTEXT).getValue(String.class)) != null) {
            return Integer.parseInt(value);
        }
        return rateLimit.bucketCapacity();
    }

    private Method getMethod(JoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        if (method.getDeclaringClass().isInterface()) {
            try {
                method = joinPoint.getTarget().getClass().getDeclaredMethod(signature.getName(), method.getParameterTypes());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return method;
    }

    private List<String> getSpelDefinitionKey(String[] definitionKeys, Method method, Object[] parameterValues) {
        ArrayList<String> definitionKeyList = new ArrayList<String>();
        for (String definitionKey : definitionKeys) {
            if (ObjectUtils.isEmpty((Object)definitionKey)) continue;
            MethodBasedEvaluationContext context = new MethodBasedEvaluationContext(null, method, parameterValues, this.nameDiscoverer);
            Object objKey = this.parser.parseExpression(definitionKey).getValue((EvaluationContext)context);
            definitionKeyList.add(ObjectUtils.nullSafeToString((Object)objKey));
        }
        return definitionKeyList;
    }

    private List<String> getParameterKey(Parameter[] parameters, Object[] parameterValues) {
        ArrayList<String> parameterKey = new ArrayList<String>();
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].getAnnotation(RateLimitKey.class) == null) continue;
            RateLimitKey keyAnnotation = parameters[i].getAnnotation(RateLimitKey.class);
            if (keyAnnotation.value().isEmpty()) {
                Object parameterValue = parameterValues[i];
                parameterKey.add(ObjectUtils.nullSafeToString((Object)parameterValue));
                continue;
            }
            StandardEvaluationContext context = new StandardEvaluationContext(parameterValues[i]);
            Object key = this.parser.parseExpression(keyAnnotation.value()).getValue((EvaluationContext)context);
            parameterKey.add(ObjectUtils.nullSafeToString((Object)key));
        }
        return parameterKey;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
    }

    private String resolve(String value) {
        return ((ConfigurableBeanFactory)this.beanFactory).resolveEmbeddedValue(value);
    }

    private String getKey(MethodSignature signature) {
        return String.format("%s.%s", signature.getDeclaringTypeName(), signature.getMethod().getName());
    }

    Rule getRateLimiterRule(JoinPoint joinPoint, RateLimit rateLimit) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        String businessKeyName = this.getKeyName(joinPoint, rateLimit);
        String rateLimitKey = this.getKey(signature) + businessKeyName;
        if (StringUtils.hasLength((String)rateLimit.customKeyFunction())) {
            try {
                rateLimitKey = this.getKey(signature) + this.executeFunction(rateLimit.customKeyFunction(), joinPoint).toString();
            }
            catch (Throwable throwable) {
                logger.info("Gets the custom Key exception and degrades it to the default Key:{}", (Object)rateLimit, (Object)throwable);
            }
        }
        int rate = this.getRate(rateLimit);
        int bucketCapacity = this.getBucketCapacity(rateLimit);
        long rateInterval = DurationStyle.detectAndParse((String)rateLimit.rateInterval()).getSeconds();
        Rule rule = new Rule(rateLimitKey, rate, rateLimit.mode());
        rule.setRateInterval(Long.valueOf(rateInterval).intValue());
        rule.setFallbackFunction(rateLimit.fallbackFunction());
        rule.setRequestedTokens(rateLimit.requestedTokens());
        rule.setBucketCapacity(bucketCapacity);
        return rule;
    }

    public Object executeFunction(String fallbackName, JoinPoint joinPoint) throws Throwable {
        Object res;
        Method handleMethod;
        Method currentMethod = ((MethodSignature)joinPoint.getSignature()).getMethod();
        Object target = joinPoint.getTarget();
        try {
            handleMethod = joinPoint.getTarget().getClass().getDeclaredMethod(fallbackName, currentMethod.getParameterTypes());
            handleMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Illegal annotation param customLockTimeoutStrategy", e);
        }
        Object[] args = joinPoint.getArgs();
        try {
            res = handleMethod.invoke(target, args);
        }
        catch (IllegalAccessException e) {
            throw new ExecuteFunctionException("Fail to invoke custom lock timeout handler: " + fallbackName, e);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        return res;
    }
}

