/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.ratelimiter.core;

import com.taptap.ratelimiter.annotation.RateLimit;
import com.taptap.ratelimiter.core.RateLimiterService;
import com.taptap.ratelimiter.core.RuleProvider;
import com.taptap.ratelimiter.exception.RateLimitException;
import com.taptap.ratelimiter.model.Result;
import com.taptap.ratelimiter.model.Rule;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Aspect
@Component
@Order(value=0)
public class RateLimitAspectHandler {
    private static final Logger logger = LoggerFactory.getLogger(RateLimitAspectHandler.class);
    private final RateLimiterService rateLimiterService;
    private final RuleProvider ruleProvider;

    public RateLimitAspectHandler(RateLimiterService lockInfoProvider, RuleProvider ruleProvider) {
        this.rateLimiterService = lockInfoProvider;
        this.ruleProvider = ruleProvider;
    }

    @Around(value="@annotation(rateLimit)")
    public Object around(ProceedingJoinPoint joinPoint, RateLimit rateLimit) throws Throwable {
        Rule rule = this.ruleProvider.getRateLimiterRule((JoinPoint)joinPoint, rateLimit);
        Result result = this.rateLimiterService.isAllowed(rule);
        boolean allowed = result.isAllow();
        if (!allowed) {
            logger.info("Trigger current limiting,key:{}", (Object)rule.getKey());
            if (StringUtils.hasLength((String)rule.getFallbackFunction())) {
                return this.ruleProvider.executeFunction(rule.getFallbackFunction(), (JoinPoint)joinPoint);
            }
            long extra = result.getExtra();
            throw new RateLimitException("Too Many Requests", extra, rule.getMode());
        }
        return joinPoint.proceed();
    }
}

