/*
 * Decompiled with CFR 0.152.
 */
package com.taptap.ratelimiter.configuration;

import com.taptap.ratelimiter.configuration.RateLimiterProperties;
import com.taptap.ratelimiter.core.RateLimitAspectHandler;
import com.taptap.ratelimiter.core.RateLimiterService;
import com.taptap.ratelimiter.core.RuleProvider;
import com.taptap.ratelimiter.web.RateLimitExceptionHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnProperty(prefix="spring.ratelimiter", name={"enabled"}, havingValue="true")
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
@EnableConfigurationProperties(value={RateLimiterProperties.class})
@Import(value={RateLimitAspectHandler.class, RateLimitExceptionHandler.class})
public class RateLimiterAutoConfiguration {
    private final RateLimiterProperties limiterProperties;
    public static final String REDISSON_BEAN_NAME = "rateLimiterRedissonBeanName";

    public RateLimiterAutoConfiguration(RateLimiterProperties limiterProperties) {
        this.limiterProperties = limiterProperties;
    }

    @Bean(name={"rateLimiterRedissonBeanName"}, destroyMethod="shutdown")
    RedissonClient redisson() {
        Config config = new Config();
        if (this.limiterProperties.getRedisClusterServer() != null) {
            ((ClusterServersConfig)config.useClusterServers().setPassword(this.limiterProperties.getRedisPassword())).addNodeAddress(this.limiterProperties.getRedisClusterServer().getNodeAddresses());
        } else {
            config.useSingleServer().setAddress(this.limiterProperties.getRedisAddress()).setDatabase(this.limiterProperties.getRedisDatabase()).setPassword(this.limiterProperties.getRedisPassword());
        }
        config.setEventLoopGroup((EventLoopGroup)new NioEventLoopGroup());
        return Redisson.create((Config)config);
    }

    @Bean
    public RuleProvider bizKeyProvider() {
        return new RuleProvider();
    }

    @Bean
    public RateLimiterService rateLimiterInfoProvider() {
        return new RateLimiterService(this.redisson());
    }
}

