/*
 * Decompiled with CFR 0.152.
 */
package com.tapadoo.alerter;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.tapadoo.alerter.Alert;
import com.tapadoo.alerter.OnHideAlertListener;
import com.tapadoo.alerter.OnShowAlertListener;
import com.tapadoo.alerter.R;
import java.lang.ref.WeakReference;

public final class Alerter {
    private static WeakReference<Activity> activityWeakReference;
    private Alert alert;

    private Alerter() {
    }

    public static Alerter create(@NonNull Activity activity) {
        if (activity == null) {
            throw new IllegalArgumentException("Activity cannot be null!");
        }
        Alerter alerter = new Alerter();
        Alerter.clearCurrent(activity);
        alerter.setActivity(activity);
        alerter.setAlert(new Alert((Context)activity));
        return alerter;
    }

    private static void clearCurrent(@NonNull Activity activity) {
        if (activity == null) {
            return;
        }
        try {
            final View alertView = activity.getWindow().getDecorView().findViewById(R.id.flAlertBackground);
            if (alertView == null || alertView.getWindowToken() == null) {
                Log.d((String)Alerter.class.getClass().getSimpleName(), (String)activity.getString(R.string.msg_no_alert_showing));
            } else {
                alertView.animate().alpha(0.0f).withEndAction(new Runnable(){

                    @Override
                    public void run() {
                        ((ViewGroup)alertView.getParent()).removeView(alertView);
                    }
                }).start();
                Log.d((String)Alerter.class.getClass().getSimpleName(), (String)activity.getString(R.string.msg_alert_cleared));
            }
        }
        catch (Exception ex) {
            Log.e((String)Alerter.class.getClass().getSimpleName(), (String)Log.getStackTraceString((Throwable)ex));
        }
    }

    public Alert show() {
        if (this.getActivityWeakReference() != null) {
            ((Activity)this.getActivityWeakReference().get()).runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ViewGroup decorView = Alerter.this.getActivityDecorView();
                    if (decorView != null && Alerter.this.getAlert().getParent() == null) {
                        decorView.addView((View)Alerter.this.getAlert());
                    }
                }
            });
        }
        return this.getAlert();
    }

    public Alerter setTitle(@StringRes int titleId) {
        if (this.getAlert() != null) {
            this.getAlert().setTitle(titleId);
        }
        return this;
    }

    public Alerter setTitle(String title) {
        if (this.getAlert() != null) {
            this.getAlert().setTitle(title);
        }
        return this;
    }

    public Alerter setText(@StringRes int textId) {
        if (this.getAlert() != null) {
            this.getAlert().setText(textId);
        }
        return this;
    }

    public Alerter setText(String text) {
        if (this.getAlert() != null) {
            this.getAlert().setText(text);
        }
        return this;
    }

    public Alerter setBackgroundColor(@ColorRes int colorResId) {
        if (this.getAlert() != null && this.getActivityWeakReference() != null) {
            this.getAlert().setAlertBackgroundColor(ContextCompat.getColor((Context)((Context)this.getActivityWeakReference().get()), (int)colorResId));
        }
        return this;
    }

    public Alerter setIcon(@DrawableRes int iconId) {
        if (this.getAlert() != null) {
            this.getAlert().setIcon(iconId);
        }
        return this;
    }

    public Alerter setOnClickListener(@NonNull View.OnClickListener onClickListener) {
        if (this.getAlert() != null) {
            this.getAlert().setOnClickListener(onClickListener);
        }
        return this;
    }

    public Alerter setDuration(@NonNull long milliseconds) {
        if (this.getAlert() != null) {
            this.getAlert().setDuration(milliseconds);
        }
        return this;
    }

    public Alerter enableIconPulse(boolean pulse) {
        if (this.getAlert() != null) {
            this.getAlert().pulseIcon(pulse);
        }
        return this;
    }

    public Alerter setOnShowListener(@NonNull OnShowAlertListener listener) {
        if (this.getAlert() != null) {
            this.getAlert().setOnShowListener(listener);
        }
        return this;
    }

    public Alerter setOnHideListener(@NonNull OnHideAlertListener listener) {
        if (this.getAlert() != null) {
            this.getAlert().setOnHideListener(listener);
        }
        return this;
    }

    private Alert getAlert() {
        return this.alert;
    }

    private void setAlert(Alert alert) {
        this.alert = alert;
    }

    @Nullable
    private WeakReference<Activity> getActivityWeakReference() {
        return activityWeakReference;
    }

    @Nullable
    private ViewGroup getActivityDecorView() {
        ViewGroup decorView = null;
        if (this.getActivityWeakReference() != null && this.getActivityWeakReference().get() != null) {
            decorView = (ViewGroup)((Activity)this.getActivityWeakReference().get()).getWindow().getDecorView();
        }
        return decorView;
    }

    private void setActivity(@NonNull Activity activity) {
        activityWeakReference = new WeakReference<Activity>(activity);
    }
}

