/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit.photomagic;

import android.text.TextUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0004H\u0007J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0004H\u0007J\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/tamsiree/rxkit/photomagic/Checker;", "", "()V", "GIF", "", "JPEG", "JPG", "PNG", "WEBP", "format", "", "checkSuffix", "path", "isImage", "", "isJPG", "isNeedCompress", "leastCompressSize", "", "RxKit_release"})
public final class Checker {
    @NotNull
    public static final Checker INSTANCE = new Checker();
    @NotNull
    private static final List<String> format = new ArrayList();
    @NotNull
    private static final String JPG = "jpg";
    @NotNull
    private static final String JPEG = "jpeg";
    @NotNull
    private static final String PNG = "png";
    @NotNull
    private static final String WEBP = "webp";
    @NotNull
    private static final String GIF = "gif";

    private Checker() {
    }

    @JvmStatic
    public static final boolean isImage(@NotNull String path) {
        String suffix;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        String string2 = path;
        int n = StringsKt.lastIndexOf$default((CharSequence)path, (String)".", (int)0, (boolean)false, (int)6, null) + 1;
        boolean bl = false;
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        string2 = suffix = string3;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        bl = false;
        String string4 = string2;
        boolean bl2 = false;
        String string5 = string4;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase(locale)");
        return format.contains(string6);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isJPG(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        String string2 = path;
        int n = StringsKt.lastIndexOf$default((CharSequence)path, (String)".", (int)0, (boolean)false, (int)6, null);
        boolean bl = false;
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        string2 = string3;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        bl = false;
        String string4 = string2;
        boolean bl2 = false;
        String string5 = string4;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase(locale)");
        String suffix = string6;
        if (StringsKt.contains$default((CharSequence)suffix, (CharSequence)JPG, (boolean)false, (int)2, null)) return true;
        if (!StringsKt.contains$default((CharSequence)suffix, (CharSequence)JPEG, (boolean)false, (int)2, null)) return false;
        return true;
    }

    @JvmStatic
    @NotNull
    public static final String checkSuffix(@NotNull String path) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (TextUtils.isEmpty((CharSequence)path)) {
            string2 = ".jpg";
        } else {
            String string3 = path;
            int n = StringsKt.lastIndexOf$default((CharSequence)path, (String)".", (int)0, (boolean)false, (int)6, null);
            boolean bl = false;
            String string4 = string3.substring(n);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        }
        return string2;
    }

    @JvmStatic
    public static final boolean isNeedCompress(int leastCompressSize, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (leastCompressSize > 0) {
            File source = new File(path);
            return !source.exists() ? false : source.length() > (long)(leastCompressSize << 10);
        }
        return true;
    }

    static {
        format.add(JPG);
        format.add(JPEG);
        format.add(PNG);
        format.add(WEBP);
        format.add(GIF);
    }
}

