/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit.demodata;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JC\u0010\b\u001a\u00020\t2\u001c\u0010\n\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\f0\u000b2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0010R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/tamsiree/rxkit/demodata/CSVFileGenerator;", "", "()V", "LINE_SEPERATOR", "", "charset", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "generate", "", "data", "", "Ljava/util/HashMap;", "columns", "", "fileName", "(Ljava/util/List;[Ljava/lang/String;Ljava/lang/String;)V", "RxKit_release"})
public final class CSVFileGenerator {
    @NotNull
    public static final CSVFileGenerator INSTANCE = new CSVFileGenerator();
    @Nullable
    private static final String LINE_SEPERATOR = System.getProperty("line.separator");
    private static final Charset charset = StandardCharsets.UTF_8;

    private CSVFileGenerator() {
    }

    public final void generate(@NotNull List<? extends HashMap<String, Object>> data, @NotNull String[] columns, @Nullable String fileName) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)columns, (String)"columns");
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
        for (HashMap<String, Object> hashMap : data) {
            String[] stringArray = Lists.newArrayList();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"newArrayList()");
            List result = (List)stringArray;
            for (String column : columns) {
                if (hashMap.get(column) != null) {
                    result.add(String.valueOf(hashMap.get(column)));
                    continue;
                }
                result.add("");
            }
            String lineData = Joiner.on((String)",").skipNulls().join((Iterable)result);
            try {
                Files.append((CharSequence)Intrinsics.stringPlus((String)lineData, (Object)LINE_SEPERATOR), (File)file, (Charset)charset);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

