/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.HandlerThread;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.tamsiree.rxkit.RxVibrateTool;
import com.tamsiree.rxkit.TLog;
import com.tamsiree.rxkit.interfaces.OnDoListener;
import com.tamsiree.rxkit.interfaces.OnSimpleListener;
import com.tamsiree.rxkit.view.RxToast;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0007J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J*\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0007J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#H\u0007J\b\u0010$\u001a\u00020\bH\u0007J$\u0010%\u001a\u00020&2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010'\u001a\u0004\u0018\u00010\f2\b\u0010(\u001a\u0004\u0018\u00010\fH\u0007J\u0010\u0010)\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001a\u0010*\u001a\u00020\u00122\b\u0010+\u001a\u0004\u0018\u00010\b2\u0006\u0010,\u001a\u00020-H\u0007J\u0010\u0010.\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020&H\u0007J\u0018\u00100\u001a\u00020\u00122\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020&H\u0007J\u0010\u00104\u001a\u00020\u00122\u0006\u00101\u001a\u000202H\u0007J\u0010\u00105\u001a\u00020\u00122\u0006\u00101\u001a\u000202H\u0007J \u00106\u001a\u00020\u00122\u0006\u00101\u001a\u0002022\u0006\u00107\u001a\u00020&2\u0006\u00108\u001a\u00020\u001aH\u0007J \u00109\u001a\u00020\u00122\u0006\u00101\u001a\u0002022\u0006\u00107\u001a\u00020&2\u0006\u00108\u001a\u00020\u001aH\u0007J\u0012\u0010:\u001a\u00020\f2\b\u0010;\u001a\u0004\u0018\u00010\fH\u0007R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/tamsiree/rxkit/RxTool;", "", "()V", "backgroundHandler", "Landroid/os/Handler;", "getBackgroundHandler", "()Landroid/os/Handler;", "context", "Landroid/content/Context;", "lastClickTime", "", "Md5", "", "MStr", "bytesToHexString", "bytes", "", "countDown", "", "textView", "Landroid/widget/TextView;", "waitTime", "interval", "hint", "crashLogFile", "switch", "", "debugLog", "debugLogFile", "delayToDo", "delayTime", "onSimpleListener", "Lcom/tamsiree/rxkit/interfaces/OnSimpleListener;", "fixListViewHeight", "listView", "Landroid/widget/ListView;", "getContext", "getResIdByName", "", "name", "defType", "init", "initFastClickAndVibrate", "mContext", "onRxSimple", "Lcom/tamsiree/rxkit/interfaces/OnDoListener;", "isFastClick", "millisecond", "setEdDecimal", "editText", "Landroid/widget/EditText;", "count", "setEdTwoDecimal", "setEdType", "setEditNumber", "number", "isStartForZero", "setEditNumberAuto", "stringFilter", "str", "RxKit_release"})
public final class RxTool {
    @SuppressLint(value={"StaticFieldLeak"})
    private static Context context;
    private static long lastClickTime;
    public static final RxTool INSTANCE;

    @JvmStatic
    @NotNull
    public static final RxTool init(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        RxTool.context = context.getApplicationContext();
        TLog.init(context);
        return INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final Context getContext() {
        if (context != null) {
            Context context = RxTool.context;
            if (context == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.content.Context");
            }
            return context;
        }
        throw (Throwable)new NullPointerException("\u8bf7\u5148\u8c03\u7528init()\u65b9\u6cd5");
    }

    @NotNull
    public final RxTool debugLog(boolean bl) {
        TLog.INSTANCE.switchLog(bl);
        return INSTANCE;
    }

    @NotNull
    public final RxTool debugLogFile(boolean bl) {
        TLog.INSTANCE.switch2File(bl);
        return INSTANCE;
    }

    @NotNull
    public final RxTool crashLogFile(boolean bl) {
        TLog.INSTANCE.switchCrashFile(bl);
        return INSTANCE;
    }

    @JvmStatic
    public static final void delayToDo(long delayTime, @NotNull OnSimpleListener onSimpleListener) {
        Intrinsics.checkParameterIsNotNull((Object)onSimpleListener, (String)"onSimpleListener");
        new Handler().postDelayed(new Runnable(onSimpleListener){
            final /* synthetic */ OnSimpleListener $onSimpleListener;

            public final void run() {
                this.$onSimpleListener.doSomething();
            }
            {
                this.$onSimpleListener = onSimpleListener;
            }
        }, delayTime);
    }

    @JvmStatic
    public static final void countDown(@NotNull TextView textView, long waitTime, long interval, @Nullable String hint) {
        Intrinsics.checkParameterIsNotNull((Object)textView, (String)"textView");
        textView.setEnabled(false);
        CountDownTimer timer2 = new CountDownTimer(textView, hint, waitTime, interval, waitTime, interval){
            final /* synthetic */ TextView $textView;
            final /* synthetic */ String $hint;
            final /* synthetic */ long $waitTime;
            final /* synthetic */ long $interval;

            @SuppressLint(value={"DefaultLocale"})
            public void onTick(long millisUntilFinished) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string2 = "\u5269\u4e0b %d S";
                Object[] objectArray = new Object[]{millisUntilFinished / (long)1000};
                TextView textView = this.$textView;
                boolean bl = false;
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
                String string4 = string3;
                textView.setText((CharSequence)string4);
            }

            public void onFinish() {
                this.$textView.setEnabled(true);
                this.$textView.setText((CharSequence)this.$hint);
            }
            {
                this.$textView = $captured_local_variable$0;
                this.$hint = $captured_local_variable$1;
                this.$waitTime = $captured_local_variable$2;
                this.$interval = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5);
            }
        };
        timer2.start();
    }

    @JvmStatic
    public static final void fixListViewHeight(@NotNull ListView listView) {
        Intrinsics.checkParameterIsNotNull((Object)listView, (String)"listView");
        ListAdapter listAdapter = listView.getAdapter();
        int totalHeight = 0;
        if (listAdapter == null) {
            return;
        }
        int len = listAdapter.getCount();
        for (int index = 0; index < len; ++index) {
            View listViewItem = listAdapter.getView(index, null, (ViewGroup)listView);
            listViewItem.measure(0, 0);
            View view = listViewItem;
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"listViewItem");
            totalHeight += view.getMeasuredHeight();
        }
        ViewGroup.LayoutParams params = listView.getLayoutParams();
        params.height = totalHeight + listView.getDividerHeight() * (listAdapter.getCount() - 1);
        listView.setLayoutParams(params);
    }

    @JvmStatic
    @NotNull
    public static final String Md5(@NotNull String MStr) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)MStr, (String)"MStr");
        try {
            MessageDigest mDigest = MessageDigest.getInstance("MD5");
            String string3 = MStr;
            MessageDigest messageDigest = mDigest;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = string3.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            messageDigest.update(byArray2);
            byte[] byArray3 = mDigest.digest();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"mDigest.digest()");
            string2 = INSTANCE.bytesToHexString(byArray3);
        }
        catch (NoSuchAlgorithmException e) {
            string2 = String.valueOf(MStr.hashCode());
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        int n = 0;
        int n2 = bytes.length;
        while (n < n2) {
            String hex;
            void i;
            Intrinsics.checkExpressionValueIsNotNull((Object)Integer.toHexString(0xFF & bytes[i]), (String)"Integer.toHexString(0xFF and bytes[i].toInt())");
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex);
            ++i;
        }
        String string2 = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sb.toString()");
        return string2;
    }

    @JvmStatic
    public static final int getResIdByName(@NotNull Context context, @Nullable String name, @Nullable String defType) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return context.getResources().getIdentifier(name, defType, context.getPackageName());
    }

    @JvmStatic
    public static final boolean isFastClick(int millisecond) {
        long curClickTime = System.currentTimeMillis();
        long interval = curClickTime - lastClickTime;
        if (0L < interval && interval < (long)millisecond) {
            return true;
        }
        lastClickTime = curClickTime;
        return false;
    }

    @JvmStatic
    public static final void setEdTwoDecimal(@NotNull EditText editText) {
        Intrinsics.checkParameterIsNotNull((Object)editText, (String)"editText");
        RxTool.setEdDecimal(editText, 2);
    }

    @JvmStatic
    public static final void setEdType(@NotNull EditText editText) {
        Intrinsics.checkParameterIsNotNull((Object)editText, (String)"editText");
        editText.addTextChangedListener(new TextWatcher(editText){
            final /* synthetic */ EditText $editText;

            public void beforeTextChanged(@NotNull CharSequence s, int start, int count, int after) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            }

            public void onTextChanged(@NotNull CharSequence s, int start, int before, int count) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                String editable = this.$editText.getText().toString();
                String str = RxTool.stringFilter(editable);
                if (Intrinsics.areEqual((Object)editable, (Object)str) ^ true) {
                    this.$editText.setText((CharSequence)str);
                    this.$editText.setSelection(str.length());
                }
            }

            public void afterTextChanged(@NotNull Editable s) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            }
            {
                this.$editText = $captured_local_variable$0;
            }
        });
    }

    @JvmStatic
    @NotNull
    public static final String stringFilter(@Nullable String str) throws PatternSyntaxException {
        String regEx = "[^0-9\u4e00-\u9fa5]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        String string2 = m.replaceAll("");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"m.replaceAll(\"\")");
        String $this$trim$iv = string2;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = it <= ' ';
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
    }

    @JvmStatic
    public static final void setEdDecimal(@NotNull EditText editText, int count) {
        Intrinsics.checkParameterIsNotNull((Object)editText, (String)"editText");
        int count2 = count;
        if (count2 < 0) {
            count2 = 0;
        }
        editText.setInputType(8194);
        int finalCount = ++count2;
        editText.setFilters(new InputFilter[]{new InputFilter(finalCount){
            final /* synthetic */ int $finalCount;

            public final CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
                String string2 = ".";
                CharSequence charSequence = source;
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"source");
                CharSequence charSequence2 = charSequence;
                boolean bl = false;
                if (string2.contentEquals(charSequence2) && dest.toString().length() == 0) {
                    return "0.";
                }
                if (StringsKt.contains$default((CharSequence)dest.toString(), (CharSequence)".", (boolean)false, (int)2, null)) {
                    int index = StringsKt.indexOf$default((CharSequence)dest.toString(), (String)".", (int)0, (boolean)false, (int)6, null);
                    String string3 = dest.toString();
                    boolean bl2 = false;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.substring(index);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                    int mlength = string5.length();
                    if (mlength == this.$finalCount) {
                        return "";
                    }
                }
                return Intrinsics.areEqual((Object)dest.toString(), (Object)"0") && Intrinsics.areEqual((Object)source, (Object)"0") ? (CharSequence)"" : null;
            }
            {
                this.$finalCount = n;
            }
        }});
    }

    @JvmStatic
    public static final void setEditNumberAuto(@NotNull EditText editText, int number, boolean isStartForZero) {
        Intrinsics.checkParameterIsNotNull((Object)editText, (String)"editText");
        editText.setOnFocusChangeListener(new View.OnFocusChangeListener(editText, number, isStartForZero){
            final /* synthetic */ EditText $editText;
            final /* synthetic */ int $number;
            final /* synthetic */ boolean $isStartForZero;

            public final void onFocusChange(View v, boolean hasFocus) {
                if (!hasFocus) {
                    RxTool.setEditNumber(this.$editText, this.$number, this.$isStartForZero);
                }
            }
            {
                this.$editText = editText;
                this.$number = n;
                this.$isStartForZero = bl;
            }
        });
    }

    @JvmStatic
    public static final void setEditNumber(@NotNull EditText editText, int number, boolean isStartForZero) {
        Intrinsics.checkParameterIsNotNull((Object)editText, (String)"editText");
        StringBuilder s = new StringBuilder(editText.getText().toString());
        StringBuilder temp = new StringBuilder();
        int i = 0;
        for (i = s.length(); i < number; ++i) {
            s.insert(0, "0");
        }
        if (!isStartForZero) {
            for (i = 0; i < number; ++i) {
                temp.append("0");
            }
            if (Intrinsics.areEqual((Object)s.toString(), (Object)temp.toString())) {
                s = new StringBuilder(temp.substring(1) + "1");
            }
        }
        editText.setText((CharSequence)s.toString());
    }

    @NotNull
    public final Handler getBackgroundHandler() {
        HandlerThread thread = new HandlerThread("background");
        thread.start();
        return new Handler(thread.getLooper());
    }

    @JvmStatic
    public static final void initFastClickAndVibrate(@Nullable Context mContext, @NotNull OnDoListener onRxSimple) {
        Intrinsics.checkParameterIsNotNull((Object)onRxSimple, (String)"onRxSimple");
        if (RxTool.isFastClick(100)) {
            RxToast.normal("\u8bf7\u4e0d\u8981\u91cd\u590d\u70b9\u51fb");
            return;
        }
        Context context = mContext;
        if (context == null) {
            Intrinsics.throwNpe();
        }
        RxVibrateTool.vibrateOnce(context, 100);
        onRxSimple.doSomething();
    }

    private RxTool() {
    }

    static {
        RxTool rxTool;
        INSTANCE = rxTool = new RxTool();
    }
}

