/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxtool;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.location.Address;
import android.location.Criteria;
import android.location.Geocoder;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Log;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.tamsiree.rxtool.model.Gps;
import com.tamsiree.rxtool.view.RxToast;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Locale;

public class RxLocationTool {
    public static double pi = Math.PI;
    public static double a = 6378245.0;
    public static double ee = 0.006693421622965943;
    private static OnLocationChangeListener mListener;
    private static MyLocationListener myLocationListener;
    private static LocationManager mLocationManager;

    public static boolean isGpsEnabled(Context context) {
        LocationManager lm = (LocationManager)context.getSystemService("location");
        return lm.isProviderEnabled("gps");
    }

    public static boolean isLocationEnabled(Context context) {
        LocationManager lm = (LocationManager)context.getSystemService("location");
        return lm.isProviderEnabled("network") || lm.isProviderEnabled("gps");
    }

    public static void openGpsSettings(Context context) {
        Intent intent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
        intent.setFlags(0x10000000);
        context.startActivity(intent);
    }

    public static boolean registerLocation(Context context, long minTime, long minDistance, OnLocationChangeListener listener) {
        if (listener == null) {
            return false;
        }
        if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            ActivityCompat.requestPermissions((Activity)((Activity)context), (String[])new String[]{"android.permission.ACCESS_FINE_LOCATION"}, (int)1);
            ActivityCompat.requestPermissions((Activity)((Activity)context), (String[])new String[]{"android.permission.ACCESS_COARSE_LOCATION"}, (int)1);
            return false;
        }
        mLocationManager = (LocationManager)context.getSystemService("location");
        mListener = listener;
        if (!RxLocationTool.isLocationEnabled(context)) {
            RxToast.showToast(context, "\u65e0\u6cd5\u5b9a\u4f4d\uff0c\u8bf7\u6253\u5f00\u5b9a\u4f4d\u670d\u52a1", 500);
            return false;
        }
        String provider = mLocationManager.getBestProvider(RxLocationTool.getCriteria(), true);
        Location location = mLocationManager.getLastKnownLocation(provider);
        if (location != null) {
            listener.getLastKnownLocation(location);
        }
        if (myLocationListener == null) {
            myLocationListener = new MyLocationListener();
        }
        mLocationManager.requestLocationUpdates(provider, minTime, (float)minDistance, (LocationListener)myLocationListener);
        return true;
    }

    public static void unRegisterLocation() {
        if (mLocationManager != null) {
            if (myLocationListener != null) {
                mLocationManager.removeUpdates((LocationListener)myLocationListener);
                myLocationListener = null;
            }
            mLocationManager = null;
        }
    }

    private static Criteria getCriteria() {
        Criteria criteria = new Criteria();
        criteria.setAccuracy(1);
        criteria.setSpeedRequired(true);
        criteria.setCostAllowed(true);
        criteria.setBearingRequired(true);
        criteria.setAltitudeRequired(true);
        criteria.setPowerRequirement(1);
        return criteria;
    }

    public static Address getAddress(Context context, double latitude, double longitude) {
        Geocoder geocoder = new Geocoder(context, Locale.getDefault());
        try {
            List addresses = geocoder.getFromLocation(latitude, longitude, 1);
            if (addresses.size() > 0) {
                return (Address)addresses.get(0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getCountryName(Context context, double latitude, double longitude) {
        Address address = RxLocationTool.getAddress(context, latitude, longitude);
        return address == null ? "unknown" : address.getCountryName();
    }

    public static String getLocality(Context context, double latitude, double longitude) {
        Address address = RxLocationTool.getAddress(context, latitude, longitude);
        return address == null ? "unknown" : address.getLocality();
    }

    public static String getStreet(Context context, double latitude, double longitude) {
        Address address = RxLocationTool.getAddress(context, latitude, longitude);
        return address == null ? "unknown" : address.getAddressLine(0);
    }

    public static String gpsToDegree(double location) {
        double degree = Math.floor(location);
        double minute_temp = (location - degree) * 60.0;
        double minute = Math.floor(minute_temp);
        String second = new DecimalFormat("#.##").format((minute_temp - minute) * 60.0);
        return (int)degree + "\u00b0" + (int)minute + "\u2032" + second + "\u2033";
    }

    public static Gps GPS84ToGCJ02(double lon, double lat) {
        if (RxLocationTool.outOfChina(lon, lat)) {
            return null;
        }
        double dLat = RxLocationTool.transformLat(lon - 105.0, lat - 35.0);
        double dLon = RxLocationTool.transformLon(lon - 105.0, lat - 35.0);
        double radLat = lat / 180.0 * pi;
        double magic = Math.sin(radLat);
        magic = 1.0 - ee * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        dLat = dLat * 180.0 / (a * (1.0 - ee) / (magic * sqrtMagic) * pi);
        dLon = dLon * 180.0 / (a / sqrtMagic * Math.cos(radLat) * pi);
        double mgLat = lat + dLat;
        double mgLon = lon + dLon;
        return new Gps(mgLon, mgLat);
    }

    public static Gps GCJ02ToGPS84(double lon, double lat) {
        Gps gps = RxLocationTool.transform(lon, lat);
        double lontitude = lon * 2.0 - gps.getLongitude();
        double latitude = lat * 2.0 - gps.getLatitude();
        return new Gps(lontitude, latitude);
    }

    public static Gps GCJ02ToBD09(double ggLon, double ggLat) {
        double x = ggLon;
        double y = ggLat;
        double z = Math.sqrt(x * x + y * y) + 2.0E-5 * Math.sin(y * pi);
        double theta = Math.atan2(y, x) + 3.0E-6 * Math.cos(x * pi);
        double bdLon = z * Math.cos(theta) + 0.0065;
        double bdLat = z * Math.sin(theta) + 0.006;
        return new Gps(bdLon, bdLat);
    }

    public static Gps BD09ToGCJ02(double bdLon, double bdLat) {
        double x = bdLon - 0.0065;
        double y = bdLat - 0.006;
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * pi);
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * pi);
        double ggLon = z * Math.cos(theta);
        double ggLat = z * Math.sin(theta);
        return new Gps(ggLon, ggLat);
    }

    public static Gps BD09ToGPS84(double bdLon, double bdLat) {
        Gps gcj02 = RxLocationTool.BD09ToGCJ02(bdLon, bdLat);
        Gps map84 = RxLocationTool.GCJ02ToGPS84(gcj02.getLongitude(), gcj02.getLatitude());
        return map84;
    }

    public static Gps GPS84ToBD09(double gpsLon, double gpsLat) {
        Gps gcj02 = RxLocationTool.GPS84ToGCJ02(gpsLon, gpsLat);
        Gps bd09 = RxLocationTool.GCJ02ToBD09(gcj02.getLongitude(), gcj02.getLatitude());
        return bd09;
    }

    public static boolean outOfChina(double lon, double lat) {
        return lon < 72.004 || lon > 137.8347 || lat < 0.8293 || lat > 55.8271;
    }

    private static Gps transform(double lon, double lat) {
        if (RxLocationTool.outOfChina(lon, lat)) {
            return new Gps(lon, lat);
        }
        double dLat = RxLocationTool.transformLat(lon - 105.0, lat - 35.0);
        double dLon = RxLocationTool.transformLon(lon - 105.0, lat - 35.0);
        double radLat = lat / 180.0 * pi;
        double magic = Math.sin(radLat);
        magic = 1.0 - ee * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        dLat = dLat * 180.0 / (a * (1.0 - ee) / (magic * sqrtMagic) * pi);
        dLon = dLon * 180.0 / (a / sqrtMagic * Math.cos(radLat) * pi);
        double mgLat = lat + dLat;
        double mgLon = lon + dLon;
        return new Gps(mgLon, mgLat);
    }

    private static double transformLat(double x, double y) {
        double ret = -100.0 + 2.0 * x + 3.0 * y + 0.2 * y * y + 0.1 * x * y + 0.2 * Math.sqrt(Math.abs(x));
        ret += (20.0 * Math.sin(6.0 * x * pi) + 20.0 * Math.sin(2.0 * x * pi)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(y * pi) + 40.0 * Math.sin(y / 3.0 * pi)) * 2.0 / 3.0;
        return ret += (160.0 * Math.sin(y / 12.0 * pi) + 320.0 * Math.sin(y * pi / 30.0)) * 2.0 / 3.0;
    }

    private static double transformLon(double x, double y) {
        double ret = 300.0 + x + 2.0 * y + 0.1 * x * x + 0.1 * x * y + 0.1 * Math.sqrt(Math.abs(x));
        ret += (20.0 * Math.sin(6.0 * x * pi) + 20.0 * Math.sin(2.0 * x * pi)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(x * pi) + 40.0 * Math.sin(x / 3.0 * pi)) * 2.0 / 3.0;
        return ret += (150.0 * Math.sin(x / 12.0 * pi) + 300.0 * Math.sin(x / 30.0 * pi)) * 2.0 / 3.0;
    }

    public static boolean isMove(Location location, Location preLocation) {
        boolean isMove;
        if (preLocation != null) {
            double speed = (double)location.getSpeed() * 3.6;
            double distance = location.distanceTo(preLocation);
            double compass = Math.abs(preLocation.getBearing() - location.getBearing());
            double angle = compass > 180.0 ? 360.0 - compass : compass;
            isMove = speed != 0.0 ? (speed < 35.0 && distance > 3.0 && distance < 10.0 ? angle > 10.0 : speed < 40.0 && distance > 10.0 && distance < 100.0 || speed < 50.0 && distance > 10.0 && distance < 100.0 || speed < 60.0 && distance > 10.0 && distance < 100.0 || speed < 9999.0 && distance > 100.0) : false;
        } else {
            isMove = true;
        }
        return isMove;
    }

    private static class MyLocationListener
    implements LocationListener {
        private MyLocationListener() {
        }

        public void onLocationChanged(Location location) {
            if (mListener != null) {
                mListener.onLocationChanged(location);
            }
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
            if (mListener != null) {
                mListener.onStatusChanged(provider, status, extras);
            }
            switch (status) {
                case 2: {
                    Log.d((String)"onStatusChanged", (String)"\u5f53\u524dGPS\u72b6\u6001\u4e3a\u53ef\u89c1\u72b6\u6001");
                    break;
                }
                case 0: {
                    Log.d((String)"onStatusChanged", (String)"\u5f53\u524dGPS\u72b6\u6001\u4e3a\u670d\u52a1\u533a\u5916\u72b6\u6001");
                    break;
                }
                case 1: {
                    Log.d((String)"onStatusChanged", (String)"\u5f53\u524dGPS\u72b6\u6001\u4e3a\u6682\u505c\u670d\u52a1\u72b6\u6001");
                    break;
                }
            }
        }

        public void onProviderEnabled(String provider) {
        }

        public void onProviderDisabled(String provider) {
        }
    }

    public static interface OnLocationChangeListener {
        public void getLastKnownLocation(Location var1);

        public void onLocationChanged(Location var1);

        public void onStatusChanged(String var1, int var2, Bundle var3);
    }
}

