/*
 * Decompiled with CFR 0.152.
 */
package com.vondear.rxtool;

import com.vondear.rxtool.RxDataTool;
import com.vondear.rxtool.RxEncodeTool;
import com.vondear.rxtool.RxFileTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class RxEncryptTool {
    private static final String DES_Algorithm = "DES";
    private static final String TripleDES_Algorithm = "DESede";
    private static final String AES_Algorithm = "AES";
    public static String DES_Transformation = "DES/ECB/NoPadding";
    public static String TripleDES_Transformation = "DESede/ECB/NoPadding";
    public static String AES_Transformation = "AES/ECB/NoPadding";

    public static String encryptMD2ToString(String data) {
        return RxEncryptTool.encryptMD2ToString(data.getBytes());
    }

    public static String encryptMD2ToString(byte[] data) {
        return RxDataTool.bytes2HexString(RxEncryptTool.encryptMD2(data));
    }

    public static byte[] encryptMD2(byte[] data) {
        return RxEncryptTool.encryptAlgorithm(data, "MD2");
    }

    public static String encryptMD5ToString(String data) {
        return RxEncryptTool.encryptMD5ToString(data.getBytes());
    }

    public static String encryptMD5ToString(String data, String salt) {
        return RxDataTool.bytes2HexString(RxEncryptTool.encryptMD5((data + salt).getBytes()));
    }

    public static String encryptMD5ToString(byte[] data) {
        return RxDataTool.bytes2HexString(RxEncryptTool.encryptMD5(data));
    }

    public static String encryptMD5ToString(byte[] data, byte[] salt) {
        byte[] dataSalt = new byte[data.length + salt.length];
        System.arraycopy(data, 0, dataSalt, 0, data.length);
        System.arraycopy(salt, 0, dataSalt, data.length, salt.length);
        return RxDataTool.bytes2HexString(RxEncryptTool.encryptMD5(dataSalt));
    }

    public static byte[] encryptMD5(byte[] data) {
        return RxEncryptTool.encryptAlgorithm(data, "MD5");
    }

    public static String encryptMD5File2String(String filePath) {
        return RxEncryptTool.encryptMD5File2String(new File(filePath));
    }

    public static byte[] encryptMD5File(String filePath) {
        return RxEncryptTool.encryptMD5File(new File(filePath));
    }

    public static String encryptMD5File2String(File file) {
        return RxEncryptTool.encryptMD5File(file) != null ? RxDataTool.bytes2HexString(RxEncryptTool.encryptMD5File(file)) : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] encryptMD5File(File file) {
        byte[] byArray;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            FileChannel channel = fis.getChannel();
            MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(buffer);
            byArray = md.digest();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                RxFileTool.closeIO(fis);
                throw throwable;
            }
            RxFileTool.closeIO(fis);
            return null;
        }
        RxFileTool.closeIO(fis);
        return byArray;
    }

    public static String encryptSHA1ToString(String data) {
        return RxEncryptTool.encryptSHA1ToString(data.getBytes());
    }

    public static String encryptSHA1ToString(byte[] data) {
        return RxDataTool.bytes2HexString(RxEncryptTool.encryptSHA1(data));
    }

    public static byte[] encryptSHA1(byte[] data) {
        return RxEncryptTool.encryptAlgorithm(data, "SHA-1");
    }

    public static String encryptSHA224ToString(String data) {
        return RxEncryptTool.encryptSHA224ToString(data.getBytes());
    }

    public static String encryptSHA224ToString(byte[] data) {
        return RxDataTool.bytes2HexString(RxEncryptTool.encryptSHA224(data));
    }

    public static byte[] encryptSHA224(byte[] data) {
        return RxEncryptTool.encryptAlgorithm(data, "SHA-224");
    }

    public static String encryptSHA256ToString(String data) {
        return RxEncryptTool.encryptSHA256ToString(data.getBytes());
    }

    public static String encryptSHA256ToString(byte[] data) {
        return RxDataTool.bytes2HexString(RxEncryptTool.encryptSHA256(data));
    }

    public static byte[] encryptSHA256(byte[] data) {
        return RxEncryptTool.encryptAlgorithm(data, "SHA-256");
    }

    public static String encryptSHA384ToString(String data) {
        return RxEncryptTool.encryptSHA384ToString(data.getBytes());
    }

    public static String encryptSHA384ToString(byte[] data) {
        return RxDataTool.bytes2HexString(RxEncryptTool.encryptSHA384(data));
    }

    public static byte[] encryptSHA384(byte[] data) {
        return RxEncryptTool.encryptAlgorithm(data, "SHA-384");
    }

    public static String encryptSHA512ToString(String data) {
        return RxEncryptTool.encryptSHA512ToString(data.getBytes());
    }

    public static String encryptSHA512ToString(byte[] data) {
        return RxDataTool.bytes2HexString(RxEncryptTool.encryptSHA512(data));
    }

    public static byte[] encryptSHA512(byte[] data) {
        return RxEncryptTool.encryptAlgorithm(data, "SHA-512");
    }

    private static byte[] encryptAlgorithm(byte[] data, String algorithm) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(data);
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public static byte[] DESTemplet(byte[] data, byte[] key, String algorithm, String transformation, boolean isEncrypt) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key, algorithm);
            Cipher cipher = Cipher.getInstance(transformation);
            SecureRandom random = new SecureRandom();
            cipher.init(isEncrypt ? 1 : 2, (Key)keySpec, random);
            return cipher.doFinal(data);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] encryptDES2Base64(byte[] data, byte[] key) {
        return RxEncodeTool.base64Encode(RxEncryptTool.encryptDES(data, key));
    }

    public static String encryptDES2HexString(byte[] data, byte[] key) {
        return RxDataTool.bytes2HexString(RxEncryptTool.encryptDES(data, key));
    }

    public static byte[] encryptDES(byte[] data, byte[] key) {
        return RxEncryptTool.DESTemplet(data, key, DES_Algorithm, DES_Transformation, true);
    }

    public static byte[] decryptBase64DES(byte[] data, byte[] key) {
        return RxEncryptTool.decryptDES(RxEncodeTool.base64Decode(data), key);
    }

    public static byte[] decryptHexStringDES(String data, byte[] key) {
        return RxEncryptTool.decryptDES(RxDataTool.hexString2Bytes(data), key);
    }

    public static byte[] decryptDES(byte[] data, byte[] key) {
        return RxEncryptTool.DESTemplet(data, key, DES_Algorithm, DES_Transformation, false);
    }

    public static byte[] encrypt3DES2Base64(byte[] data, byte[] key) {
        return RxEncodeTool.base64Encode(RxEncryptTool.encrypt3DES(data, key));
    }

    public static String encrypt3DES2HexString(byte[] data, byte[] key) {
        return RxDataTool.bytes2HexString(RxEncryptTool.encrypt3DES(data, key));
    }

    public static byte[] encrypt3DES(byte[] data, byte[] key) {
        return RxEncryptTool.DESTemplet(data, key, TripleDES_Algorithm, TripleDES_Transformation, true);
    }

    public static byte[] decryptBase64_3DES(byte[] data, byte[] key) {
        return RxEncryptTool.decrypt3DES(RxEncodeTool.base64Decode(data), key);
    }

    public static byte[] decryptHexString3DES(String data, byte[] key) {
        return RxEncryptTool.decrypt3DES(RxDataTool.hexString2Bytes(data), key);
    }

    public static byte[] decrypt3DES(byte[] data, byte[] key) {
        return RxEncryptTool.DESTemplet(data, key, TripleDES_Algorithm, TripleDES_Transformation, false);
    }

    public static byte[] encryptAES2Base64(byte[] data, byte[] key) {
        return RxEncodeTool.base64Encode(RxEncryptTool.encryptAES(data, key));
    }

    public static String encryptAES2HexString(byte[] data, byte[] key) {
        return RxDataTool.bytes2HexString(RxEncryptTool.encryptAES(data, key));
    }

    public static byte[] encryptAES(byte[] data, byte[] key) {
        return RxEncryptTool.DESTemplet(data, key, AES_Algorithm, AES_Transformation, true);
    }

    public static byte[] decryptBase64AES(byte[] data, byte[] key) {
        return RxEncryptTool.decryptAES(RxEncodeTool.base64Decode(data), key);
    }

    public static byte[] decryptHexStringAES(String data, byte[] key) {
        return RxEncryptTool.decryptAES(RxDataTool.hexString2Bytes(data), key);
    }

    public static byte[] decryptAES(byte[] data, byte[] key) {
        return RxEncryptTool.DESTemplet(data, key, AES_Algorithm, AES_Transformation, false);
    }
}

