/*
 * Decompiled with CFR 0.152.
 */
package com.vondear.rxtool;

import android.content.Context;
import android.hardware.Camera;
import android.util.Log;
import com.google.android.cameraview.CameraView;
import com.vondear.rxtool.RxExifTool;
import com.vondear.rxtool.RxFileTool;
import com.vondear.rxtool.RxTool;
import com.vondear.rxtool.RxVibrateTool;
import com.vondear.rxtool.interfaces.OnRxCamera;
import com.vondear.rxtool.interfaces.OnSimpleListener;
import com.vondear.rxtool.module.photomagic.OnCompressListener;
import com.vondear.rxtool.module.photomagic.RxMagic;
import com.vondear.rxtool.view.RxToast;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RxCameraTool {
    private static Camera camera;

    public static void openFlashLight() {
        try {
            if (camera == null) {
                camera = Camera.open();
                camera.startPreview();
            }
            Camera.Parameters parameters = camera.getParameters();
            parameters.setFlashMode("torch");
            camera.setParameters(parameters);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void closeFlashLight() {
        try {
            if (camera != null) {
                Camera.Parameters parameters = camera.getParameters();
                parameters.setFlashMode("off");
                camera.setParameters(parameters);
                camera.release();
                camera = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void takePic(Context mContext, final CameraView mCameraView) {
        if (RxTool.isFastClick(1000)) {
            RxToast.normal("\u8bf7\u4e0d\u8981\u91cd\u590d\u70b9\u51fb\u62cd\u7167\u6309\u94ae");
            return;
        }
        try {
            if (mCameraView.isCameraOpened()) {
                RxVibrateTool.vibrateOnce(mContext, 150);
                RxToast.normal("\u6b63\u5728\u62cd\u7167..");
                if (mCameraView != null) {
                    mCameraView.takePicture();
                }
            } else {
                mCameraView.start();
                RxVibrateTool.vibrateOnce(mContext, 150);
                RxToast.normal("\u6b63\u5728\u62cd\u7167..");
                RxTool.delayToDo(500L, new OnSimpleListener(){

                    @Override
                    public void doSomething() {
                        try {
                            if (mCameraView != null) {
                                mCameraView.takePicture();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void initCameraEvent(final Context mContext, final CameraView mCameraView, final byte[] data, final String fileDir, final String picName, final double mLongitude, final double mLatitude, final boolean isEconomize, final OnRxCamera OnRxCamera2) {
        OnRxCamera2.onBefore();
        RxTool.getBackgroundHandler().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                File fileParent = new File(fileDir);
                File cacheParent = new File(RxFileTool.getCecheFolder(mContext) + File.separator + "cache" + File.separator + "picture");
                if (!cacheParent.exists()) {
                    cacheParent.mkdirs();
                }
                if (!fileParent.exists()) {
                    fileParent.mkdirs();
                }
                File cachefile = new File(cacheParent, picName);
                final File compressFile = new File(fileParent, picName);
                FileOutputStream os = null;
                try {
                    os = new FileOutputStream(cachefile);
                    ((OutputStream)os).write(data);
                    ((OutputStream)os).close();
                    RxMagic.with(mContext).load(cachefile).setCompressListener(new OnCompressListener(){

                        @Override
                        public void onStart() {
                            Log.d((String)"\u56fe\u7247\u538b\u7f29", (String)"\u5f00\u59cb\u538b\u7f29");
                        }

                        @Override
                        public void onSuccess(File file) {
                            if (RxFileTool.copyOrMoveFile(file, compressFile, true)) {
                                Log.d((String)"\u56fe\u7247\u538b\u7f29", (String)"\u538b\u7f29\u5b8c\u6210");
                                OnRxCamera2.onSuccessCompress(compressFile);
                                if (mLongitude != 0.0 || mLatitude != 0.0) {
                                    RxExifTool.writeLatLonIntoJpeg(compressFile.getAbsolutePath(), mLatitude, mLongitude);
                                    OnRxCamera2.onSuccessExif(compressFile);
                                    RxToast.normal("\u62cd\u7167\u6210\u529f");
                                } else {
                                    RxToast.error("\u8bf7\u5148\u83b7\u53d6\u5b9a\u4f4d\u4fe1\u606f");
                                }
                            }
                        }

                        @Override
                        public void onError(Throwable e) {
                            Log.d((String)"\u56fe\u7247\u538b\u7f29", (String)"\u538b\u7f29\u5f02\u5e38");
                        }
                    }).launch();
                }
                catch (IOException e) {
                    Log.w((String)"onPictureTaken", (String)("Cannot write to " + compressFile), (Throwable)e);
                }
                finally {
                    if (isEconomize) {
                        mCameraView.stop();
                    }
                    if (os != null) {
                        try {
                            ((OutputStream)os).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        });
    }
}

