/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.tamsiree.rxkit.RxLocationTool;
import com.tamsiree.rxkit.RxPackageManagerTool;
import com.tamsiree.rxkit.model.Gps;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J \u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J(\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J(\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J \u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\u0017"}, d2={"Lcom/tamsiree/rxkit/RxMapTool;", "", "()V", "metreToScreenPixel", "", "distance", "currScale", "context", "Landroid/content/Context;", "openBaiduMapToGuide", "", "mContext", "gps", "Lcom/tamsiree/rxkit/model/Gps;", "storeName", "", "openBrowserToGuide", "gpsFrom", "openGaodeMapToGuide", "gpsTo", "openMap", "screenPixelToMetre", "pxlength", "RxKit_release"})
public final class RxMapTool {
    @NotNull
    public static final RxMapTool INSTANCE = new RxMapTool();

    private RxMapTool() {
    }

    @JvmStatic
    public static final void openMap(@NotNull Context mContext, @NotNull Gps gpsFrom, @NotNull Gps gpsTo, @NotNull String storeName) {
        Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
        Intrinsics.checkNotNullParameter((Object)gpsFrom, (String)"gpsFrom");
        Intrinsics.checkNotNullParameter((Object)gpsTo, (String)"gpsTo");
        Intrinsics.checkNotNullParameter((Object)storeName, (String)"storeName");
        if (RxPackageManagerTool.haveExistPackageName(mContext, "com.autonavi.minimap")) {
            RxMapTool.openGaodeMapToGuide(mContext, gpsFrom, gpsTo, storeName);
        } else if (RxPackageManagerTool.haveExistPackageName(mContext, "com.baidu.BaiduMap")) {
            RxMapTool.openBaiduMapToGuide(mContext, gpsTo, storeName);
        } else {
            RxMapTool.openBrowserToGuide(mContext, gpsTo, storeName);
        }
    }

    @JvmStatic
    public static final void openGaodeMapToGuide(@NotNull Context mContext, @NotNull Gps gpsFrom, @NotNull Gps gpsTo, @NotNull String storeName) {
        Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
        Intrinsics.checkNotNullParameter((Object)gpsFrom, (String)"gpsFrom");
        Intrinsics.checkNotNullParameter((Object)gpsTo, (String)"gpsTo");
        Intrinsics.checkNotNullParameter((Object)storeName, (String)"storeName");
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        Gps gps = RxLocationTool.GPS84ToGCJ02(gpsFrom.getLongitude(), gpsFrom.getLatitude());
        Gps gps1 = RxLocationTool.GPS84ToGCJ02(gpsTo.getLongitude(), gpsTo.getLatitude());
        StringBuilder stringBuilder = new StringBuilder().append("androidamap://route?sourceApplication=amap&slat=");
        Intrinsics.checkNotNull((Object)gps);
        StringBuilder stringBuilder2 = stringBuilder.append(gps.getLatitude()).append("&slon=").append(gps.getLongitude()).append("&dlat=");
        Intrinsics.checkNotNull((Object)gps1);
        String url = stringBuilder2.append(gps1.getLatitude()).append("&dlon=").append(gps1.getLongitude()).append("&dname=").append(storeName).append("&dev=0&t=0").toString();
        Uri uri = Uri.parse((String)url);
        intent.setData(uri);
        mContext.startActivity(intent);
    }

    @JvmStatic
    public static final void openBaiduMapToGuide(@NotNull Context mContext, @NotNull Gps gps, @NotNull String storeName) {
        Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
        Intrinsics.checkNotNullParameter((Object)gps, (String)"gps");
        Intrinsics.checkNotNullParameter((Object)storeName, (String)"storeName");
        Intent intent = new Intent();
        Gps gps1 = RxLocationTool.GPS84ToGCJ02(gps.getLongitude(), gps.getLatitude());
        Intrinsics.checkNotNull((Object)gps1);
        Gps gps2 = RxLocationTool.GCJ02ToBD09(gps1.getLongitude(), gps1.getLatitude());
        String url = "baidumap://map/direction?destination=name:" + storeName + "|latlng:" + gps2.getLatitude() + ',' + gps2.getLongitude() + "&mode=driving&sy=3&index=0&target=1";
        Uri uri = Uri.parse((String)url);
        intent.setData(uri);
        mContext.startActivity(intent);
    }

    @JvmStatic
    public static final void openBrowserToGuide(@NotNull Context mContext, @NotNull Gps gpsFrom, @NotNull String storeName) {
        Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
        Intrinsics.checkNotNullParameter((Object)gpsFrom, (String)"gpsFrom");
        Intrinsics.checkNotNullParameter((Object)storeName, (String)"storeName");
        Gps gps = RxLocationTool.GPS84ToGCJ02(gpsFrom.getLongitude(), gpsFrom.getLatitude());
        StringBuilder stringBuilder = new StringBuilder().append("http://uri.amap.com/navigation?to=");
        Intrinsics.checkNotNull((Object)gps);
        String url = stringBuilder.append(gps.getLatitude()).append(',').append(gps.getLongitude()).append(',').append(storeName).append("&mode=car&policy=1&src=mypage&coordinate=gaode&callnative=0").toString();
        Uri uri = Uri.parse((String)url);
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        mContext.startActivity(intent);
    }

    @JvmStatic
    public static final double metreToScreenPixel(double distance, double currScale, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        float dpi = context.getResources().getDisplayMetrics().densityDpi;
        double resolution = 25.39999918 / (double)dpi * currScale / (double)1000;
        return distance / resolution;
    }

    @JvmStatic
    public static final double screenPixelToMetre(double pxlength, double currScale, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        float dpi = context.getResources().getDisplayMetrics().densityDpi;
        double resolution = 25.39999918 / (double)dpi * currScale / (double)1000;
        return pxlength * resolution;
    }
}

