/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit.demodata;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CSVFileGenerator {
    private static final String LINE_SEPERATOR = System.getProperty("line.separator");
    private static final Charset charset = StandardCharsets.UTF_8;

    public static void generate(List<HashMap<String, Object>> data, String[] columns, String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            file.delete();
        }
        for (Map map : data) {
            ArrayList result = Lists.newArrayList();
            for (String column : columns) {
                if (map.get(column) != null) {
                    result.add(map.get(column).toString());
                    continue;
                }
                result.add("");
            }
            String lineData = Joiner.on((String)",").skipNulls().join((Iterable)result);
            try {
                Files.append((CharSequence)(lineData + LINE_SEPERATOR), (File)file, (Charset)charset);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

