/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.tamsiree.rxkit.RxLocationTool;
import com.tamsiree.rxkit.RxPackageManagerTool;
import com.tamsiree.rxkit.model.Gps;

public class RxMapTool {
    public static void openMap(Context mContext, Gps gpsFrom, Gps gpsTo, String storeName) {
        if (RxPackageManagerTool.haveExistPackageName(mContext, "com.autonavi.minimap")) {
            RxMapTool.openGaodeMapToGuide(mContext, gpsFrom, gpsTo, storeName);
        } else if (RxPackageManagerTool.haveExistPackageName(mContext, "com.baidu.BaiduMap")) {
            RxMapTool.openBaiduMapToGuide(mContext, gpsTo, storeName);
        } else {
            RxMapTool.openBrowserToGuide(mContext, gpsTo, storeName);
        }
    }

    public static void openGaodeMapToGuide(Context mContext, Gps gpsFrom, Gps gpsTo, String storeName) {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        Gps gps = RxLocationTool.GPS84ToGCJ02(gpsFrom.getLongitude(), gpsFrom.getLatitude());
        Gps gps1 = RxLocationTool.GPS84ToGCJ02(gpsTo.getLongitude(), gpsTo.getLatitude());
        String url = "androidamap://route?sourceApplication=amap&slat=" + gps.getLatitude() + "&slon=" + gps.getLongitude() + "&dlat=" + gps1.getLatitude() + "&dlon=" + gps1.getLongitude() + "&dname=" + storeName + "&dev=0&t=0";
        Uri uri = Uri.parse((String)url);
        intent.setData(uri);
        mContext.startActivity(intent);
    }

    public static void openBaiduMapToGuide(Context mContext, Gps gps, String storeName) {
        Intent intent = new Intent();
        Gps gps1 = RxLocationTool.GPS84ToGCJ02(gps.getLongitude(), gps.getLatitude());
        Gps gps2 = RxLocationTool.GCJ02ToBD09(gps1.getLongitude(), gps1.getLatitude());
        String url = "baidumap://map/direction?destination=name:" + storeName + "|latlng:" + gps2.getLatitude() + "," + gps2.getLongitude() + "&mode=driving&sy=3&index=0&target=1";
        Uri uri = Uri.parse((String)url);
        intent.setData(uri);
        mContext.startActivity(intent);
    }

    public static void openBrowserToGuide(Context mContext, Gps gpsFrom, String storeName) {
        Gps gps = RxLocationTool.GPS84ToGCJ02(gpsFrom.getLongitude(), gpsFrom.getLatitude());
        String url = "http://uri.amap.com/navigation?to=" + gps.getLatitude() + "," + gps.getLongitude() + "," + storeName + "&mode=car&policy=1&src=mypage&coordinate=gaode&callnative=0";
        Uri uri = Uri.parse((String)url);
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        mContext.startActivity(intent);
    }

    public static double metreToScreenPixel(double distance, double currScale, Context context) {
        float dpi = context.getResources().getDisplayMetrics().densityDpi;
        double resolution = 25.39999918 / (double)dpi * currScale / 1000.0;
        return distance / resolution;
    }

    public static double screenPixelToMetre(double pxlength, double currScale, Context context) {
        float dpi = context.getResources().getDisplayMetrics().densityDpi;
        double resolution = 25.39999918 / (double)dpi * currScale / 1000.0;
        return pxlength * resolution;
    }
}

