/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxkit;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import java.util.ArrayList;
import java.util.List;

public class RxPermissionsTool {
    public static Builder with(Activity activity) {
        return new Builder(activity);
    }

    public static class Builder {
        private Activity mActivity;
        private List<String> permissionList;

        public Builder(@NonNull Activity activity) {
            this.mActivity = activity;
            this.permissionList = new ArrayList<String>();
        }

        public Builder addPermission(@NonNull String permission2) {
            if (!this.permissionList.contains(permission2)) {
                this.permissionList.add(permission2);
            }
            return this;
        }

        public List<String> initPermission() {
            ArrayList<String> list = new ArrayList<String>();
            for (String permission2 : this.permissionList) {
                if (ActivityCompat.checkSelfPermission((Context)this.mActivity, (String)permission2) == 0) continue;
                list.add(permission2);
            }
            if (list.size() > 0) {
                ActivityCompat.requestPermissions((Activity)this.mActivity, (String[])list.toArray(new String[list.size()]), (int)1);
            }
            return list;
        }
    }
}

