/*
 * Decompiled with CFR 0.152.
 */
package com.tamsiree.rxtool;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import com.tamsiree.rxtool.RxDataTool;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RxProcessTool {
    public static String getForegroundProcessName(Context context) {
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        List infos = manager.getRunningAppProcesses();
        if (infos != null && infos.size() != 0) {
            for (ActivityManager.RunningAppProcessInfo info : infos) {
                if (info.importance != 100) continue;
                return info.processName;
            }
        }
        if (Build.VERSION.SDK_INT > 21) {
            PackageManager packageManager = context.getPackageManager();
            Intent intent = new Intent("android.settings.USAGE_ACCESS_SETTINGS");
            List list = packageManager.queryIntentActivities(intent, 65536);
            System.out.println(list);
            if (list.size() > 0) {
                try {
                    long endTime;
                    long beginTime;
                    ApplicationInfo info = packageManager.getApplicationInfo(context.getPackageName(), 0);
                    AppOpsManager aom = (AppOpsManager)context.getSystemService("appops");
                    if (aom.checkOpNoThrow("android:get_usage_stats", info.uid, info.packageName) != 0) {
                        context.startActivity(intent);
                    }
                    if (aom.checkOpNoThrow("android:get_usage_stats", info.uid, info.packageName) != 0) {
                        Log.d((String)"getForegroundApp", (String)"\u6ca1\u6709\u6253\u5f00\"\u6709\u6743\u67e5\u770b\u4f7f\u7528\u6743\u9650\u7684\u5e94\u7528\"\u9009\u9879");
                        return null;
                    }
                    UsageStatsManager usageStatsManager = (UsageStatsManager)context.getSystemService("usagestats");
                    List usageStatses = usageStatsManager.queryUsageStats(4, beginTime = (endTime = System.currentTimeMillis()) - 604800000L, endTime);
                    if (usageStatses == null || usageStatses.isEmpty()) {
                        return null;
                    }
                    UsageStats recentStats = null;
                    for (UsageStats usageStats : usageStatses) {
                        if (recentStats != null && usageStats.getLastTimeUsed() <= recentStats.getLastTimeUsed()) continue;
                        recentStats = usageStats;
                    }
                    return recentStats == null ? null : recentStats.getPackageName();
                }
                catch (PackageManager.NameNotFoundException e) {
                    e.printStackTrace();
                }
            } else {
                Log.d((String)"getForegroundApp", (String)"\u65e0\"\u6709\u6743\u67e5\u770b\u4f7f\u7528\u6743\u9650\u7684\u5e94\u7528\"\u9009\u9879");
            }
        }
        return null;
    }

    public static Set<String> getAllBackgroundProcesses(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List infos = am.getRunningAppProcesses();
        HashSet<String> set = new HashSet<String>();
        for (ActivityManager.RunningAppProcessInfo info : infos) {
            Collections.addAll(set, info.pkgList);
        }
        return set;
    }

    public static Set<String> killAllBackgroundProcesses(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List infos = am.getRunningAppProcesses();
        HashSet<String> set = new HashSet<String>();
        for (ActivityManager.RunningAppProcessInfo info : infos) {
            for (String pkg : info.pkgList) {
                am.killBackgroundProcesses(pkg);
                set.add(pkg);
            }
        }
        infos = am.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo info : infos) {
            for (String pkg : info.pkgList) {
                set.remove(pkg);
            }
        }
        return set;
    }

    public static boolean killBackgroundProcesses(Context context, String packageName) {
        if (RxDataTool.isNullString(packageName)) {
            return false;
        }
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List infos = am.getRunningAppProcesses();
        if (infos == null || infos.size() == 0) {
            return true;
        }
        for (ActivityManager.RunningAppProcessInfo info : infos) {
            if (!Arrays.asList(info.pkgList).contains(packageName)) continue;
            am.killBackgroundProcesses(packageName);
        }
        infos = am.getRunningAppProcesses();
        if (infos == null || infos.size() == 0) {
            return true;
        }
        for (ActivityManager.RunningAppProcessInfo info : infos) {
            if (!Arrays.asList(info.pkgList).contains(packageName)) continue;
            return false;
        }
        return true;
    }
}

