/*
 * Decompiled with CFR 0.152.
 */
package com.vondear.rxtool.service;

import android.app.Service;
import android.content.Intent;
import android.location.Location;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Looper;
import androidx.annotation.Nullable;
import com.vondear.rxtool.RxLocationTool;
import com.vondear.rxtool.view.RxToast;

public class RxServiceLocation
extends Service {
    private boolean isSuccess;
    private String lastLatitude = "loading...";
    private String lastLongitude = "loading...";
    private String latitude = "loading...";
    private String longitude = "loading...";
    private String country = "loading...";
    private String locality = "loading...";
    private String street = "loading...";
    private OnGetLocationListener mOnGetLocationListener;
    private RxLocationTool.OnLocationChangeListener mOnLocationChangeListener = new RxLocationTool.OnLocationChangeListener(){

        @Override
        public void getLastKnownLocation(Location location) {
            RxServiceLocation.this.lastLatitude = String.valueOf(location.getLatitude());
            RxServiceLocation.this.lastLongitude = String.valueOf(location.getLongitude());
            if (RxServiceLocation.this.mOnGetLocationListener != null) {
                RxServiceLocation.this.mOnGetLocationListener.getLocation(RxServiceLocation.this.lastLatitude, RxServiceLocation.this.lastLongitude, RxServiceLocation.this.latitude, RxServiceLocation.this.longitude, RxServiceLocation.this.country, RxServiceLocation.this.locality, RxServiceLocation.this.street);
            }
        }

        @Override
        public void onLocationChanged(Location location) {
            RxServiceLocation.this.latitude = String.valueOf(location.getLatitude());
            RxServiceLocation.this.longitude = String.valueOf(location.getLongitude());
            if (RxServiceLocation.this.mOnGetLocationListener != null) {
                RxServiceLocation.this.mOnGetLocationListener.getLocation(RxServiceLocation.this.lastLatitude, RxServiceLocation.this.lastLongitude, RxServiceLocation.this.latitude, RxServiceLocation.this.longitude, RxServiceLocation.this.country, RxServiceLocation.this.locality, RxServiceLocation.this.street);
            }
            RxServiceLocation.this.country = RxLocationTool.getCountryName(RxServiceLocation.this.getApplicationContext(), Double.parseDouble(RxServiceLocation.this.latitude), Double.parseDouble(RxServiceLocation.this.longitude));
            RxServiceLocation.this.locality = RxLocationTool.getLocality(RxServiceLocation.this.getApplicationContext(), Double.parseDouble(RxServiceLocation.this.latitude), Double.parseDouble(RxServiceLocation.this.longitude));
            RxServiceLocation.this.street = RxLocationTool.getStreet(RxServiceLocation.this.getApplicationContext(), Double.parseDouble(RxServiceLocation.this.latitude), Double.parseDouble(RxServiceLocation.this.longitude));
            if (RxServiceLocation.this.mOnGetLocationListener != null) {
                RxServiceLocation.this.mOnGetLocationListener.getLocation(RxServiceLocation.this.lastLatitude, RxServiceLocation.this.lastLongitude, RxServiceLocation.this.latitude, RxServiceLocation.this.longitude, RxServiceLocation.this.country, RxServiceLocation.this.locality, RxServiceLocation.this.street);
            }
        }

        @Override
        public void onStatusChanged(String provider, int status, Bundle extras) {
        }
    };

    public void setOnGetLocationListener(OnGetLocationListener onGetLocationListener) {
        this.mOnGetLocationListener = onGetLocationListener;
    }

    public void onCreate() {
        super.onCreate();
        new Thread(new Runnable(){

            @Override
            public void run() {
                Looper.prepare();
                RxServiceLocation.this.isSuccess = RxLocationTool.registerLocation(RxServiceLocation.this.getApplicationContext(), 0L, 0L, RxServiceLocation.this.mOnLocationChangeListener);
                if (RxServiceLocation.this.isSuccess) {
                    RxToast.success("init success");
                }
                Looper.loop();
            }
        }).start();
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return new LocationBinder();
    }

    public void onDestroy() {
        RxLocationTool.unRegisterLocation();
        this.mOnGetLocationListener = null;
        super.onDestroy();
    }

    public class LocationBinder
    extends Binder {
        public RxServiceLocation getService() {
            return RxServiceLocation.this;
        }
    }

    public static interface OnGetLocationListener {
        public void getLocation(String var1, String var2, String var3, String var4, String var5, String var6, String var7);
    }
}

