/*
 * Decompiled with CFR 0.152.
 */
package com.vondear.rxtool;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.util.Log;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import com.vondear.rxtool.RxFileTool;
import com.vondear.rxtool.view.RxToast;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class RxPhotoTool {
    public static final int GET_IMAGE_BY_CAMERA = 5001;
    public static final int GET_IMAGE_FROM_PHONE = 5002;
    public static final int CROP_IMAGE = 5003;
    public static Uri imageUriFromCamera;
    public static Uri cropImageUri;

    public static void openCameraImage(Activity activity) {
        imageUriFromCamera = RxPhotoTool.createImagePathUri((Context)activity);
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        intent.putExtra("output", (Parcelable)imageUriFromCamera);
        activity.startActivityForResult(intent, 5001);
    }

    public static void openCameraImage(Fragment fragment) {
        imageUriFromCamera = RxPhotoTool.createImagePathUri(fragment.getContext());
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        intent.putExtra("output", (Parcelable)imageUriFromCamera);
        fragment.startActivityForResult(intent, 5001);
    }

    public static void openLocalImage(Activity activity) {
        Intent intent = new Intent();
        intent.setType("image/*");
        intent.setAction("android.intent.action.GET_CONTENT");
        activity.startActivityForResult(intent, 5002);
    }

    public static void openLocalImage(Fragment fragment) {
        Intent intent = new Intent();
        intent.setType("image/*");
        intent.setAction("android.intent.action.GET_CONTENT");
        fragment.startActivityForResult(intent, 5002);
    }

    public static void cropImage(Activity activity, Uri srcUri) {
        cropImageUri = RxPhotoTool.createImagePathUri((Context)activity);
        Intent intent = new Intent("com.android.camera.action.CROP");
        intent.setDataAndType(srcUri, "image/*");
        intent.putExtra("crop", "true");
        intent.putExtra("aspectX", 1);
        intent.putExtra("aspectY", 1);
        intent.putExtra("outputX", 300);
        intent.putExtra("outputY", 300);
        intent.putExtra("output", (Parcelable)cropImageUri);
        intent.putExtra("return-data", true);
        activity.startActivityForResult(intent, 5003);
    }

    public static void cropImage(Fragment fragment, Uri srcUri) {
        cropImageUri = RxPhotoTool.createImagePathUri(fragment.getContext());
        Intent intent = new Intent("com.android.camera.action.CROP");
        intent.setDataAndType(srcUri, "image/*");
        intent.putExtra("crop", "true");
        intent.putExtra("aspectX", 1);
        intent.putExtra("aspectY", 1);
        intent.putExtra("outputX", 300);
        intent.putExtra("outputY", 300);
        intent.putExtra("output", (Parcelable)cropImageUri);
        intent.putExtra("return-data", true);
        fragment.startActivityForResult(intent, 5003);
    }

    public static Uri createImagePathUri(Context context) {
        Uri[] imageFilePath = new Uri[]{null};
        if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            ActivityCompat.requestPermissions((Activity)((Activity)context), (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, (int)1);
            imageFilePath[0] = Uri.parse((String)"");
            RxToast.error("\u8bf7\u5148\u83b7\u53d6\u5199\u5165SDCard\u6743\u9650");
        } else {
            String status = Environment.getExternalStorageState();
            SimpleDateFormat timeFormatter = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.CHINA);
            long time = System.currentTimeMillis();
            String imageName = timeFormatter.format(new Date(time));
            ContentValues values = new ContentValues(3);
            values.put("_display_name", imageName);
            values.put("datetaken", Long.valueOf(time));
            values.put("mime_type", "image/jpeg");
            imageFilePath[0] = status.equals("mounted") ? context.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values) : context.getContentResolver().insert(MediaStore.Images.Media.INTERNAL_CONTENT_URI, values);
        }
        Log.i((String)"", (String)("\u751f\u6210\u7684\u7167\u7247\u8f93\u51fa\u8def\u5f84\uff1a" + imageFilePath[0].toString()));
        return imageFilePath[0];
    }

    public static String getRealFilePath(Context context, Uri uri) {
        if (null == uri) {
            return null;
        }
        String scheme = uri.getScheme();
        String data = null;
        if (scheme == null) {
            data = uri.getPath();
        } else if ("file".equals(scheme)) {
            data = uri.getPath();
        } else if ("content".equals(scheme)) {
            String[] projection = new String[]{"_data"};
            Cursor cursor = context.getContentResolver().query(uri, projection, null, null, null);
            if (null != cursor) {
                int index;
                if (cursor.moveToFirst() && (index = cursor.getColumnIndex("_data")) > -1) {
                    data = cursor.getString(index);
                }
                cursor.close();
            }
        }
        return data;
    }

    @TargetApi(value=19)
    public static String getImageAbsolutePath(Context context, Uri imageUri) {
        if (context == null || imageUri == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 19 && DocumentsContract.isDocumentUri((Context)context, (Uri)imageUri)) {
            if (RxFileTool.isExternalStorageDocument(imageUri)) {
                String docId = DocumentsContract.getDocumentId((Uri)imageUri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    return Environment.getExternalStorageDirectory() + "/" + split[1];
                }
            } else {
                if (RxFileTool.isDownloadsDocument(imageUri)) {
                    String id2 = DocumentsContract.getDocumentId((Uri)imageUri);
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id2));
                    return RxFileTool.getDataColumn(context, contentUri, null, null);
                }
                if (RxFileTool.isMediaDocument(imageUri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)imageUri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    Uri contentUri = null;
                    if ("image".equals(type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(type)) {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(type)) {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return RxFileTool.getDataColumn(context, contentUri, selection, selectionArgs);
                }
            }
        } else {
            if ("content".equalsIgnoreCase(imageUri.getScheme())) {
                if (RxFileTool.isGooglePhotosUri(imageUri)) {
                    return imageUri.getLastPathSegment();
                }
                return RxFileTool.getDataColumn(context, imageUri, null, null);
            }
            if ("file".equalsIgnoreCase(imageUri.getScheme())) {
                return imageUri.getPath();
            }
        }
        return null;
    }
}

