/*
 * Decompiled with CFR 0.152.
 */
package com.vondear.rxtool;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.os.Process;
import androidx.annotation.NonNull;
import com.vondear.rxtool.RxFileTool;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class RxCrashTool {
    private static final String FILE_SEP = System.getProperty("file.separator");
    private static final Format FORMAT = new SimpleDateFormat("MM-dd HH-mm-ss", Locale.getDefault());
    private static final String CRASH_HEAD = "\n************* Crash Log Head ****************\nDevice Manufacturer: " + Build.MANUFACTURER + "\nDevice Model       : " + Build.MODEL + "\nAndroid Version    : " + Build.VERSION.RELEASE + "\nAndroid SDK        : " + Build.VERSION.SDK_INT + "\nApp VersionName    : " + versionName + "\nApp VersionCode    : " + versionCode + "\n************* Crash Log Head ****************\n\n";
    private static final Thread.UncaughtExceptionHandler DEFAULT_UNCAUGHT_EXCEPTION_HANDLER = Thread.getDefaultUncaughtExceptionHandler();
    private static final Thread.UncaughtExceptionHandler UNCAUGHT_EXCEPTION_HANDLER = new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, final Throwable e) {
            if (e == null) {
                Process.killProcess((int)Process.myPid());
                System.exit(0);
                return;
            }
            Date now = new Date(System.currentTimeMillis());
            String fileName = FORMAT.format(now) + ".txt";
            final String fullPath = (dir == null ? mCrashDirPath : dir) + fileName;
            if (!RxCrashTool.createOrExistsFile(fullPath)) {
                return;
            }
            if (sExecutor == null) {
                sExecutor = Executors.newSingleThreadExecutor();
            }
            sExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try (PrintWriter pw = null;){
                        pw = new PrintWriter(new FileWriter(fullPath, false));
                        pw.write(CRASH_HEAD);
                        e.printStackTrace(pw);
                        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                            cause.printStackTrace(pw);
                        }
                    }
                }
            });
            if (DEFAULT_UNCAUGHT_EXCEPTION_HANDLER != null) {
                DEFAULT_UNCAUGHT_EXCEPTION_HANDLER.uncaughtException(t, e);
            }
        }
    };
    private static Context mContext;
    private static String mCrashDirPath;
    private static String dir;
    private static String versionName;
    private static int versionCode;
    private static ExecutorService sExecutor;

    public static void init(Context context) {
        mContext = context;
        try {
            PackageInfo pi = mContext.getPackageManager().getPackageInfo(mContext.getPackageName(), 0);
            if (pi != null) {
                versionName = pi.versionName;
                versionCode = pi.versionCode;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        RxCrashTool.init("");
    }

    public static void init(@NonNull File crashDir) {
        RxCrashTool.init(crashDir.getAbsolutePath());
    }

    public static void init(String crashDir) {
        dir = RxCrashTool.isSpace(crashDir) ? null : (crashDir.endsWith(FILE_SEP) ? crashDir : crashDir + FILE_SEP);
        try {
            PackageManager packageManager = mContext.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(mContext.getPackageName(), 0);
            int labelRes = packageInfo.applicationInfo.labelRes;
            String name = mContext.getResources().getString(labelRes);
            mCrashDirPath = RxFileTool.getRootPath() + File.separator + name + File.separator + "crash" + File.separator;
        }
        catch (Exception e) {
            mCrashDirPath = "mounted".equals(Environment.getExternalStorageState()) ? mContext.getExternalCacheDir().getPath() + File.separator + "crash" + File.separator : mContext.getCacheDir().getPath() + File.separator + "crash" + File.separator;
        }
        Thread.setDefaultUncaughtExceptionHandler(UNCAUGHT_EXCEPTION_HANDLER);
    }

    private static boolean createOrExistsFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            return file.isFile();
        }
        if (!RxCrashTool.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    private static boolean isSpace(String s) {
        if (s == null) {
            return true;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

