/*
 * Decompiled with CFR 0.152.
 */
package com.vondear.rxtool;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioManager;
import android.media.MediaPlayer;
import com.vondear.rxtool.R;
import com.vondear.rxtool.RxVibrateTool;
import java.io.IOException;

public class RxBeepTool {
    private static final float BEEP_VOLUME = 0.5f;
    private static final int VIBRATE_DURATION = 200;
    private static boolean playBeep = false;
    private static MediaPlayer mediaPlayer;

    public static void playBeep(Activity mContext, boolean vibrate) {
        playBeep = true;
        AudioManager audioService = (AudioManager)mContext.getSystemService("audio");
        if (audioService.getRingerMode() != 2) {
            playBeep = false;
        }
        if (playBeep && mediaPlayer != null) {
            mediaPlayer.start();
        } else {
            mContext.setVolumeControlStream(3);
            mediaPlayer = new MediaPlayer();
            mediaPlayer.setAudioStreamType(3);
            mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                public void onCompletion(MediaPlayer mediaPlayer) {
                    mediaPlayer.seekTo(0);
                }
            });
            AssetFileDescriptor file = mContext.getResources().openRawResourceFd(R.raw.beep);
            try {
                mediaPlayer.setDataSource(file.getFileDescriptor(), file.getStartOffset(), file.getLength());
                file.close();
                mediaPlayer.setVolume(0.5f, 0.5f);
                mediaPlayer.prepare();
            }
            catch (IOException e) {
                mediaPlayer = null;
            }
        }
        if (vibrate) {
            RxVibrateTool.vibrateOnce((Context)mContext, 200);
        }
    }
}

