/*
 * Decompiled with CFR 0.152.
 */
package com.vondear.rxtool;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.support.v4.content.FileProvider;
import android.util.Base64;
import android.util.Log;
import com.vondear.rxtool.RxDataTool;
import com.vondear.rxtool.RxEncryptTool;
import com.vondear.rxtool.RxPhotoTool;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class RxFileTool {
    public static final int BUFSIZE = 8192;
    private static final String TAG = "RxFileTool";

    public static File getRootPath() {
        File path = null;
        path = RxFileTool.sdCardIsAvailable() ? Environment.getExternalStorageDirectory() : Environment.getDataDirectory();
        return path;
    }

    public static File getCacheFolder(Context context) {
        File folder = new File(context.getCacheDir(), "IMAGECACHE");
        if (!folder.exists()) {
            folder.mkdir();
        }
        return folder;
    }

    public static boolean isSDCardEnable() {
        return "mounted".equals(Environment.getExternalStorageState());
    }

    public static String getSDCardPath() {
        if (!RxFileTool.isSDCardEnable()) {
            return "sdcard unable!";
        }
        return Environment.getExternalStorageDirectory().getPath() + File.separator;
    }

    public static String getDataPath() {
        if (!RxFileTool.isSDCardEnable()) {
            return "sdcard unable!";
        }
        return Environment.getDataDirectory().getPath();
    }

    @TargetApi(value=18)
    public static String getFreeSpace() {
        if (!RxFileTool.isSDCardEnable()) {
            return "sdcard unable!";
        }
        StatFs stat = new StatFs(RxFileTool.getSDCardPath());
        long availableBlocks = stat.getAvailableBlocksLong();
        long blockSize = stat.getBlockSizeLong();
        return RxDataTool.byte2FitSize(availableBlocks * blockSize);
    }

    public static boolean sdCardIsAvailable() {
        if (Environment.getExternalStorageState().equals("mounted")) {
            File sd = new File(Environment.getExternalStorageDirectory().getPath());
            return sd.canWrite();
        }
        return false;
    }

    public static boolean fileExists(String filePath) {
        File file = new File(filePath);
        return file.exists();
    }

    public static boolean delAllFile(String path) {
        boolean flag = false;
        File file = new File(path);
        if (!file.exists()) {
            return flag;
        }
        if (file.isFile()) {
            file.delete();
            return true;
        }
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File exeFile = files[i];
            if (exeFile.isDirectory()) {
                RxFileTool.delAllFile(exeFile.getAbsolutePath());
                continue;
            }
            exeFile.delete();
        }
        file.delete();
        return flag;
    }

    public static boolean deleteFilesInDir(String dirPath) {
        return RxFileTool.deleteFilesInDir(RxFileTool.getFileByPath(dirPath));
    }

    public static boolean deleteFilesInDir(File dir) {
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null && files.length != 0) {
            for (File file : files) {
                if (!(file.isFile() ? !RxFileTool.deleteFile(file) : file.isDirectory() && !RxFileTool.deleteDir(file))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean cleanInternalCache(Context context) {
        return RxFileTool.deleteFilesInDir(context.getCacheDir());
    }

    public static boolean cleanInternalFiles(Context context) {
        return RxFileTool.deleteFilesInDir(context.getFilesDir());
    }

    public static boolean cleanInternalDbs(Context context) {
        return RxFileTool.deleteFilesInDir(context.getFilesDir().getParent() + File.separator + "databases");
    }

    public static boolean cleanInternalDbByName(Context context, String dbName) {
        return context.deleteDatabase(dbName);
    }

    public static boolean cleanInternalSP(Context context) {
        return RxFileTool.deleteFilesInDir(context.getFilesDir().getParent() + File.separator + "shared_prefs");
    }

    public static boolean cleanExternalCache(Context context) {
        return RxFileTool.isSDCardEnable() && RxFileTool.deleteFilesInDir(context.getExternalCacheDir());
    }

    public static boolean cleanCustomCache(String dirPath) {
        return RxFileTool.deleteFilesInDir(dirPath);
    }

    public static boolean cleanCustomCache(File dir) {
        return RxFileTool.deleteFilesInDir(dir);
    }

    public static boolean copy(String srcFile, String destFile) {
        try {
            int c;
            FileInputStream in = new FileInputStream(srcFile);
            FileOutputStream out = new FileOutputStream(destFile);
            byte[] bytes = new byte[1024];
            while ((c = in.read(bytes)) != -1) {
                out.write(bytes, 0, c);
            }
            in.close();
            out.flush();
            out.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static void copyFolder(String oldPath, String newPath) {
        try {
            new File(newPath).mkdirs();
            File a = new File(oldPath);
            String[] file = a.list();
            File temp = null;
            for (int i = 0; i < file.length; ++i) {
                temp = oldPath.endsWith(File.separator) ? new File(oldPath + file[i]) : new File(oldPath + File.separator + file[i]);
                if (temp.isFile()) {
                    int len;
                    FileInputStream input = new FileInputStream(temp);
                    FileOutputStream output = new FileOutputStream(newPath + "/" + temp.getName().toString());
                    byte[] b = new byte[5120];
                    while ((len = input.read(b)) != -1) {
                        output.write(b, 0, len);
                    }
                    output.flush();
                    output.close();
                    input.close();
                }
                if (!temp.isDirectory()) continue;
                RxFileTool.copyFolder(oldPath + "/" + file[i], newPath + "/" + file[i]);
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean renameFile(String resFilePath, String newFilePath) {
        File resFile = new File(resFilePath);
        File newFile = new File(newFilePath);
        return resFile.renameTo(newFile);
    }

    @SuppressLint(value={"NewApi"})
    public static long getSDCardAvailaleSize() {
        long availableBlocks;
        long blockSize;
        File path = RxFileTool.getRootPath();
        StatFs stat = new StatFs(path.getPath());
        if (Build.VERSION.SDK_INT >= 18) {
            blockSize = stat.getBlockSizeLong();
            availableBlocks = stat.getAvailableBlocksLong();
        } else {
            blockSize = stat.getBlockSize();
            availableBlocks = stat.getAvailableBlocks();
        }
        return availableBlocks * blockSize;
    }

    @SuppressLint(value={"NewApi"})
    public static long getDirSize(String path) {
        long availableBlocks;
        long blockSize;
        StatFs stat = new StatFs(path);
        if (Build.VERSION.SDK_INT >= 18) {
            blockSize = stat.getBlockSizeLong();
            availableBlocks = stat.getAvailableBlocksLong();
        } else {
            blockSize = stat.getBlockSize();
            availableBlocks = stat.getAvailableBlocks();
        }
        return availableBlocks * blockSize;
    }

    public static long getFileAllSize(String path) {
        File file = new File(path);
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] childrens = file.listFiles();
                long size = 0L;
                for (File f : childrens) {
                    size += RxFileTool.getFileAllSize(f.getPath());
                }
                return size;
            }
            return file.length();
        }
        return 0L;
    }

    public static boolean initFile(String path) {
        boolean result = false;
        try {
            File file = new File(path);
            if (!file.exists()) {
                result = file.createNewFile();
            } else if (file.isDirectory()) {
                file.delete();
                result = file.createNewFile();
            } else if (file.exists()) {
                result = true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean initDirectory(String path) {
        boolean result = false;
        File file = new File(path);
        if (!file.exists()) {
            result = file.mkdir();
        } else if (!file.isDirectory()) {
            file.delete();
            result = file.mkdir();
        } else if (file.exists()) {
            result = true;
        }
        return result;
    }

    public static void copyFile(File from, File to) throws IOException {
        if (!from.exists()) {
            throw new IOException("The source file not exist: " + from.getAbsolutePath());
        }
        try (FileInputStream fis = new FileInputStream(from);){
            RxFileTool.copyFile(fis, to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copyFile(InputStream from, File to) throws IOException {
        long totalBytes = 0L;
        try (FileOutputStream fos = new FileOutputStream(to, false);){
            int len;
            byte[] data = new byte[1024];
            while ((len = from.read(data)) > -1) {
                fos.write(data, 0, len);
                totalBytes += (long)len;
            }
            fos.flush();
        }
        return totalBytes;
    }

    public static void saveFile(InputStream inputStream, String filePath) {
        try {
            int len;
            FileOutputStream outputStream = new FileOutputStream(new File(filePath), false);
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) != -1) {
                ((OutputStream)outputStream).write(buffer, 0, len);
            }
            outputStream.flush();
            ((OutputStream)outputStream).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveFileUTF8(String path, String content, Boolean append) throws IOException {
        FileOutputStream fos = new FileOutputStream(path, (boolean)append);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        out.write(content);
        ((Writer)out).flush();
        ((Writer)out).close();
        fos.flush();
        fos.close();
    }

    public static String getFileUTF8(String path) {
        String result = "";
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(path);
            int length = ((InputStream)fin).available();
            byte[] buffer = new byte[length];
            ((InputStream)fin).read(buffer);
            ((InputStream)fin).close();
            result = new String(buffer, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static Intent getFileIntent(String path, String mimeType) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setDataAndType(Uri.fromFile((File)new File(path)), mimeType);
        return intent;
    }

    public static String getDiskCacheDir(Context context) {
        String cachePath = null;
        cachePath = "mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable() ? context.getExternalCacheDir().getPath() : context.getCacheDir().getPath();
        return cachePath;
    }

    public static String getDiskFileDir(Context context) {
        String cachePath = null;
        cachePath = "mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable() ? context.getExternalFilesDir(Environment.DIRECTORY_MOVIES).getPath() : context.getFilesDir().getPath();
        return cachePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeFiles(Context context, File outFile, List<File> files) {
        FileChannel outChannel = null;
        try {
            outChannel = new FileOutputStream(outFile).getChannel();
            for (File f : files) {
                FileChannel fc = new FileInputStream(f).getChannel();
                ByteBuffer bb = ByteBuffer.allocate(8192);
                while (fc.read(bb) != -1) {
                    bb.flip();
                    outChannel.write(bb);
                    bb.clear();
                }
                fc.close();
            }
            Log.d((String)TAG, (String)"\u62fc\u63a5\u5b8c\u6210");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            try {
                if (outChannel != null) {
                    outChannel.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static String getNativeM3u(Context context, File file, List<File> pathList) {
        FileInputStream in = null;
        int num = 0;
        StringBuffer buf = new StringBuffer();
        try {
            if (file != null) {
                in = new FileInputStream(file);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String line = "";
            while ((line = reader.readLine()) != null) {
                if (line.length() > 0 && line.startsWith("http://")) {
                    buf.append("file:" + pathList.get(num).getAbsolutePath() + "\r\n");
                    ++num;
                    continue;
                }
                buf.append(line + "\r\n");
            }
            ((InputStream)in).close();
            RxFileTool.write(file.getAbsolutePath(), buf.toString());
            Log.d((String)"ts\u66ff\u6362", (String)"ts\u66ff\u6362\u5b8c\u6210");
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String filePath, String content) {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(filePath));
            bw.write(content);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    bw = null;
                }
            }
        }
    }

    public static Vector<String> GetAllFileName(String fileAbsolutePath, String suffix) {
        Vector<String> vecFile = new Vector<String>();
        File file = new File(fileAbsolutePath);
        File[] subFile = file.listFiles();
        for (int iFileLength = 0; iFileLength < subFile.length; ++iFileLength) {
            String filename;
            if (subFile[iFileLength].isDirectory() || !(filename = subFile[iFileLength].getName()).trim().toLowerCase().endsWith(suffix)) continue;
            vecFile.add(filename);
        }
        return vecFile;
    }

    public static File getFileByPath(String filePath) {
        return RxDataTool.isNullString(filePath) ? null : new File(filePath);
    }

    public static boolean isFileExists(String filePath) {
        return RxFileTool.isFileExists(RxFileTool.getFileByPath(filePath));
    }

    public static boolean isFileExists(File file) {
        return file != null && file.exists();
    }

    public static boolean isDir(String dirPath) {
        return RxFileTool.isDir(RxFileTool.getFileByPath(dirPath));
    }

    public static boolean isDir(File file) {
        return RxFileTool.isFileExists(file) && file.isDirectory();
    }

    public static boolean isFile(String filePath) {
        return RxFileTool.isFile(RxFileTool.getFileByPath(filePath));
    }

    public static boolean isFile(File file) {
        return RxFileTool.isFileExists(file) && file.isFile();
    }

    public static boolean createOrExistsDir(String dirPath) {
        return RxFileTool.createOrExistsDir(RxFileTool.getFileByPath(dirPath));
    }

    public static boolean createOrExistsDir(File file) {
        return file != null && (file.exists() ? file.isDirectory() : file.mkdirs());
    }

    public static boolean createOrExistsFile(String filePath) {
        return RxFileTool.createOrExistsFile(RxFileTool.getFileByPath(filePath));
    }

    public static boolean createOrExistsFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return file.isFile();
        }
        if (!RxFileTool.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean createFileByDeleteOldFile(String filePath) {
        return RxFileTool.createFileByDeleteOldFile(RxFileTool.getFileByPath(filePath));
    }

    public static boolean createFileByDeleteOldFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists() && file.isFile() && !file.delete()) {
            return false;
        }
        if (!RxFileTool.createOrExistsDir(file.getParentFile())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean copyOrMoveDir(String srcDirPath, String destDirPath, boolean isMove) {
        return RxFileTool.copyOrMoveDir(RxFileTool.getFileByPath(srcDirPath), RxFileTool.getFileByPath(destDirPath), isMove);
    }

    public static boolean copyOrMoveDir(File srcDir, File destDir, boolean isMove) {
        File[] files;
        if (srcDir == null || destDir == null) {
            return false;
        }
        String srcPath = srcDir.getPath() + File.separator;
        String destPath = destDir.getPath() + File.separator;
        if (destPath.contains(srcPath)) {
            return false;
        }
        if (!srcDir.exists() || !srcDir.isDirectory()) {
            return false;
        }
        if (!RxFileTool.createOrExistsDir(destDir)) {
            return false;
        }
        for (File file : files = srcDir.listFiles()) {
            File oneDestFile = new File(destPath + file.getName());
            if (!(file.isFile() ? !RxFileTool.copyOrMoveFile(file, oneDestFile, isMove) : file.isDirectory() && !RxFileTool.copyOrMoveDir(file, oneDestFile, isMove))) continue;
            return false;
        }
        return !isMove || RxFileTool.deleteDir(srcDir);
    }

    public static boolean copyOrMoveFile(String srcFilePath, String destFilePath, boolean isMove) {
        return RxFileTool.copyOrMoveFile(RxFileTool.getFileByPath(srcFilePath), RxFileTool.getFileByPath(destFilePath), isMove);
    }

    public static boolean copyOrMoveFile(File srcFile, File destFile, boolean isMove) {
        if (srcFile == null || destFile == null) {
            return false;
        }
        if (!srcFile.exists() || !srcFile.isFile()) {
            return false;
        }
        if (destFile.exists() && destFile.isFile()) {
            return false;
        }
        if (!RxFileTool.createOrExistsDir(destFile.getParentFile())) {
            return false;
        }
        try {
            return RxFileTool.writeFileFromIS(destFile, (InputStream)new FileInputStream(srcFile), false) && (!isMove || RxFileTool.deleteFile(srcFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean copyDir(String srcDirPath, String destDirPath) {
        return RxFileTool.copyDir(RxFileTool.getFileByPath(srcDirPath), RxFileTool.getFileByPath(destDirPath));
    }

    public static boolean copyDir(File srcDir, File destDir) {
        return RxFileTool.copyOrMoveDir(srcDir, destDir, false);
    }

    public static boolean copyFile(String srcFilePath, String destFilePath) {
        return RxFileTool.copyFile(RxFileTool.getFileByPath(srcFilePath), RxFileTool.getFileByPath(destFilePath), false);
    }

    public static boolean copyFile(File srcFile, File destFile, boolean isCopy) {
        return RxFileTool.copyOrMoveFile(srcFile, destFile, false);
    }

    public static boolean moveDir(String srcDirPath, String destDirPath) {
        return RxFileTool.moveDir(RxFileTool.getFileByPath(srcDirPath), RxFileTool.getFileByPath(destDirPath));
    }

    public static boolean moveDir(File srcDir, File destDir) {
        return RxFileTool.copyOrMoveDir(srcDir, destDir, true);
    }

    public static boolean moveFile(String srcFilePath, String destFilePath) {
        return RxFileTool.moveFile(RxFileTool.getFileByPath(srcFilePath), RxFileTool.getFileByPath(destFilePath));
    }

    public static boolean moveFile(File srcFile, File destFile) {
        return RxFileTool.copyOrMoveFile(srcFile, destFile, true);
    }

    public static boolean deleteDir(String dirPath) {
        return RxFileTool.deleteDir(RxFileTool.getFileByPath(dirPath));
    }

    public static boolean deleteDir(File dir) {
        File[] files;
        if (dir == null) {
            return false;
        }
        if (!dir.exists()) {
            return true;
        }
        if (!dir.isDirectory()) {
            return false;
        }
        for (File file : files = dir.listFiles()) {
            if (!(file.isFile() ? !RxFileTool.deleteFile(file) : file.isDirectory() && !RxFileTool.deleteDir(file))) continue;
            return false;
        }
        return dir.delete();
    }

    public static boolean deleteFile(String srcFilePath) {
        return RxFileTool.deleteFile(RxFileTool.getFileByPath(srcFilePath));
    }

    public static boolean deleteFile(File file) {
        return file != null && (!file.exists() || file.isFile() && file.delete());
    }

    public static List<File> listFilesInDir(String dirPath, boolean isRecursive) {
        return RxFileTool.listFilesInDir(RxFileTool.getFileByPath(dirPath), isRecursive);
    }

    public static List<File> listFilesInDir(File dir, boolean isRecursive) {
        if (isRecursive) {
            return RxFileTool.listFilesInDir(dir);
        }
        if (dir == null || !RxFileTool.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        Collections.addAll(list, dir.listFiles());
        return list;
    }

    public static List<File> listFilesInDir(String dirPath) {
        return RxFileTool.listFilesInDir(RxFileTool.getFileByPath(dirPath));
    }

    public static List<File> listFilesInDir(File dir) {
        File[] files;
        if (dir == null || !RxFileTool.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        for (File file : files = dir.listFiles()) {
            list.add(file);
            if (!file.isDirectory()) continue;
            list.addAll(RxFileTool.listFilesInDir(file));
        }
        return list;
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, String suffix, boolean isRecursive) {
        return RxFileTool.listFilesInDirWithFilter(RxFileTool.getFileByPath(dirPath), suffix, isRecursive);
    }

    public static List<File> listFilesInDirWithFilter(File dir, String suffix, boolean isRecursive) {
        File[] files;
        if (isRecursive) {
            return RxFileTool.listFilesInDirWithFilter(dir, suffix);
        }
        if (dir == null || !RxFileTool.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        for (File file : files = dir.listFiles()) {
            if (!file.getName().toUpperCase().endsWith(suffix.toUpperCase())) continue;
            list.add(file);
        }
        return list;
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, String suffix) {
        return RxFileTool.listFilesInDirWithFilter(RxFileTool.getFileByPath(dirPath), suffix);
    }

    public static List<File> listFilesInDirWithFilter(File dir, String suffix) {
        File[] files;
        if (dir == null || !RxFileTool.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        for (File file : files = dir.listFiles()) {
            if (file.getName().toUpperCase().endsWith(suffix.toUpperCase())) {
                list.add(file);
            }
            if (!file.isDirectory()) continue;
            list.addAll(RxFileTool.listFilesInDirWithFilter(file, suffix));
        }
        return list;
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, FilenameFilter filter, boolean isRecursive) {
        return RxFileTool.listFilesInDirWithFilter(RxFileTool.getFileByPath(dirPath), filter, isRecursive);
    }

    public static List<File> listFilesInDirWithFilter(File dir, FilenameFilter filter, boolean isRecursive) {
        File[] files;
        if (isRecursive) {
            return RxFileTool.listFilesInDirWithFilter(dir, filter);
        }
        if (dir == null || !RxFileTool.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        for (File file : files = dir.listFiles()) {
            if (!filter.accept(file.getParentFile(), file.getName())) continue;
            list.add(file);
        }
        return list;
    }

    public static List<File> listFilesInDirWithFilter(String dirPath, FilenameFilter filter) {
        return RxFileTool.listFilesInDirWithFilter(RxFileTool.getFileByPath(dirPath), filter);
    }

    public static List<File> listFilesInDirWithFilter(File dir, FilenameFilter filter) {
        File[] files;
        if (dir == null || !RxFileTool.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        for (File file : files = dir.listFiles()) {
            if (filter.accept(file.getParentFile(), file.getName())) {
                list.add(file);
            }
            if (!file.isDirectory()) continue;
            list.addAll(RxFileTool.listFilesInDirWithFilter(file, filter));
        }
        return list;
    }

    public static List<File> searchFileInDir(String dirPath, String fileName) {
        return RxFileTool.searchFileInDir(RxFileTool.getFileByPath(dirPath), fileName);
    }

    public static List<File> searchFileInDir(File dir, String fileName) {
        File[] files;
        if (dir == null || !RxFileTool.isDir(dir)) {
            return null;
        }
        ArrayList<File> list = new ArrayList<File>();
        for (File file : files = dir.listFiles()) {
            if (file.getName().toUpperCase().equals(fileName.toUpperCase())) {
                list.add(file);
            }
            if (!file.isDirectory()) continue;
            list.addAll(RxFileTool.listFilesInDirWithFilter(file, fileName));
        }
        return list;
    }

    public static boolean writeFileFromIS(String filePath, InputStream is, boolean append) {
        return RxFileTool.writeFileFromIS(RxFileTool.getFileByPath(filePath), is, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromIS(File file, InputStream is, boolean append) {
        boolean bl;
        if (file == null || is == null) {
            return false;
        }
        if (!RxFileTool.createOrExistsFile(file)) {
            return false;
        }
        BufferedOutputStream os = null;
        try {
            int len;
            os = new BufferedOutputStream(new FileOutputStream(file, append));
            byte[] data = new byte[1024];
            while ((len = is.read(data, 0, 1024)) != -1) {
                ((OutputStream)os).write(data, 0, len);
            }
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                e.printStackTrace();
                bl2 = false;
            }
            catch (Throwable throwable) {
                RxFileTool.closeIO(is, os);
                throw throwable;
            }
            RxFileTool.closeIO(is, os);
            return bl2;
        }
        RxFileTool.closeIO(is, os);
        return bl;
    }

    public static boolean writeFileFromString(String filePath, String content, boolean append) {
        return RxFileTool.writeFileFromString(RxFileTool.getFileByPath(filePath), content, append);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromString(File file, String content, boolean append) {
        boolean bl;
        if (file == null || content == null) {
            return false;
        }
        if (!RxFileTool.createOrExistsFile(file)) {
            return false;
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file, append);
            fileWriter.write(content);
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                e.printStackTrace();
                bl2 = false;
            }
            catch (Throwable throwable) {
                RxFileTool.closeIO(fileWriter);
                throw throwable;
            }
            RxFileTool.closeIO(fileWriter);
            return bl2;
        }
        RxFileTool.closeIO(fileWriter);
        return bl;
    }

    public static List<String> readFile2List(String filePath, String charsetName) {
        return RxFileTool.readFile2List(RxFileTool.getFileByPath(filePath), charsetName);
    }

    public static List<String> readFile2List(File file, String charsetName) {
        return RxFileTool.readFile2List(file, 0, Integer.MAX_VALUE, charsetName);
    }

    public static List<String> readFile2List(String filePath, int st, int end, String charsetName) {
        return RxFileTool.readFile2List(RxFileTool.getFileByPath(filePath), st, end, charsetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFile2List(File file, int st, int end, String charsetName) {
        ArrayList<String> arrayList;
        if (file == null) {
            return null;
        }
        if (st > end) {
            return null;
        }
        BufferedReader reader = null;
        try {
            String line;
            ArrayList<String> list = new ArrayList<String>();
            reader = RxDataTool.isNullString(charsetName) ? new BufferedReader(new FileReader(file)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
            for (int curLine = 1; (line = reader.readLine()) != null && curLine <= end; ++curLine) {
                if (st > curLine || curLine > end) continue;
                list.add(line);
            }
            arrayList = list;
        }
        catch (IOException e) {
            List<String> list;
            try {
                e.printStackTrace();
                list = null;
            }
            catch (Throwable throwable) {
                RxFileTool.closeIO(reader);
                throw throwable;
            }
            RxFileTool.closeIO(reader);
            return list;
        }
        RxFileTool.closeIO(reader);
        return arrayList;
    }

    public static String readFile2String(String filePath, String charsetName) {
        return RxFileTool.readFile2String(RxFileTool.getFileByPath(filePath), charsetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile2String(File file, String charsetName) {
        String string;
        if (file == null) {
            return null;
        }
        BufferedReader reader = null;
        try {
            String line;
            StringBuilder sb = new StringBuilder();
            reader = RxDataTool.isNullString(charsetName) ? new BufferedReader(new InputStreamReader(new FileInputStream(file))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charsetName));
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\r\n");
            }
            string = sb.delete(sb.length() - 2, sb.length()).toString();
        }
        catch (IOException e) {
            String string2;
            try {
                e.printStackTrace();
                string2 = null;
            }
            catch (Throwable throwable) {
                RxFileTool.closeIO(reader);
                throw throwable;
            }
            RxFileTool.closeIO(reader);
            return string2;
        }
        RxFileTool.closeIO(reader);
        return string;
    }

    public static byte[] readFile2Bytes(String filePath) {
        return RxFileTool.readFile2Bytes(RxFileTool.getFileByPath(filePath));
    }

    public static byte[] readFile2Bytes(File file) {
        if (file == null) {
            return null;
        }
        try {
            return RxDataTool.inputStream2Bytes(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getFileCharsetSimple(String filePath) {
        return RxFileTool.getFileCharsetSimple(RxFileTool.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileCharsetSimple(File file) {
        int p = 0;
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            p = (((InputStream)is).read() << 8) + ((InputStream)is).read();
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                RxFileTool.closeIO(is);
                throw throwable;
            }
            RxFileTool.closeIO(is);
        }
        RxFileTool.closeIO(is);
        switch (p) {
            case 61371: {
                return "UTF-8";
            }
            case 65534: {
                return "Unicode";
            }
            case 65279: {
                return "UTF-16BE";
            }
        }
        return "GBK";
    }

    public static int getFileLines(String filePath) {
        return RxFileTool.getFileLines(RxFileTool.getFileByPath(filePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFileLines(File file) {
        int count = 1;
        BufferedInputStream is = null;
        try {
            int readChars;
            is = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[1024];
            while ((readChars = ((InputStream)is).read(buffer, 0, 1024)) != -1) {
                for (int i = 0; i < readChars; ++i) {
                    if (buffer[i] != 10) continue;
                    ++count;
                }
            }
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                RxFileTool.closeIO(is);
                throw throwable;
            }
            RxFileTool.closeIO(is);
        }
        RxFileTool.closeIO(is);
        return count;
    }

    public static String getFileSize(String filePath) {
        return RxFileTool.getFileSize(RxFileTool.getFileByPath(filePath));
    }

    public static String getFileSize(File file) {
        if (!RxFileTool.isFileExists(file)) {
            return "";
        }
        return RxDataTool.byte2FitSize(file.length());
    }

    public static String getFileMD5(String filePath) {
        return RxFileTool.getFileMD5(RxFileTool.getFileByPath(filePath));
    }

    public static String getFileMD5(File file) {
        return RxEncryptTool.encryptMD5File2String(file);
    }

    public static void closeIO(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        try {
            for (Closeable closeable : closeables) {
                if (closeable == null) continue;
                closeable.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getDirName(File file) {
        if (file == null) {
            return null;
        }
        return RxFileTool.getDirName(file.getPath());
    }

    public static String getDirName(String filePath) {
        if (RxDataTool.isNullString(filePath)) {
            return filePath;
        }
        int lastSep = filePath.lastIndexOf(File.separator);
        return lastSep == -1 ? "" : filePath.substring(0, lastSep + 1);
    }

    public static String getFileName(File file) {
        if (file == null) {
            return null;
        }
        return RxFileTool.getFileName(file.getPath());
    }

    public static String getFileName(String filePath) {
        if (RxDataTool.isNullString(filePath)) {
            return filePath;
        }
        int lastSep = filePath.lastIndexOf(File.separator);
        return lastSep == -1 ? filePath : filePath.substring(lastSep + 1);
    }

    public static String getFileNameNoExtension(File file) {
        if (file == null) {
            return null;
        }
        return RxFileTool.getFileNameNoExtension(file.getPath());
    }

    public static String getFileNameNoExtension(String filePath) {
        if (RxDataTool.isNullString(filePath)) {
            return filePath;
        }
        int lastPoi = filePath.lastIndexOf(46);
        int lastSep = filePath.lastIndexOf(File.separator);
        if (lastSep == -1) {
            return lastPoi == -1 ? filePath : filePath.substring(0, lastPoi);
        }
        if (lastPoi == -1 || lastSep > lastPoi) {
            return filePath.substring(lastSep + 1);
        }
        return filePath.substring(lastSep + 1, lastPoi);
    }

    public static String getFileExtension(File file) {
        if (file == null) {
            return null;
        }
        return RxFileTool.getFileExtension(file.getPath());
    }

    public static String getFileExtension(String filePath) {
        if (RxDataTool.isNullString(filePath)) {
            return filePath;
        }
        int lastPoi = filePath.lastIndexOf(46);
        int lastSep = filePath.lastIndexOf(File.separator);
        if (lastPoi == -1 || lastSep >= lastPoi) {
            return "";
        }
        return filePath.substring(lastPoi);
    }

    public static Uri getUriForFile(Context mContext, File file) {
        Uri fileUri = null;
        fileUri = Build.VERSION.SDK_INT >= 24 ? FileProvider.getUriForFile((Context)mContext, (String)(mContext.getPackageName() + ".fileprovider"), (File)file) : Uri.fromFile((File)file);
        return fileUri;
    }

    public static Uri getImageContentUri(Context context, File imageFile) {
        String filePath = imageFile.getAbsolutePath();
        Cursor cursor = context.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, new String[]{"_id"}, "_data=? ", new String[]{filePath}, null);
        if (cursor != null && cursor.moveToFirst()) {
            int id2 = cursor.getInt(cursor.getColumnIndex("_id"));
            Uri baseUri = Uri.parse((String)"content://media/external/images/media");
            return Uri.withAppendedPath((Uri)baseUri, (String)("" + id2));
        }
        if (imageFile.exists()) {
            ContentValues values = new ContentValues();
            values.put("_data", filePath);
            return context.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
        }
        return null;
    }

    public static File getFilePhotoFromUri(Activity context, Uri uri) {
        return new File(RxPhotoTool.getImageAbsolutePath((Context)context, uri));
    }

    @TargetApi(value=19)
    public static String getPathFromUri(Context context, Uri uri) {
        boolean isKitKat;
        boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
        if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (RxFileTool.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    return Environment.getExternalStorageDirectory() + "/" + split[1];
                }
            } else {
                if (RxFileTool.isDownloadsDocument(uri)) {
                    String id2 = DocumentsContract.getDocumentId((Uri)uri);
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id2));
                    return RxFileTool.getDataColumn(context, contentUri, null, null);
                }
                if (RxFileTool.isMediaDocument(uri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    Uri contentUri = null;
                    if ("image".equals(type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(type)) {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(type)) {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return RxFileTool.getDataColumn(context, contentUri, "_id=?", selectionArgs);
                }
            }
        } else {
            if ("content".equalsIgnoreCase(uri.getScheme())) {
                if (RxFileTool.isGooglePhotosUri(uri)) {
                    return uri.getLastPathSegment();
                }
                return RxFileTool.getDataColumn(context, uri, null, null);
            }
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return uri.getPath();
            }
        }
        return "";
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{column};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int index = cursor.getColumnIndexOrThrow(column);
                String string = cursor.getString(index);
                return string;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    public static void closeIOQuietly(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String file2Base64(String filePath) {
        FileInputStream fis = null;
        String base64String = "";
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            fis = new FileInputStream(filePath);
            byte[] buffer = new byte[102400];
            int count = 0;
            while ((count = fis.read(buffer)) != -1) {
                bos.write(buffer, 0, count);
            }
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        base64String = Base64.encodeToString((byte[])bos.toByteArray(), (int)0);
        return base64String;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void TextToFile(String strFilePath, String strBuffer) {
        OutputStreamWriter fileWriter = null;
        try {
            File fileText = new File(strFilePath);
            fileWriter = new FileWriter(fileText);
            fileWriter.write(strBuffer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                fileWriter.flush();
                fileWriter.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFileByLines(String fileName) {
        File file = new File(fileName);
        BufferedReader reader = null;
        try {
            System.out.println("\u4ee5\u884c\u4e3a\u5355\u4f4d\u8bfb\u53d6\u6587\u4ef6\u5185\u5bb9\uff0c\u4e00\u6b21\u8bfb\u4e00\u6574\u884c\uff1a");
            reader = new BufferedReader(new FileReader(file));
            String tempString = null;
            int line = 1;
            while ((tempString = reader.readLine()) != null) {
                System.out.println("line?????????????????????????????????? " + line + ": " + tempString);
                String content = tempString;
                ++line;
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

