/*
 * Decompiled with CFR 0.152.
 */
package com.plattysoft.leonids.modifiers;

import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.plattysoft.leonids.Particle;
import com.plattysoft.leonids.modifiers.ParticleModifier;

public class AlphaModifier
implements ParticleModifier {
    private int mInitialValue;
    private int mFinalValue;
    private long mStartTime;
    private long mEndTime;
    private float mDuration;
    private float mValueIncrement;
    private Interpolator mInterpolator;

    public AlphaModifier(int initialValue, int finalValue, long startMillis, long endMillis, Interpolator interpolator) {
        this.mInitialValue = initialValue;
        this.mFinalValue = finalValue;
        this.mStartTime = startMillis;
        this.mEndTime = endMillis;
        this.mDuration = this.mEndTime - this.mStartTime;
        this.mValueIncrement = this.mFinalValue - this.mInitialValue;
        this.mInterpolator = interpolator;
    }

    public AlphaModifier(int initialValue, int finalValue, long startMillis, long endMillis) {
        this(initialValue, finalValue, startMillis, endMillis, (Interpolator)new LinearInterpolator());
    }

    @Override
    public void apply(Particle particle, long milliseconds) {
        if (milliseconds < this.mStartTime) {
            particle.mAlpha = this.mInitialValue;
        } else if (milliseconds > this.mEndTime) {
            particle.mAlpha = this.mFinalValue;
        } else {
            float interpolatedValue = this.mInterpolator.getInterpolation((float)(milliseconds - this.mStartTime) * 1.0f / this.mDuration);
            particle.mAlpha = (int)((float)this.mInitialValue + this.mValueIncrement * interpolatedValue);
        }
    }
}

