/*
 * Decompiled with CFR 0.152.
 */
package com.plattysoft.leonids;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.plattysoft.leonids.AnimatedParticle;
import com.plattysoft.leonids.Particle;
import com.plattysoft.leonids.ParticleField;
import com.plattysoft.leonids.initializers.AccelerationInitializer;
import com.plattysoft.leonids.initializers.ParticleInitializer;
import com.plattysoft.leonids.initializers.RotationInitiazer;
import com.plattysoft.leonids.initializers.RotationSpeedInitializer;
import com.plattysoft.leonids.initializers.ScaleInitializer;
import com.plattysoft.leonids.initializers.SpeeddByComponentsInitializer;
import com.plattysoft.leonids.initializers.SpeeddModuleAndRangeInitializer;
import com.plattysoft.leonids.modifiers.AlphaModifier;
import com.plattysoft.leonids.modifiers.ParticleModifier;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;

public class ParticleSystem {
    private static final long DEFAULT_UPDATE_INTERVAL = 50L;
    private long mUpdateInterval;
    private ViewGroup mParentView;
    private int mMaxParticles;
    private Random mRandom;
    private ParticleField mDrawingView;
    private ArrayList<Particle> mParticles;
    private final ArrayList<Particle> mActiveParticles;
    private long mTimeToLive;
    private long mCurrentTime;
    private float mParticlesPerMilisecond;
    private int mActivatedParticles;
    private long mEmitingTime;
    private List<ParticleModifier> mModifiers;
    private List<ParticleInitializer> mInitializers;
    private ValueAnimator mAnimator;
    private Timer mTimer;
    private final ParticleTimerTask mTimerTask;
    private float mDpToPxScale;
    private int[] mParentLocation;
    private int mEmiterXMin;
    private int mEmiterXMax;
    private int mEmiterYMin;
    private int mEmiterYMax;

    private ParticleSystem(Context context, int maxParticles, long timeToLive, ViewGroup parentViewGroup) {
        this.mUpdateInterval = 50L;
        this.mActiveParticles = new ArrayList();
        this.mCurrentTime = 0L;
        this.mTimerTask = new ParticleTimerTask(this);
        this.mRandom = new Random();
        this.mParentLocation = new int[2];
        this.mParentView = parentViewGroup;
        this.setParentViewGroup(this.mParentView);
        this.mModifiers = new ArrayList<ParticleModifier>();
        this.mInitializers = new ArrayList<ParticleInitializer>();
        this.mMaxParticles = maxParticles;
        this.mParticles = new ArrayList();
        this.mTimeToLive = timeToLive;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.mDpToPxScale = displayMetrics.xdpi / 160.0f;
    }

    public ParticleSystem(Activity a, int maxParticles, int drawableRedId, long timeToLive) {
        this(a, maxParticles, a.getResources().getDrawable(drawableRedId), timeToLive, 0x1020002);
    }

    public ParticleSystem(Activity a, int maxParticles, int drawableRedId, long timeToLive, int parentViewId) {
        this(a, maxParticles, a.getResources().getDrawable(drawableRedId), timeToLive, parentViewId);
    }

    public ParticleSystem(Activity a, int maxParticles, Drawable drawable, long timeToLive) {
        this(a, maxParticles, drawable, timeToLive, 0x1020002);
    }

    public ParticleSystem(Activity a, int maxParticles, Drawable drawable, long timeToLive, int parentViewId) {
        this((Context)a, maxParticles, drawable, timeToLive, (ViewGroup)a.findViewById(parentViewId));
    }

    public ParticleSystem(Context context, int maxParticles, Drawable drawable, long timeToLive, ViewGroup parentView) {
        block3: {
            block2: {
                this(context, maxParticles, timeToLive, parentView);
                if (!(drawable instanceof BitmapDrawable)) break block2;
                Bitmap bitmap = ((BitmapDrawable)drawable).getBitmap();
                for (int i = 0; i < this.mMaxParticles; ++i) {
                    this.mParticles.add(new Particle(bitmap));
                }
                break block3;
            }
            if (!(drawable instanceof AnimationDrawable)) break block3;
            AnimationDrawable animation = (AnimationDrawable)drawable;
            for (int i = 0; i < this.mMaxParticles; ++i) {
                this.mParticles.add(new AnimatedParticle(animation));
            }
        }
    }

    public float dpToPx(float dp) {
        return dp * this.mDpToPxScale;
    }

    public ParticleSystem(Activity a, int maxParticles, Bitmap bitmap, long timeToLive) {
        this(a, maxParticles, bitmap, timeToLive, 0x1020002);
    }

    public ParticleSystem(Activity a, int maxParticles, Bitmap bitmap, long timeToLive, int parentViewId) {
        this((Context)a, maxParticles, bitmap, timeToLive, (ViewGroup)a.findViewById(parentViewId));
    }

    public ParticleSystem(Context context, int maxParticles, Bitmap bitmap, long timeToLive, ViewGroup parentView) {
        this(context, maxParticles, timeToLive, parentView);
        for (int i = 0; i < this.mMaxParticles; ++i) {
            this.mParticles.add(new Particle(bitmap));
        }
    }

    public ParticleSystem(Activity a, int maxParticles, AnimationDrawable animation, long timeToLive) {
        this(a, maxParticles, animation, timeToLive, 0x1020002);
    }

    public ParticleSystem(Activity a, int maxParticles, AnimationDrawable animation, long timeToLive, int parentViewId) {
        this(a, maxParticles, animation, timeToLive, (ViewGroup)a.findViewById(parentViewId));
    }

    public ParticleSystem(Activity a, int maxParticles, AnimationDrawable animation, long timeToLive, ViewGroup parentView) {
        this((Context)a, maxParticles, timeToLive, parentView);
        for (int i = 0; i < this.mMaxParticles; ++i) {
            this.mParticles.add(new AnimatedParticle(animation));
        }
    }

    public ParticleSystem addModifier(ParticleModifier modifier) {
        this.mModifiers.add(modifier);
        return this;
    }

    public ParticleSystem setUpdateInterval(long interval) {
        this.mUpdateInterval = interval;
        return this;
    }

    public ParticleSystem setSpeedRange(float speedMin, float speedMax) {
        this.mInitializers.add(new SpeeddModuleAndRangeInitializer(this.dpToPx(speedMin), this.dpToPx(speedMax), 0, 360));
        return this;
    }

    public ParticleSystem setSpeedModuleAndAngleRange(float speedMin, float speedMax, int minAngle, int maxAngle) {
        while (maxAngle < minAngle) {
            maxAngle += 360;
        }
        this.mInitializers.add(new SpeeddModuleAndRangeInitializer(this.dpToPx(speedMin), this.dpToPx(speedMax), minAngle, maxAngle));
        return this;
    }

    public ParticleSystem setSpeedByComponentsRange(float speedMinX, float speedMaxX, float speedMinY, float speedMaxY) {
        this.mInitializers.add(new SpeeddByComponentsInitializer(this.dpToPx(speedMinX), this.dpToPx(speedMaxX), this.dpToPx(speedMinY), this.dpToPx(speedMaxY)));
        return this;
    }

    public ParticleSystem setInitialRotationRange(int minAngle, int maxAngle) {
        this.mInitializers.add(new RotationInitiazer(minAngle, maxAngle));
        return this;
    }

    public ParticleSystem setScaleRange(float minScale, float maxScale) {
        this.mInitializers.add(new ScaleInitializer(minScale, maxScale));
        return this;
    }

    public ParticleSystem setRotationSpeed(float rotationSpeed) {
        this.mInitializers.add(new RotationSpeedInitializer(rotationSpeed, rotationSpeed));
        return this;
    }

    public ParticleSystem setRotationSpeedRange(float minRotationSpeed, float maxRotationSpeed) {
        this.mInitializers.add(new RotationSpeedInitializer(minRotationSpeed, maxRotationSpeed));
        return this;
    }

    public ParticleSystem setAccelerationModuleAndAndAngleRange(float minAcceleration, float maxAcceleration, int minAngle, int maxAngle) {
        this.mInitializers.add(new AccelerationInitializer(this.dpToPx(minAcceleration), this.dpToPx(maxAcceleration), minAngle, maxAngle));
        return this;
    }

    public ParticleSystem setAcceleration(float acceleration, int angle) {
        this.mInitializers.add(new AccelerationInitializer(acceleration, acceleration, angle, angle));
        return this;
    }

    public ParticleSystem setParentViewGroup(ViewGroup viewGroup) {
        this.mParentView = viewGroup;
        if (this.mParentView != null) {
            this.mParentView.getLocationInWindow(this.mParentLocation);
        }
        return this;
    }

    public ParticleSystem setStartTime(int time) {
        this.mCurrentTime = time;
        return this;
    }

    public ParticleSystem setFadeOut(long milisecondsBeforeEnd, Interpolator interpolator) {
        this.mModifiers.add(new AlphaModifier(255, 0, this.mTimeToLive - milisecondsBeforeEnd, this.mTimeToLive, interpolator));
        return this;
    }

    public ParticleSystem setFadeOut(long duration) {
        return this.setFadeOut(duration, (Interpolator)new LinearInterpolator());
    }

    public void emitWithGravity(View emiter, int gravity, int particlesPerSecond, int emitingTime) {
        this.configureEmiter(emiter, gravity);
        this.startEmiting(particlesPerSecond, emitingTime);
    }

    public void emit(View emiter, int particlesPerSecond, int emitingTime) {
        this.emitWithGravity(emiter, 17, particlesPerSecond, emitingTime);
    }

    public void emit(View emiter, int particlesPerSecond) {
        this.emitWithGravity(emiter, 17, particlesPerSecond);
    }

    public void emitWithGravity(View emiter, int gravity, int particlesPerSecond) {
        this.configureEmiter(emiter, gravity);
        this.startEmiting(particlesPerSecond);
    }

    private void startEmiting(int particlesPerSecond) {
        this.mActivatedParticles = 0;
        this.mParticlesPerMilisecond = (float)particlesPerSecond / 1000.0f;
        this.mDrawingView = new ParticleField(this.mParentView.getContext());
        this.mParentView.addView((View)this.mDrawingView);
        this.mEmitingTime = -1L;
        this.mDrawingView.setParticles(this.mActiveParticles);
        this.updateParticlesBeforeStartTime(particlesPerSecond);
        this.mTimer = new Timer();
        this.mTimer.schedule((TimerTask)this.mTimerTask, 0L, this.mUpdateInterval);
    }

    public void emit(int emitterX, int emitterY, int particlesPerSecond, int emitingTime) {
        this.configureEmiter(emitterX, emitterY);
        this.startEmiting(particlesPerSecond, emitingTime);
    }

    private void configureEmiter(int emitterX, int emitterY) {
        this.mEmiterXMax = this.mEmiterXMin = emitterX - this.mParentLocation[0];
        this.mEmiterYMax = this.mEmiterYMin = emitterY - this.mParentLocation[1];
    }

    private void startEmiting(int particlesPerSecond, int emitingTime) {
        this.mActivatedParticles = 0;
        this.mParticlesPerMilisecond = (float)particlesPerSecond / 1000.0f;
        this.mDrawingView = new ParticleField(this.mParentView.getContext());
        this.mParentView.addView((View)this.mDrawingView);
        this.mDrawingView.setParticles(this.mActiveParticles);
        this.updateParticlesBeforeStartTime(particlesPerSecond);
        this.mEmitingTime = emitingTime;
        this.startAnimator((Interpolator)new LinearInterpolator(), (long)emitingTime + this.mTimeToLive);
    }

    public void emit(int emitterX, int emitterY, int particlesPerSecond) {
        this.configureEmiter(emitterX, emitterY);
        this.startEmiting(particlesPerSecond);
    }

    public void updateEmitPoint(int emitterX, int emitterY) {
        this.configureEmiter(emitterX, emitterY);
    }

    public void oneShot(View emiter, int numParticles) {
        this.oneShot(emiter, numParticles, (Interpolator)new LinearInterpolator());
    }

    public void oneShot(View emiter, int numParticles, Interpolator interpolator) {
        this.configureEmiter(emiter, 17);
        this.mActivatedParticles = 0;
        this.mEmitingTime = this.mTimeToLive;
        for (int i = 0; i < numParticles && i < this.mMaxParticles; ++i) {
            this.activateParticle(0L);
        }
        this.mDrawingView = new ParticleField(this.mParentView.getContext());
        this.mParentView.addView((View)this.mDrawingView);
        this.mDrawingView.setParticles(this.mActiveParticles);
        this.startAnimator(interpolator, this.mTimeToLive);
    }

    private void startAnimator(Interpolator interpolator, long animnationTime) {
        this.mAnimator = ValueAnimator.ofInt((int[])new int[]{0, (int)animnationTime});
        this.mAnimator.setDuration(animnationTime);
        this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int miliseconds = (Integer)animation.getAnimatedValue();
                ParticleSystem.this.onUpdate(miliseconds);
            }
        });
        this.mAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                ParticleSystem.this.cleanupAnimation();
            }

            public void onAnimationCancel(Animator animation) {
                ParticleSystem.this.cleanupAnimation();
            }
        });
        this.mAnimator.setInterpolator((TimeInterpolator)interpolator);
        this.mAnimator.start();
    }

    private void configureEmiter(View emiter, int gravity) {
        int[] location = new int[2];
        emiter.getLocationInWindow(location);
        if (this.hasGravity(gravity, 3)) {
            this.mEmiterXMax = this.mEmiterXMin = location[0] - this.mParentLocation[0];
        } else if (this.hasGravity(gravity, 5)) {
            this.mEmiterXMax = this.mEmiterXMin = location[0] + emiter.getWidth() - this.mParentLocation[0];
        } else if (this.hasGravity(gravity, 1)) {
            this.mEmiterXMax = this.mEmiterXMin = location[0] + emiter.getWidth() / 2 - this.mParentLocation[0];
        } else {
            this.mEmiterXMin = location[0] - this.mParentLocation[0];
            this.mEmiterXMax = location[0] + emiter.getWidth() - this.mParentLocation[0];
        }
        if (this.hasGravity(gravity, 48)) {
            this.mEmiterYMax = this.mEmiterYMin = location[1] - this.mParentLocation[1];
        } else if (this.hasGravity(gravity, 80)) {
            this.mEmiterYMax = this.mEmiterYMin = location[1] + emiter.getHeight() - this.mParentLocation[1];
        } else if (this.hasGravity(gravity, 16)) {
            this.mEmiterYMax = this.mEmiterYMin = location[1] + emiter.getHeight() / 2 - this.mParentLocation[1];
        } else {
            this.mEmiterYMin = location[1] - this.mParentLocation[1];
            this.mEmiterYMax = location[1] + emiter.getHeight() - this.mParentLocation[1];
        }
    }

    private boolean hasGravity(int gravity, int gravityToCheck) {
        return (gravity & gravityToCheck) == gravityToCheck;
    }

    private void activateParticle(long delay) {
        Particle p = this.mParticles.remove(0);
        p.init();
        for (int i = 0; i < this.mInitializers.size(); ++i) {
            this.mInitializers.get(i).initParticle(p, this.mRandom);
        }
        int particleX = this.getFromRange(this.mEmiterXMin, this.mEmiterXMax);
        int particleY = this.getFromRange(this.mEmiterYMin, this.mEmiterYMax);
        p.configure(this.mTimeToLive, particleX, particleY);
        p.activate(delay, this.mModifiers);
        this.mActiveParticles.add(p);
        ++this.mActivatedParticles;
    }

    private int getFromRange(int minValue, int maxValue) {
        if (minValue == maxValue) {
            return minValue;
        }
        return this.mRandom.nextInt(maxValue - minValue) + minValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUpdate(long miliseconds) {
        while ((this.mEmitingTime > 0L && miliseconds < this.mEmitingTime || this.mEmitingTime == -1L) && !this.mParticles.isEmpty() && (float)this.mActivatedParticles < this.mParticlesPerMilisecond * (float)miliseconds) {
            this.activateParticle(miliseconds);
        }
        ArrayList<Particle> arrayList = this.mActiveParticles;
        synchronized (arrayList) {
            for (int i = 0; i < this.mActiveParticles.size(); ++i) {
                boolean active = this.mActiveParticles.get(i).update(miliseconds);
                if (active) continue;
                Particle p = this.mActiveParticles.remove(i);
                --i;
                this.mParticles.add(p);
            }
        }
        this.mDrawingView.postInvalidate();
    }

    private void cleanupAnimation() {
        this.mParentView.removeView((View)this.mDrawingView);
        this.mDrawingView = null;
        this.mParentView.postInvalidate();
        this.mParticles.addAll(this.mActiveParticles);
    }

    public void stopEmitting() {
        this.mEmitingTime = this.mCurrentTime;
    }

    public void cancel() {
        if (this.mAnimator != null && this.mAnimator.isRunning()) {
            this.mAnimator.cancel();
        }
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer.purge();
            this.cleanupAnimation();
        }
    }

    private void updateParticlesBeforeStartTime(int particlesPerSecond) {
        if (particlesPerSecond == 0) {
            return;
        }
        long currentTimeInMs = this.mCurrentTime / 1000L;
        long framesCount = currentTimeInMs / (long)particlesPerSecond;
        if (framesCount == 0L) {
            return;
        }
        long frameTimeInMs = this.mCurrentTime / framesCount;
        int i = 1;
        while ((long)i <= framesCount) {
            this.onUpdate(frameTimeInMs * (long)i + 1L);
            ++i;
        }
    }

    private static class ParticleTimerTask
    extends TimerTask {
        private final WeakReference<ParticleSystem> mPs;

        public ParticleTimerTask(ParticleSystem ps) {
            this.mPs = new WeakReference<ParticleSystem>(ps);
        }

        @Override
        public void run() {
            if (this.mPs.get() != null) {
                ParticleSystem ps = (ParticleSystem)this.mPs.get();
                ps.onUpdate(ps.mCurrentTime);
                ParticleSystem particleSystem = ps;
                particleSystem.mCurrentTime = particleSystem.mCurrentTime + ps.mUpdateInterval;
            }
        }
    }
}

