/*
 * Decompiled with CFR 0.152.
 */
package com.plattysoft.leonids;

import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import com.plattysoft.leonids.Particle;

public class AnimatedParticle
extends Particle {
    private AnimationDrawable mAnimationDrawable;
    private int mTotalTime;

    public AnimatedParticle(AnimationDrawable animationDrawable) {
        this.mAnimationDrawable = animationDrawable;
        this.mImage = ((BitmapDrawable)this.mAnimationDrawable.getFrame(0)).getBitmap();
        this.mTotalTime = 0;
        for (int i = 0; i < this.mAnimationDrawable.getNumberOfFrames(); ++i) {
            this.mTotalTime += this.mAnimationDrawable.getDuration(i);
        }
    }

    @Override
    public boolean update(long miliseconds) {
        boolean active = super.update(miliseconds);
        if (active) {
            long animationElapsedTime = 0L;
            long realMiliseconds = miliseconds - this.mStartingMilisecond;
            if (realMiliseconds > (long)this.mTotalTime) {
                if (this.mAnimationDrawable.isOneShot()) {
                    return false;
                }
                realMiliseconds %= (long)this.mTotalTime;
            }
            for (int i = 0; i < this.mAnimationDrawable.getNumberOfFrames(); ++i) {
                if ((animationElapsedTime += (long)this.mAnimationDrawable.getDuration(i)) <= realMiliseconds) continue;
                this.mImage = ((BitmapDrawable)this.mAnimationDrawable.getFrame(i)).getBitmap();
                break;
            }
        }
        return active;
    }
}

