/*
 * Decompiled with CFR 0.152.
 */
package com.takusemba.cropme.internal;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.graphics.Rect;
import android.view.View;
import androidx.annotation.VisibleForTesting;
import androidx.dynamicanimation.animation.DynamicAnimation;
import androidx.dynamicanimation.animation.FlingAnimation;
import androidx.dynamicanimation.animation.FloatPropertyCompat;
import androidx.dynamicanimation.animation.SpringAnimation;
import androidx.dynamicanimation.animation.SpringForce;
import com.takusemba.cropme.internal.HorizontalAnimatorImpl;
import com.takusemba.cropme.internal.MoveAnimator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bB?\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0005H\u0002J\b\u0010\u0018\u001a\u00020\u0013H\u0002J\b\u0010\u0019\u001a\u00020\u0016H\u0002J\u0010\u0010\u000b\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0005H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/takusemba/cropme/internal/HorizontalAnimatorImpl;", "Lcom/takusemba/cropme/internal/MoveAnimator;", "targetView", "Landroid/view/View;", "leftBound", "", "rightBound", "maxScale", "(Landroid/view/View;FFF)V", "spring", "Landroidx/dynamicanimation/animation/SpringAnimation;", "fling", "Landroidx/dynamicanimation/animation/FlingAnimation;", "animator", "Landroid/animation/ObjectAnimator;", "(Landroid/view/View;FFFLandroidx/dynamicanimation/animation/SpringAnimation;Landroidx/dynamicanimation/animation/FlingAnimation;Landroid/animation/ObjectAnimator;)V", "updateListener", "Landroidx/dynamicanimation/animation/DynamicAnimation$OnAnimationUpdateListener;", "adjust", "", "adjustToBounds", "rect", "Landroid/graphics/Rect;", "velocity", "cancel", "expectRect", "move", "delta", "outOfBounds", "", "Companion", "cropme_release"})
public final class HorizontalAnimatorImpl
implements MoveAnimator {
    private final DynamicAnimation.OnAnimationUpdateListener updateListener;
    private final View targetView;
    private final float leftBound;
    private final float rightBound;
    private final float maxScale;
    private final SpringAnimation spring;
    private final FlingAnimation fling;
    private final ObjectAnimator animator;
    private static final ObjectAnimator ANIMATOR;
    private static final Companion.VERTICAL_PROPERTY.1 VERTICAL_PROPERTY;
    private static final SpringForce SPRING_FORCE;
    @NotNull
    public static final Companion Companion;

    @Override
    public void move(float delta) {
        this.cancel();
        this.animator.setFloatValues(new float[]{this.targetView.getTranslationX() + delta});
        this.animator.start();
    }

    @Override
    public void adjust() {
        Rect expectedRect = this.expectRect();
        if (this.outOfBounds(expectedRect)) {
            HorizontalAnimatorImpl.adjustToBounds$default(this, expectedRect, 0.0f, 2, null);
        }
    }

    @Override
    public void fling(float velocity) {
        this.cancel();
        this.fling.addUpdateListener(this.updateListener);
        this.fling.setStartVelocity(velocity).start();
    }

    private final Rect expectRect() {
        Rect rect;
        Rect targetRect = new Rect();
        this.targetView.getHitRect(targetRect);
        if (this.maxScale < this.targetView.getScaleX()) {
            int heightDiff = (int)(((float)targetRect.height() - (float)targetRect.height() * (this.maxScale / this.targetView.getScaleY())) / (float)2);
            int widthDiff = (int)(((float)targetRect.width() - (float)targetRect.width() * (this.maxScale / this.targetView.getScaleY())) / (float)2);
            rect = new Rect(targetRect.left + widthDiff, targetRect.top + heightDiff, targetRect.right - widthDiff, targetRect.bottom - heightDiff);
        } else if (this.targetView.getScaleX() < 1.0f) {
            int heightDiff = (this.targetView.getHeight() - targetRect.height()) / 2;
            int widthDiff = (this.targetView.getWidth() - targetRect.width()) / 2;
            rect = new Rect(targetRect.left + widthDiff, targetRect.top + heightDiff, targetRect.right - widthDiff, targetRect.bottom - heightDiff);
        } else {
            rect = targetRect;
        }
        return rect;
    }

    private final boolean outOfBounds(Rect rect) {
        return this.leftBound < (float)rect.left || (float)rect.right < this.rightBound;
    }

    private final void adjustToBounds(Rect rect, float velocity) {
        float scale = this.maxScale < this.targetView.getScaleX() ? this.maxScale : (this.targetView.getScaleX() < 1.0f ? 1.0f : this.targetView.getScaleX());
        float diff = ((float)this.targetView.getWidth() * scale - (float)this.targetView.getWidth()) / (float)2;
        if (this.leftBound < (float)rect.left) {
            this.cancel();
            float finalPosition = this.leftBound + diff;
            ((SpringAnimation)this.spring.setStartVelocity(velocity)).animateToFinalPosition(finalPosition);
        } else if ((float)rect.right < this.rightBound) {
            this.cancel();
            float finalPosition = this.rightBound - (float)this.targetView.getWidth() - diff;
            ((SpringAnimation)this.spring.setStartVelocity(velocity)).animateToFinalPosition(finalPosition);
        }
    }

    static /* synthetic */ void adjustToBounds$default(HorizontalAnimatorImpl horizontalAnimatorImpl, Rect rect, float f, int n, Object object) {
        if ((n & 2) != 0) {
            f = 0.0f;
        }
        horizontalAnimatorImpl.adjustToBounds(rect, f);
    }

    private final void cancel() {
        this.animator.cancel();
        this.spring.cancel();
        this.fling.cancel();
        this.fling.removeUpdateListener(this.updateListener);
    }

    @VisibleForTesting
    public HorizontalAnimatorImpl(@NotNull View targetView, float leftBound, float rightBound, float maxScale, @NotNull SpringAnimation spring, @NotNull FlingAnimation fling, @NotNull ObjectAnimator animator) {
        Intrinsics.checkNotNullParameter((Object)targetView, (String)"targetView");
        Intrinsics.checkNotNullParameter((Object)spring, (String)"spring");
        Intrinsics.checkNotNullParameter((Object)fling, (String)"fling");
        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
        this.targetView = targetView;
        this.leftBound = leftBound;
        this.rightBound = rightBound;
        this.maxScale = maxScale;
        this.spring = spring;
        this.fling = fling;
        this.animator = animator;
        this.updateListener = new DynamicAnimation.OnAnimationUpdateListener(this){
            final /* synthetic */ HorizontalAnimatorImpl this$0;

            public final void onAnimationUpdate(DynamicAnimation<DynamicAnimation<?>> $noName_0, float $noName_1, float velocity) {
                Rect expectedRect = HorizontalAnimatorImpl.access$expectRect(this.this$0);
                if (HorizontalAnimatorImpl.access$outOfBounds(this.this$0, expectedRect)) {
                    HorizontalAnimatorImpl.access$adjustToBounds(this.this$0, expectedRect, velocity);
                }
            }
            {
                this.this$0 = horizontalAnimatorImpl;
            }
        };
        this.animator.setTarget((Object)this.targetView);
    }

    public HorizontalAnimatorImpl(@NotNull View targetView, float leftBound, float rightBound, float maxScale) {
        Intrinsics.checkNotNullParameter((Object)targetView, (String)"targetView");
        SpringAnimation springAnimation = new SpringAnimation((Object)targetView, (FloatPropertyCompat)VERTICAL_PROPERTY).setSpring(SPRING_FORCE);
        Intrinsics.checkNotNullExpressionValue((Object)springAnimation, (String)"SpringAnimation(targetVi\u2026).setSpring(SPRING_FORCE)");
        FlingAnimation flingAnimation = new FlingAnimation((Object)targetView, (FloatPropertyCompat)DynamicAnimation.X).setFriction(3.0f);
        Intrinsics.checkNotNullExpressionValue((Object)flingAnimation, (String)"FlingAnimation(targetVie\u2026.X).setFriction(FRICTION)");
        this(targetView, leftBound, rightBound, maxScale, springAnimation, flingAnimation, ANIMATOR);
    }

    static {
        Companion = new Companion(null);
        ObjectAnimator objectAnimator = new ObjectAnimator();
        boolean bl = false;
        boolean bl2 = false;
        ObjectAnimator $this$apply = objectAnimator;
        boolean bl3 = false;
        $this$apply.setProperty(View.TRANSLATION_X);
        $this$apply.setInterpolator((TimeInterpolator)null);
        $this$apply.setDuration(0L);
        ANIMATOR = objectAnimator;
        VERTICAL_PROPERTY = new FloatPropertyCompat<View>("X"){

            public float getValue(@NotNull View view) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                return view.getX();
            }

            public void setValue(@NotNull View view, float value) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                view.setX(value);
            }
        };
        SPRING_FORCE = new SpringForce().setStiffness(50.0f).setDampingRatio(1.0f);
    }

    public static final /* synthetic */ Rect access$expectRect(HorizontalAnimatorImpl $this) {
        return $this.expectRect();
    }

    public static final /* synthetic */ boolean access$outOfBounds(HorizontalAnimatorImpl $this, Rect rect) {
        return $this.outOfBounds(rect);
    }

    public static final /* synthetic */ void access$adjustToBounds(HorizontalAnimatorImpl $this, Rect rect, float velocity) {
        $this.adjustToBounds(rect, velocity);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000!\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003*\u0001\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/takusemba/cropme/internal/HorizontalAnimatorImpl$Companion;", "", "()V", "ANIMATOR", "Landroid/animation/ObjectAnimator;", "SPRING_FORCE", "Landroidx/dynamicanimation/animation/SpringForce;", "kotlin.jvm.PlatformType", "VERTICAL_PROPERTY", "com/takusemba/cropme/internal/HorizontalAnimatorImpl$Companion$VERTICAL_PROPERTY$1", "Lcom/takusemba/cropme/internal/HorizontalAnimatorImpl$Companion$VERTICAL_PROPERTY$1;", "cropme_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

