/*
 * Decompiled with CFR 0.152.
 */
package com.takusemba.cropme;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.takusemba.cropme.CropOverlay;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/takusemba/cropme/CircleCropOverlay;", "Lcom/takusemba/cropme/CropOverlay;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "cropOverlayAttrs", "(Landroid/content/Context;Landroid/util/AttributeSet;ILandroid/util/AttributeSet;)V", "drawBorder", "", "canvas", "Landroid/graphics/Canvas;", "paint", "Landroid/graphics/Paint;", "drawCrop", "cropme_release"})
public final class CircleCropOverlay
extends CropOverlay {
    @Override
    public void drawCrop(@NotNull Canvas canvas, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        RectF rectF = this.getFrame();
        if (rectF == null) {
            return;
        }
        RectF frameRect = rectF;
        float x = (float)this.getMeasuredWidth() / 2.0f;
        float y = (float)this.getMeasuredHeight() / 2.0f;
        float frameWidth = frameRect.width();
        float frameHeight = frameRect.height();
        boolean bl = false;
        float radius = Math.max(frameWidth, frameHeight) / 2.0f;
        canvas.drawCircle(x, y, radius, paint);
    }

    @Override
    public void drawBorder(@NotNull Canvas canvas, @NotNull Paint paint) {
        float z;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        RectF rectF = this.getFrame();
        if (rectF == null) {
            return;
        }
        RectF frameRect = rectF;
        float frameWidth = frameRect.width();
        float frameHeight = frameRect.height();
        float left = ((float)this.getWidth() - frameWidth) / 2.0f;
        float top = ((float)this.getHeight() - frameHeight) / 2.0f;
        float right = ((float)this.getWidth() + frameWidth) / 2.0f;
        float bottom = ((float)this.getHeight() + frameHeight) / 2.0f;
        float cx = (float)this.getMeasuredWidth() / 2.0f;
        float cy = (float)this.getMeasuredHeight() / 2.0f;
        boolean bl = false;
        float radius = Math.max(frameWidth, frameHeight) / 2.0f;
        canvas.drawCircle(cx, cy, radius, paint);
        float x = radius / (float)3;
        float f = z = radius;
        int n = 2;
        boolean bl2 = false;
        float f2 = (float)Math.pow(f, n);
        f = x;
        n = 2;
        bl2 = false;
        f = f2 - (float)Math.pow(f, n);
        n = 0;
        float y = (float)Math.sqrt(f);
        float d = radius - y;
        float borderHeight = frameHeight / (float)3;
        canvas.drawLine(left + d, top + borderHeight, right - d, top + borderHeight, paint);
        canvas.drawLine(left + d, top + borderHeight * (float)2, right - d, top + borderHeight * (float)2, paint);
        float borderWidth = frameWidth / (float)3;
        canvas.drawLine(left + borderWidth, top + d, left + borderWidth, bottom - d, paint);
        canvas.drawLine(left + borderWidth * (float)2, top + d, left + borderWidth * (float)2, bottom - d, paint);
    }

    @JvmOverloads
    public CircleCropOverlay(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, @Nullable AttributeSet cropOverlayAttrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr, cropOverlayAttrs);
    }

    public /* synthetic */ CircleCropOverlay(Context context, AttributeSet attributeSet, int n, AttributeSet attributeSet2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            attributeSet2 = attributeSet;
        }
        this(context, attributeSet, n, attributeSet2);
    }

    @JvmOverloads
    public CircleCropOverlay(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, null, 8, null);
    }

    @JvmOverloads
    public CircleCropOverlay(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, null, 12, null);
    }

    @JvmOverloads
    public CircleCropOverlay(@NotNull Context context) {
        this(context, null, 0, null, 14, null);
    }
}

