/*
 * Decompiled with CFR 0.152.
 */
package ch.sla.jdbcperflogger.model;

import ch.sla.jdbcperflogger.StatementType;
import ch.sla.jdbcperflogger.model.AbstractBeforeStatementExecutionLog;
import java.util.UUID;

public class StatementLog
extends AbstractBeforeStatementExecutionLog {
    private static final long serialVersionUID = 1L;
    private final String rawSql;
    private final String filledSql;
    private final boolean preparedStatement;

    public StatementLog(UUID connectionId, UUID logId, long timestamp, StatementType statementType, String sql, String threadName, int timeout, boolean autoCommit) {
        super(connectionId, logId, timestamp, statementType, threadName, timeout, autoCommit);
        this.rawSql = sql;
        this.filledSql = sql;
        this.preparedStatement = false;
    }

    public StatementLog(UUID connectionId, UUID logId, long timestamp, StatementType statementType, String rawSql, String filledSql, String threadName, int timeout, boolean autoCommit) {
        super(connectionId, logId, timestamp, statementType, threadName, timeout, autoCommit);
        this.rawSql = rawSql;
        this.filledSql = filledSql;
        this.preparedStatement = true;
    }

    public String getRawSql() {
        return this.rawSql;
    }

    public String getFilledSql() {
        return this.filledSql;
    }

    public boolean isPreparedStatement() {
        return this.preparedStatement;
    }

    public String toString() {
        return "StatementLog[logId=" + this.getLogId() + ", timestamp=" + this.getTimestamp() + ", statementType=" + (Object)((Object)this.getStatementType()) + ", threadName=" + this.getThreadName() + ", timeout=" + this.getTimeout() + ", autocommit=" + this.isAutoCommit() + ", rawSql=" + this.rawSql + ", filledSql=" + this.filledSql + ", preparedStatement=" + this.preparedStatement + "]";
    }
}

