/*
 * Decompiled with CFR 0.152.
 */
package ch.sla.jdbcperflogger.driver;

import ch.sla.jdbcperflogger.DatabaseType;
import ch.sla.jdbcperflogger.TxCompletionType;
import ch.sla.jdbcperflogger.driver.LoggingPreparedStatementInvocationHandler;
import ch.sla.jdbcperflogger.driver.LoggingStatementInvocationHandler;
import ch.sla.jdbcperflogger.driver.Utils;
import ch.sla.jdbcperflogger.logger.PerfLogger;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Properties;
import java.util.UUID;
import javax.annotation.Nullable;

public class LoggingConnectionInvocationHandler
implements InvocationHandler {
    private final UUID connectionUuid = UUID.randomUUID();
    private final int connectionId;
    private final Connection wrappedConnection;
    private final DatabaseType databaseType;
    private final String url;
    private final Properties connectionProperties;

    LoggingConnectionInvocationHandler(int connectionId, Connection wrappedConnection, String url, Properties connectionProperties) {
        this.connectionId = connectionId;
        this.wrappedConnection = wrappedConnection;
        this.databaseType = Utils.getDatabaseType(wrappedConnection);
        this.url = url;
        this.connectionProperties = connectionProperties;
    }

    @Override
    @Nullable
    public Object invoke(@Nullable Object proxy, @Nullable Method method, @Nullable Object[] args) throws Throwable {
        Object result;
        assert (method != null);
        String methodName = method.getName();
        TxCompletionType txCompletionType = null;
        String savePointDescription = null;
        if ("commit".equals(methodName)) {
            txCompletionType = TxCompletionType.COMMIT;
        } else if ("rollback".equals(methodName)) {
            if (args == null) {
                txCompletionType = TxCompletionType.ROLLBACK;
            } else {
                txCompletionType = TxCompletionType.ROLLBACK_TO_SAVEPOINT;
                Savepoint savepoint = (Savepoint)args[0];
                savePointDescription = savepoint.toString();
            }
        } else if ("setSavepoint".equals(methodName)) {
            txCompletionType = TxCompletionType.SET_SAVE_POINT;
        }
        long startTimeStamp = System.currentTimeMillis();
        long startNanos = -1L;
        if (txCompletionType != null) {
            startNanos = System.nanoTime();
        }
        if ((result = Utils.invokeUnwrapException(this.wrappedConnection, method, args)) != null) {
            if ("createStatement".equals(methodName)) {
                return Proxy.newProxyInstance(LoggingConnectionInvocationHandler.class.getClassLoader(), Utils.extractAllInterfaces(result.getClass()), (InvocationHandler)new LoggingStatementInvocationHandler(this.connectionUuid, (Statement)result, this.databaseType));
            }
            if (("prepareStatement".equals(methodName) || "prepareCall".equals(methodName)) && args != null) {
                return Proxy.newProxyInstance(LoggingConnectionInvocationHandler.class.getClassLoader(), Utils.extractAllInterfaces(result.getClass()), (InvocationHandler)new LoggingPreparedStatementInvocationHandler(this.connectionUuid, (PreparedStatement)result, (String)args[0], this.databaseType));
            }
        }
        if (txCompletionType != null) {
            if (txCompletionType == TxCompletionType.SET_SAVE_POINT && result != null) {
                Savepoint savepoint = (Savepoint)result;
                savePointDescription = savepoint.toString();
            }
            PerfLogger.logTransactionComplete(this.connectionUuid, startTimeStamp, txCompletionType, System.nanoTime() - startNanos, savePointDescription);
        }
        return result;
    }

    public UUID getConnectionUuid() {
        return this.connectionUuid;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public String getUrl() {
        return this.url;
    }

    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }
}

