package com.proximities.sdk.json.model.partner;

import android.os.Parcel;
import android.os.Parcelable;

import androidx.annotation.Keep;

import com.proximities.sdk.json.model.transmitter.Campaign;
import com.proximities.sdk.json.model.transmitter.Transmitter;

import java.util.List;

/**
 * Created by william on 13/12/15.
 */
@Keep
public class Poi implements Parcelable{

    private double distance;
    private int id;
    private String name;
    private String city;
    private String zipcode;
    private String address;
    private double latitude;
    private double longitude;
    private String image;
    private int likes;
    private List<Transmitter> transmitters;
    private List<Campaign> animations;
    private int categoryId;
    private String description;
    private String phone;
    private String type;
    private int backgroundFetch;
    private int followed;
    private String ipsId;
    private double animationRadius;

    public Poi(){}

    public double getDistance() {
        return distance;
    }
    public void setDistance(double distance) {
        this.distance = distance;
    }
    public int getId() {
        return id;
    }
    public void setId(int id) {
        this.id = id;
    }
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }
    public String getCity() {
        return city;
    }
    public void setCity(String city) {
        this.city = city;
    }
    public String getZipcode() {
        return zipcode;
    }
    public void setZipcode(String zipCode) {
        this.zipcode = zipCode;
    }
    public String getAddress() {
        return address;
    }
    public void setAddress(String address) {
        this.address = address;
    }
    public double getLatitude() {
        return latitude;
    }
    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }
    public double getLongitude() {
        return longitude;
    }
    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }
    public String getImage() {
        return image;
    }
    public void setImage(String image) {
        this.image = image;
    }
    public int getLikes() {
        return likes;
    }
    public void setLikes(int likes) {
        this.likes = likes;
    }
    public List<Transmitter> getTransmitters() {
        return transmitters;
    }
    public void setTransmitters(List<Transmitter> transmitters) {
        this.transmitters = transmitters;
    }
    public List<Campaign> getCampaigns() {
        return animations;
    }
    public void setCampaigns(List<Campaign> campaigns) {
        this.animations = campaigns;
    }

    public void setCategoryId(int categoryId) {
        this.categoryId = categoryId;
    }
    public int getCategoryId() {
        return categoryId;
    }
    public void setDescription(String description) {
        this.description = description;
    }
    public String getDescription() {
        return description;
    }
    public void setPhone(String phone){this.phone = phone;}
    public String getPhone(){return phone;}
    public int getBackgroundFetch() {
        return backgroundFetch;
    }

    public void setBackgroundFetch(int backgroundFetch) {
        this.backgroundFetch = backgroundFetch;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }
    public int getFollowed() {
        return followed;
    }

    public void setFollowed(int followed) {
        this.followed = followed;
    }

    public String getIpsId() {
        return ipsId;
    }

    public void setIpsId(String ipsId) {
        this.ipsId = ipsId;
    }

    public double getAnimationRadius() {
        return animationRadius;
    }

    public void setAnimationRadius(double animationRadius) {
        this.animationRadius = animationRadius;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int i) {
        dest.writeInt(this.id);
        dest.writeString(this.name);
    }

    private Poi(Parcel in) {
        this.id = in.readInt();
        this.name = in.readString();
    }

    public static final Creator<Poi> CREATOR = new Creator<Poi>() {
        public Poi createFromParcel(Parcel source) {
            return new Poi(source);
        }

        public Poi[] newArray(int size) {
            return new Poi[size];
        }
    };
}
