package com.proximities.sdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;

import androidx.annotation.RequiresApi;

import com.proximities.sdk.util.ProximitiesConstants;

public class ForegroundNotificationReceiver extends BroadcastReceiver {

    @RequiresApi(api = Build.VERSION_CODES.O)
    @Override
    public void onReceive(Context context, Intent intent) {
        Intent intentService = new Intent(context, ProximitiesBeaconService.class);
        intentService.putExtra("action", ProximitiesConstants.BEACON_STOP_FOREGROUND_SERVICE);
        context.startForegroundService(intentService);
    }
}
